/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupStopCommand
extends ControlCommand {
    private final Argument nameArg;

    public DeploymentGroupStopCommand(Subparser parser) {
        super(parser);
        parser.help("Stop a deployment-group or abort a rolling-update");
        this.nameArg = parser.addArgument(new String[]{"name"}).required(true).help("Deployment group name");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        String name = options.getString(this.nameArg.getDest());
        int status = (Integer)client.stopDeploymentGroup(name).get();
        if (status == Response.Status.NO_CONTENT.getStatusCode()) {
            out.println(String.format("Deployment-group %s stopped", name));
            return 0;
        }
        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
            out.println(String.format("Deployment-group %s not found", name));
            return 1;
        }
        out.println(String.format("Failed to stop deployment-group %s. Status: %d", name, status));
        return 1;
    }
}

