/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.DockerVersion;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class HostListCommand
extends ControlCommand {
    private final Argument quietArg;
    private final Argument patternArg;
    private final Argument fullArg;
    private final Argument statusArg;
    private final Argument hostSelectorsArg;
    private final String statusChoicesString;

    public HostListCommand(Subparser parser) {
        super(parser);
        Collection statusChoices = Collections2.transform(Arrays.asList(HostStatus.Status.values()), (Function)new Function<HostStatus.Status, String>(){

            public String apply(HostStatus.Status input) {
                return input.toString();
            }
        });
        this.statusChoicesString = Joiner.on((String)", ").join((Iterable)statusChoices);
        parser.help("list hosts");
        this.patternArg = parser.addArgument(new String[]{"pattern"}).nargs("?").setDefault((Object)"").help("Pattern to filter hosts with");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print host names");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full host names.");
        this.statusArg = parser.addArgument(new String[]{"--status"}).nargs("?").choices((Object[])statusChoices.toArray(new String[statusChoices.size()])).help("Filter hosts by its status. Valid statuses are: " + this.statusChoicesString);
        this.hostSelectorsArg = parser.addArgument(new String[]{"-s", "--selector"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Host selector expression. The list of hosts will be filtered to match only those whose labels match all of the supplied expressions. Multiple selector expressions can be specified with multiple `-s` arguments (e.g. `-s site=foo -s bar!=yes`). Supported operators are '=', '!=', 'in' and 'notin'.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        String pattern = options.getString(this.patternArg.getDest());
        List selectorArgValue = options.getList(this.hostSelectorsArg.getDest());
        ImmutableSet selectors = ImmutableSet.copyOf((Collection)selectorArgValue);
        List hosts = pattern.isEmpty() && selectors.isEmpty() ? (List)client.listHosts().get() : (!pattern.isEmpty() && selectors.isEmpty() ? (List)client.listHosts(pattern).get() : (pattern.isEmpty() && !selectors.isEmpty() ? (List)client.listHosts((Set)selectors).get() : (List)client.listHosts(pattern, (Set)selectors).get()));
        HashMap queryParams = Maps.newHashMap();
        String statusFilter = options.getString(this.statusArg.getDest());
        if (!Strings.isNullOrEmpty((String)statusFilter)) {
            try {
                HostStatus.Status.valueOf((String)statusFilter);
                queryParams.put("status", statusFilter);
            }
            catch (IllegalArgumentException ignored) {
                throw new IllegalArgumentException("Invalid status. Valid statuses are: " + this.statusChoicesString);
            }
        }
        boolean full = options.getBoolean(this.fullArg.getDest());
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        if (hosts.isEmpty()) {
            if (json) {
                out.println("{ }");
            } else if (!quiet && !Strings.isNullOrEmpty((String)pattern)) {
                out.printf("host pattern %s matched no hosts%n", pattern);
            }
            return 1;
        }
        List sortedHosts = Ordering.natural().sortedCopy((Iterable)hosts);
        if (quiet) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)sortedHosts));
            } else {
                for (String host : sortedHosts) {
                    out.println(Output.formatHostname(full, host));
                }
            }
        } else {
            Map statuses = (Map)client.hostStatuses(hosts, (Map)queryParams).get();
            if (json) {
                TreeMap sorted = Maps.newTreeMap();
                sorted.putAll(statuses);
                out.println(Json.asPrettyStringUnchecked((Object)sorted));
            } else {
                Table table = Output.table(out);
                table.row("HOST", "STATUS", "DEPLOYED", "RUNNING", "CPUS", "MEM", "LOAD AVG", "MEM USAGE", "OS", "HELIOS", "DOCKER", "LABELS");
                for (Map.Entry e : statuses.entrySet()) {
                    String status;
                    String docker;
                    String os;
                    String loadAvg;
                    String mem;
                    String cpus;
                    String memUsage;
                    String host = (String)e.getKey();
                    HostStatus s = (HostStatus)e.getValue();
                    if (s == null) continue;
                    HashSet runningDeployedJobs = Sets.newHashSet();
                    for (JobId jobId : s.getJobs().keySet()) {
                        TaskStatus taskStatus = (TaskStatus)s.getStatuses().get(jobId);
                        if (taskStatus == null || taskStatus.getState() != TaskStatus.State.RUNNING) continue;
                        runningDeployedJobs.add(taskStatus);
                    }
                    HostInfo hi = s.getHostInfo();
                    if (hi != null) {
                        long free = hi.getMemoryFreeBytes();
                        long total = hi.getMemoryTotalBytes();
                        memUsage = String.format("%.2f", Float.valueOf((float)(total - free) / (float)total));
                        cpus = String.valueOf(hi.getCpus());
                        mem = hi.getMemoryTotalBytes() / 0x40000000L + " gb";
                        loadAvg = String.format("%.2f", hi.getLoadAvg());
                        os = hi.getOsName() + " " + hi.getOsVersion();
                        DockerVersion dv = hi.getDockerVersion();
                        docker = dv != null ? String.format("%s (%s)", dv.getVersion(), dv.getApiVersion()) : "";
                    } else {
                        docker = "";
                        os = "";
                        loadAvg = "";
                        mem = "";
                        cpus = "";
                        memUsage = "";
                    }
                    String version = s.getAgentInfo() != null ? (String)Optional.fromNullable((Object)s.getAgentInfo().getVersion()).or((Object)"") : "";
                    String string = status = s.getStatus() == HostStatus.Status.UP ? "Up" : "Down";
                    if (s.getAgentInfo() != null) {
                        long startTime = s.getAgentInfo().getStartTime();
                        long upTime = s.getAgentInfo().getUptime();
                        status = s.getStatus() == HostStatus.Status.UP ? status + " " + Output.humanDuration(System.currentTimeMillis() - startTime) : status + " " + Output.humanDuration(System.currentTimeMillis() - startTime - upTime);
                    }
                    String hostLabels = Joiner.on((String)", ").withKeyValueSeparator("=").join(s.getLabels());
                    table.row(Output.formatHostname(full, host), status, s.getJobs().size(), runningDeployedJobs.size(), cpus, mem, loadAvg, memUsage, os, version, docker, hostLabels);
                }
                table.print();
            }
        }
        return 0;
    }
}

