/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.common.protocol.TaskStatusEvents;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JobHistoryCommand
extends ControlCommand {
    private final Argument jobIdArg;

    public JobHistoryCommand(Subparser parser) {
        super(parser);
        parser.help("see the run history of a job");
        this.jobIdArg = parser.addArgument(new String[]{"jobid"}).help("Job id");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        String jobIdString = options.getString(this.jobIdArg.getDest());
        Map jobs = (Map)client.jobs(jobIdString).get();
        if (jobs.size() == 0) {
            out.printf("Unknown job: %s%n", jobIdString);
            return 1;
        }
        if (jobs.size() > 1) {
            out.printf("Ambiguous job id: %s%n", jobIdString);
            return 1;
        }
        JobId jobId = (JobId)Iterables.getLast(jobs.keySet());
        TaskStatusEvents result = (TaskStatusEvents)client.jobHistory(jobId).get();
        if (json) {
            out.println(Json.asPrettyStringUnchecked((Object)result));
            return 0;
        }
        Table table = Output.table(out);
        table.row("HOST", "TIMESTAMP", "STATE", "THROTTLED", "CONTAINERID");
        List events = result.getEvents();
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss.SSS");
        for (TaskStatusEvent event : events) {
            String host = (String)Preconditions.checkNotNull((Object)event.getHost());
            long timestamp = (Long)Preconditions.checkNotNull((Object)event.getTimestamp());
            TaskStatus status = (TaskStatus)Preconditions.checkNotNull((Object)event.getStatus());
            TaskStatus.State state = (TaskStatus.State)Preconditions.checkNotNull((Object)status.getState());
            String containerId = status.getContainerId();
            containerId = containerId == null ? "<none>" : containerId;
            table.row(host, format.print(timestamp), state, status.getThrottled(), containerId);
        }
        table.print();
        return 0;
    }
}

