/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.Sets;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class MasterListCommand
extends ControlCommand {
    private final Argument fullArg;

    public MasterListCommand(Subparser parser) {
        super(parser);
        parser.help("list masters");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full hostnames");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        List masters = (List)client.listMasters().get();
        boolean full = options.getBoolean(this.fullArg.getDest());
        TreeSet sortedMasters = Sets.newTreeSet();
        if (json) {
            for (String host : masters) {
                sortedMasters.add(Output.formatHostname(full, host));
            }
            out.println(Json.asPrettyStringUnchecked((Object)sortedMasters));
        } else {
            for (String host : masters) {
                out.println(Output.formatHostname(full, host));
            }
        }
        return 0;
    }
}

