/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.spotify.helios.common.descriptors.PortMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PortMappingParser {
    private static final Pattern PATTERN = Pattern.compile("(?<n>[_\\-\\w]+)=((?<ip>([0-9]{1,3}.){3}[0-9]{1,3}):)?(?<i>\\d+)(:(?<e>\\d+))?(/(?<p>\\w+))?");

    private PortMappingParser() {
    }

    static PortMappingWithName parsePortMapping(String portSpec) {
        Matcher matcher = PATTERN.matcher(portSpec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad port mapping: " + portSpec);
        }
        String name = matcher.group("n");
        String ip = matcher.group("ip");
        int internal = Integer.parseInt(matcher.group("i"));
        Integer external = PortMappingParser.nullOrInteger(matcher.group("e"));
        String protocol = (String)Optional.fromNullable((Object)matcher.group("p")).or((Object)"tcp");
        return PortMappingWithName.create(name, PortMapping.builder().ip(ip).internalPort(internal).externalPort(external).protocol(protocol).build());
    }

    static Map<String, PortMapping> parsePortMappings(List<String> portSpecs) {
        HashMap explicitPorts = Maps.newHashMap();
        for (String spec : portSpecs) {
            PortMappingWithName portMappingWithName = PortMappingParser.parsePortMapping(spec);
            String name = portMappingWithName.name();
            if (explicitPorts.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate port mapping name: " + name);
            }
            explicitPorts.put(name, portMappingWithName.portMapping());
        }
        return ImmutableMap.copyOf((Map)explicitPorts);
    }

    private static Integer nullOrInteger(String str) {
        return str == null ? null : Integer.valueOf(str);
    }

    static class PortMappingWithName {
        private final String name;
        private final PortMapping portMapping;

        private PortMappingWithName(String name, PortMapping portMapping) {
            this.name = name;
            this.portMapping = portMapping;
        }

        static PortMappingWithName create(String name, PortMapping portMapping) {
            return new PortMappingWithName(name, portMapping);
        }

        String name() {
            return this.name;
        }

        PortMapping portMapping() {
            return this.portMapping;
        }
    }
}

