/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CliConfig {
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String DOMAIN_SCHEME = "domain";
    private static final String MASTER_ENDPOINTS_KEY = "masterEndpoints";
    private static final String DOMAINS_KEY = "domains";
    private static final String SRV_NAME_KEY = "srvName";
    private static final String CONFIG_DIR = ".helios";
    private static final String CONFIG_FILE = "config";
    private static final String CONFIG_PATH = ".helios" + File.separator + "config";
    public static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private final String username = System.getProperty("user.name");
    private final List<String> domains;
    private final String srvName;
    private final List<URI> masterEndpoints;

    public CliConfig(List<String> domains, String srvName, List<URI> masterEndpoints) {
        this.domains = (List)Preconditions.checkNotNull(domains);
        this.srvName = (String)Preconditions.checkNotNull((Object)srvName);
        this.masterEndpoints = (List)Preconditions.checkNotNull(masterEndpoints);
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public String getDomainsString() {
        return Joiner.on((String)",").join(this.domains);
    }

    public String getSrvName() {
        return this.srvName;
    }

    public List<URI> getMasterEndpoints() {
        return this.masterEndpoints;
    }

    public static String getConfigDirName() {
        return CONFIG_DIR;
    }

    public static String getConfigFileName() {
        return CONFIG_FILE;
    }

    public static CliConfig fromUserConfig(Map<String, String> environmentVariables) throws IOException, URISyntaxException {
        String userHome = System.getProperty("user.home");
        String defaults = userHome + File.separator + CONFIG_PATH;
        File defaultsFile = new File(defaults);
        return CliConfig.fromFile(defaultsFile, environmentVariables);
    }

    public static CliConfig fromFile(File defaultsFile, Map<String, String> environmentVariables) throws IOException, URISyntaxException {
        Config config = defaultsFile.exists() && defaultsFile.canRead() ? ConfigFactory.parseFile((File)defaultsFile) : ConfigFactory.empty();
        return CliConfig.fromEnvVar(config, environmentVariables);
    }

    public static CliConfig fromEnvVar(Config config, Map<String, String> environmentVariables) throws URISyntaxException {
        String scheme;
        String master = environmentVariables.get("HELIOS_MASTER");
        if (master == null) {
            return CliConfig.fromConfig(config);
        }
        URI uri = new URI(master);
        Config configFromEnvVar = ConfigFactory.empty();
        if (config.hasPath(SRV_NAME_KEY)) {
            configFromEnvVar = configFromEnvVar.withValue(SRV_NAME_KEY, config.getValue(SRV_NAME_KEY));
        }
        if (Strings.isNullOrEmpty((String)(scheme = uri.getScheme()))) {
            throw new RuntimeException("Your environment variable HELIOS_MASTER=" + master + " is not a valid URI with a scheme.");
        }
        switch (scheme) {
            case "domain": {
                configFromEnvVar = configFromEnvVar.withValue(DOMAINS_KEY, (ConfigValue)ConfigValueFactory.fromIterable((Iterable)ImmutableList.of((Object)uri.getHost())));
                break;
            }
            case "https": 
            case "http": {
                configFromEnvVar = configFromEnvVar.withValue(MASTER_ENDPOINTS_KEY, (ConfigValue)ConfigValueFactory.fromIterable((Iterable)ImmutableList.of((Object)master)));
                break;
            }
            default: {
                throw new RuntimeException("Your environment variable HELIOS_MASTER=" + master + " does not have a valid scheme.");
            }
        }
        return CliConfig.fromConfig(configFromEnvVar);
    }

    public static CliConfig fromConfig(Config config) {
        Preconditions.checkNotNull((Object)config);
        ImmutableMap defaultSettings = ImmutableMap.of((Object)DOMAINS_KEY, EMPTY_STRING_LIST, (Object)SRV_NAME_KEY, (Object)"helios", (Object)MASTER_ENDPOINTS_KEY, EMPTY_STRING_LIST);
        Config configWithDefaults = config.withFallback((ConfigMergeable)ConfigFactory.parseMap((Map)defaultSettings));
        List domains = configWithDefaults.getStringList(DOMAINS_KEY);
        String srvName = configWithDefaults.getString(SRV_NAME_KEY);
        ArrayList masterEndpoints = Lists.newArrayList();
        for (String endpoint : configWithDefaults.getStringList(MASTER_ENDPOINTS_KEY)) {
            masterEndpoints.add(URI.create(endpoint));
        }
        return new CliConfig(domains, srvName, masterEndpoints);
    }
}

