/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.spotify.helios.cli.JobStatusTable;
import com.spotify.helios.cli.Table;
import java.io.PrintStream;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.xbill.DNS.Name;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.TextParseException;

public class Output {
    public static String humanDuration(long millis) {
        return Output.humanDuration(Duration.millis((long)millis));
    }

    public static String humanDuration(Duration dur) {
        Period p = dur.toPeriod().normalizedStandard();
        if (dur.getStandardSeconds() == 0L) {
            return "0 seconds";
        }
        if (dur.getStandardSeconds() < 60L) {
            return String.format("%d second%s", p.getSeconds(), p.getSeconds() > 1 ? "s" : "");
        }
        if (dur.getStandardMinutes() < 60L) {
            return String.format("%d minute%s", p.getMinutes(), p.getMinutes() > 1 ? "s" : "");
        }
        if (dur.getStandardHours() < 24L) {
            return String.format("%d hour%s", p.getHours(), p.getHours() > 1 ? "s" : "");
        }
        return String.format("%d day%s", dur.getStandardDays(), dur.getStandardDays() > 1L ? "s" : "");
    }

    public static Table table(PrintStream out) {
        return new Table(out);
    }

    public static JobStatusTable jobStatusTable(PrintStream out, boolean full) {
        return new JobStatusTable(out, full);
    }

    public static String shortHostname(String host) {
        Name[] searchPath;
        Name hostname;
        Name root = Name.fromConstantString((String)".");
        try {
            hostname = Name.fromString((String)host, (Name)root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid hostname '" + host + "'");
        }
        ResolverConfig currentConfig = ResolverConfig.getCurrentConfig();
        if (currentConfig != null && (searchPath = currentConfig.searchPath()) != null) {
            for (Name domain : searchPath) {
                if (!hostname.subdomain(domain)) continue;
                return hostname.relativize(domain).toString();
            }
        }
        return hostname.toString();
    }

    public static String formatHostname(boolean full, String host) {
        return full ? host : Output.shortHostname(host);
    }
}

