/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.common.Resolver;
import java.net.URI;
import java.util.List;

public abstract class Target {
    private final String name;

    Target(String name) {
        this.name = name;
    }

    public abstract Supplier<List<URI>> getEndpointSupplier();

    public String getName() {
        return this.name;
    }

    public static Target from(URI endpoint) {
        return new ExplicitTarget(endpoint);
    }

    public static List<Target> from(String srvName, Iterable<String> domains) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String domain : domains) {
            builder.add((Object)new SrvTarget(srvName, domain));
        }
        return builder.build();
    }

    private static class ExplicitTarget
    extends Target {
        private final URI endpoint;

        private ExplicitTarget(URI endpoint) {
            super(endpoint.toString());
            this.endpoint = endpoint;
        }

        public URI getEndpoint() {
            return this.endpoint;
        }

        @Override
        public Supplier<List<URI>> getEndpointSupplier() {
            ImmutableList endpoints = ImmutableList.of((Object)this.endpoint);
            return Suppliers.ofInstance((Object)endpoints);
        }

        public String toString() {
            return this.endpoint.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExplicitTarget explicitTarget = (ExplicitTarget)obj;
            return this.endpoint.equals(explicitTarget.getEndpoint());
        }

        public int hashCode() {
            return this.endpoint != null ? this.endpoint.hashCode() : 0;
        }
    }

    private static class SrvTarget
    extends Target {
        private final String srv;
        private final String domain;

        private SrvTarget(String srv, String domain) {
            super(domain);
            this.srv = srv;
            this.domain = domain;
        }

        public String getSrv() {
            return this.srv;
        }

        public String getDomain() {
            return this.domain;
        }

        @Override
        public Supplier<List<URI>> getEndpointSupplier() {
            return Resolver.supplier((String)this.srv, (String)this.domain);
        }

        public String toString() {
            return this.domain + " (srv: " + this.srv + ")";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SrvTarget srvTarget = (SrvTarget)obj;
            if (!this.srv.equals(srvTarget.getSrv())) {
                return false;
            }
            return this.domain.equals(srvTarget.getDomain());
        }

        public int hashCode() {
            int result = this.srv != null ? this.srv.hashCode() : 0;
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            return result;
        }
    }
}

