/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Joiner;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.cli.command.HostResolver;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDeregisterCommand
extends ControlCommand {
    private static final Logger log = LoggerFactory.getLogger(HostDeregisterCommand.class);
    private final Argument hostArg;
    private final Argument yesArg;
    private final Argument forceArg;

    public HostDeregisterCommand(Subparser parser) {
        super(parser);
        parser.help("deregister a host");
        this.hostArg = parser.addArgument(new String[]{"host"}).help("Host name to deregister.");
        this.yesArg = parser.addArgument(new String[]{"--yes"}).action((ArgumentAction)Arguments.storeTrue()).help("Automatically answer 'yes' to the interactive prompt.");
        this.forceArg = parser.addArgument(new String[]{"--force"}).action((ArgumentAction)Arguments.storeTrue()).help("Automatically answer 'yes' to the interactive prompt.");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        String host = options.getString(this.hostArg.getDest());
        boolean yes = options.getBoolean(this.yesArg.getDest());
        boolean force = options.getBoolean(this.forceArg.getDest());
        if (force) {
            log.warn("If you are using '--force' to skip the interactive prompt, note that we have deprecated it. Please use '--yes'.");
        }
        if (!yes && !force) {
            out.printf("This will deregister the host %s%n", host);
            boolean confirmed = Utils.userConfirmed(out, stdin);
            if (!confirmed) {
                return 1;
            }
        }
        out.printf("Deregistering host %s%n", host);
        int code = 0;
        HostDeregisterResponse response = (HostDeregisterResponse)client.deregisterHost(host).get();
        out.printf("%s: ", host);
        if (response.getStatus() == HostDeregisterResponse.Status.OK) {
            out.printf("done%n", new Object[0]);
        } else {
            HostResolver resolver;
            List<String> resolved;
            out.printf("failed: %s%n", response);
            if (response.getStatus() == HostDeregisterResponse.Status.NOT_FOUND && !(resolved = (resolver = HostResolver.create(client)).getSortedMatches(host)).isEmpty()) {
                out.println("We didn't find your hostname, but we did find some possible matches for you:\n    " + Joiner.on((String)"\n    ").join(resolved) + "\n");
            }
            code = 1;
        }
        return code;
    }
}

