/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.JobId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobStartCommand
extends WildcardJobCommand {
    private final Argument hostsArg;
    private final Argument tokenArg;

    public JobStartCommand(Subparser parser) {
        super(parser);
        parser.help("start a stopped job");
        this.hostsArg = parser.addArgument(new String[]{"hosts"}).nargs("+").help("The hosts to start the job on.");
        this.tokenArg = parser.addArgument(new String[]{"--token"}).nargs("?").setDefault((Object)"").help("Insecure access token");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        List hosts = options.getList(this.hostsArg.getDest());
        Deployment deployment = new Deployment.Builder().setGoal(Goal.START).setJobId(jobId).build();
        if (!json) {
            out.printf("Starting %s on %s%n", jobId, hosts);
        }
        return Utils.setGoalOnHosts(client, out, json, hosts, deployment, options.getString(this.tokenArg.getDest()));
    }
}

