/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class MetricId
implements Comparable<MetricId> {
    public static final String SEPARATOR = ".";
    public static final SortedMap<String, String> EMPTY_TAGS = Collections.unmodifiableSortedMap(new TreeMap());
    public static final MetricId EMPTY = new MetricId();
    private final String key;
    private final SortedMap<String, String> tags;
    private final int hash;

    public MetricId() {
        this((String)null, EMPTY_TAGS);
    }

    public MetricId(String key) {
        this(key, EMPTY_TAGS);
    }

    public MetricId(String key, Map<String, String> tags) {
        this(key, Collections.unmodifiableSortedMap(new TreeMap<String, String>(tags)));
    }

    MetricId(String key, SortedMap<String, String> tags) {
        this.key = key;
        this.tags = tags;
        this.hash = MetricId.calculateHashCode(key, tags);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricId resolve(String part) {
        return new MetricId(this.extendKey(part), this.tags);
    }

    private String extendKey(String part) {
        if (part == null || part.isEmpty()) {
            return this.key;
        }
        if (this.key == null || this.key.isEmpty()) {
            return part;
        }
        return this.key + SEPARATOR + part;
    }

    public MetricId tagged(Map<String, String> add) {
        TreeMap<String, String> tags = new TreeMap<String, String>(this.tags);
        tags.putAll(add);
        return new MetricId(this.key, (SortedMap<String, String>)tags);
    }

    public MetricId tagged(String ... pairs) {
        if (pairs == null) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Argument count must be even");
        }
        TreeMap<String, String> add = new TreeMap<String, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            add.put(pairs[i], pairs[i + 1]);
        }
        return this.tagged(add);
    }

    public static MetricId join(MetricId ... parts) {
        StringBuilder nameBuilder = new StringBuilder();
        HashMap<String, String> tags = new HashMap<String, String>();
        boolean first = true;
        for (MetricId part : parts) {
            String name = part.getKey();
            if (name != null && !name.isEmpty()) {
                if (first) {
                    first = false;
                } else {
                    nameBuilder.append(SEPARATOR);
                }
                nameBuilder.append(name);
            }
            if (part.getTags().isEmpty()) continue;
            tags.putAll(part.getTags());
        }
        return new MetricId(nameBuilder.toString(), tags);
    }

    public static MetricId build(String ... parts) {
        if (parts == null || parts.length == 0) {
            return EMPTY;
        }
        if (parts.length == 1) {
            return new MetricId(parts[0], EMPTY_TAGS);
        }
        return new MetricId(MetricId.key(parts), EMPTY_TAGS);
    }

    public String toString() {
        return String.format("%s %s", this.key, this.tags);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != MetricId.class) {
            return false;
        }
        MetricId m = (MetricId)obj;
        if (this.hash != m.hash) {
            return false;
        }
        if (this.key == null || m.key == null ? this.key != m.key : !this.key.equals(m.key)) {
            return false;
        }
        return this.tags.equals(m.tags);
    }

    @Override
    public int compareTo(MetricId o) {
        if (o == null) {
            return -1;
        }
        if (this == o) {
            return 0;
        }
        int h = Integer.compare(this.hash, o.hash);
        if (h != 0) {
            return h;
        }
        int k = this.compareKey(this.key, o.getKey());
        if (k != 0) {
            return k;
        }
        return this.compareTags(this.tags.entrySet(), o.tags.entrySet());
    }

    private static String key(String ... names) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(SEPARATOR);
            }
            builder.append(name);
        }
        return builder.toString();
    }

    private int compareKey(String left, String right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        return left.compareTo(right);
    }

    private int compareTags(Set<Map.Entry<String, String>> left, Set<Map.Entry<String, String>> right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        Iterator<Map.Entry<String, String>> li = left.iterator();
        Iterator<Map.Entry<String, String>> ri = right.iterator();
        if (li.hasNext()) {
            if (!ri.hasNext()) {
                return -1;
            }
            Map.Entry<String, String> l = li.next();
            Map.Entry<String, String> r = ri.next();
            int k = l.getKey().compareTo(r.getKey());
            if (k != 0) {
                return k;
            }
            int v = l.getValue().compareTo(r.getValue());
            if (v != 0) {
                return v;
            }
        }
        if (ri.hasNext()) {
            return 1;
        }
        return 0;
    }

    private static int calculateHashCode(String key, SortedMap<String, String> tags) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (key == null ? 0 : key.hashCode());
        result = 31 * result + tags.hashCode();
        return result;
    }
}

