/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.core;

import com.spotify.metrics.core.MetricId;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class MetricIdCache<T> {
    private final Cache<T> cache;
    private final MetricId metricId;

    private MetricIdCache(Cache<T> cache, MetricId metricId) {
        this.cache = cache;
        this.metricId = metricId;
    }

    public static Any builder() {
        return new Any();
    }

    public MetricId get(T key) {
        try {
            return this.cache.get(this.metricId, key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("failed to get cache value", e);
        }
    }

    public void invalidate(T key) {
        this.cache.invalidate(key);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public static class Any {
        private final MetricId metricId;
        private final CacheBuilder cacheBuilder;

        private Any(MetricId base, CacheBuilder cacheBuilder) {
            this.metricId = base;
            this.cacheBuilder = cacheBuilder;
        }

        private Any() {
            this(null, null);
        }

        public Any metricId(MetricId metricId) {
            if (metricId == null) {
                throw new IllegalArgumentException("'metricId' must not be null");
            }
            return new Any(metricId, this.cacheBuilder);
        }

        public <T> Typed<T> unbounded(Loader<T> loader) {
            return new Typed<T>(this, null, null, null).unbounded(loader);
        }

        public <T> Typed<T> cache(Cache<T> cache) {
            return new Typed<T>(this, null, null, null).cache(cache);
        }

        public <T> Typed<T> cache(ConcurrentMap<T, MetricId> cache, Loader<T> loader) {
            return new Typed<T>(this, null, null, null).cache(cache, loader);
        }

        public <T> Typed<T> loader(Loader<T> loader) {
            return new Typed<T>(this, null, null, null).loader(loader);
        }

        public <T> Typed<T> mapBuilder(MapBuilder mapBuilder, Loader<T> loader) {
            return this.mapBuilder(mapBuilder).loader(loader);
        }

        public Any cacheBuilder(CacheBuilder cacheBuilder) {
            if (cacheBuilder == null) {
                throw new IllegalArgumentException("'cacheBuilder' must not be null");
            }
            return new Any(this.metricId, cacheBuilder);
        }

        public Any mapBuilder(final MapBuilder mapBuilder) {
            if (mapBuilder == null) {
                throw new IllegalArgumentException("'mapBuilder' must not be null");
            }
            return new Any(this.metricId, new CacheBuilder(){

                @Override
                public <T> Cache<T> build(Loader<T> loader) {
                    ConcurrentMap map = mapBuilder.build();
                    if (map == null) {
                        throw new IllegalStateException("'mapBuilder' must not return null");
                    }
                    return new ConcurrentMapCache(map, loader);
                }
            });
        }

        private <T> Cache<T> buildCache(Cache<T> cache, Loader<T> loader, TypedCacheBuilder<T> typedCacheBuilder) {
            if (cache != null) {
                return cache;
            }
            if (loader == null) {
                throw new IllegalStateException("'loader' must be set");
            }
            if (this.cacheBuilder != null) {
                Cache<T> c = this.cacheBuilder.build(loader);
                if (c == null) {
                    throw new IllegalStateException("'cacheBuilder' must return non-null values");
                }
                return c;
            }
            if (typedCacheBuilder != null) {
                return typedCacheBuilder.build(loader);
            }
            throw new IllegalStateException("No cache implementation is configured");
        }

        private MetricId buildMetricId() {
            if (this.metricId == null) {
                return MetricId.EMPTY;
            }
            return this.metricId;
        }
    }

    public static class Typed<T> {
        private final Any any;
        private final Cache<T> cache;
        private final Loader<T> loader;
        private final TypedCacheBuilder<T> typedCacheBuilder;

        private Typed(Any any, Cache<T> cache, Loader<T> loader, TypedCacheBuilder<T> typedCacheBuilder) {
            this.any = any;
            this.cache = cache;
            this.loader = loader;
            this.typedCacheBuilder = typedCacheBuilder;
        }

        public Typed<T> metricId(MetricId base) {
            return this.any(this.any.metricId(base));
        }

        public Typed<T> cache(Cache<T> cache) {
            if (cache == null) {
                throw new IllegalArgumentException("'cache' must not be null");
            }
            return new Typed<T>(this.any, cache, this.loader, this.typedCacheBuilder);
        }

        public Typed<T> unbounded(Loader<T> loader) {
            return this.cache(new ConcurrentHashMap(), loader);
        }

        public Typed<T> cache(final ConcurrentMap<T, MetricId> map, Loader<T> loader) {
            if (map == null) {
                throw new IllegalArgumentException("'cache' must not be null");
            }
            return super.typedCacheBuilder(new TypedCacheBuilder<T>(){

                @Override
                public Cache<T> build(Loader<T> loader) {
                    return new ConcurrentMapCache(map, loader);
                }
            });
        }

        public Typed<T> cacheBuilder(CacheBuilder cacheBuilder) {
            return this.any(this.any.cacheBuilder(cacheBuilder));
        }

        public Typed<T> mapBuilder(MapBuilder mapBuilder, Loader<T> loader) {
            return super.any(this.any.mapBuilder(mapBuilder));
        }

        public Typed<T> mapBuilder(MapBuilder mapBuilder) {
            return this.any(this.any.mapBuilder(mapBuilder));
        }

        public Typed<T> loader(Loader<T> loader) {
            if (this.cache != null) {
                throw new IllegalStateException("shared cache is already set");
            }
            return new Typed<T>(this.any, this.cache, loader, this.typedCacheBuilder);
        }

        public MetricIdCache<T> build() {
            Cache cache = this.any.buildCache(this.cache, this.loader, this.typedCacheBuilder);
            return new MetricIdCache(cache, this.any.buildMetricId());
        }

        private Typed<T> typedCacheBuilder(TypedCacheBuilder<T> typedCacheBuilder) {
            return new Typed<T>(this.any, this.cache, this.loader, typedCacheBuilder);
        }

        private Typed<T> any(Any any) {
            return new Typed<T>(any, this.cache, this.loader, this.typedCacheBuilder);
        }
    }

    private static interface TypedCacheBuilder<T> {
        public Cache<T> build(Loader<T> var1);
    }

    private static final class ConcurrentMapCache<T>
    implements Cache<T> {
        private final ConcurrentMap<T, MetricId> cache;
        private final Loader<T> loader;

        private ConcurrentMapCache(ConcurrentMap<T, MetricId> cache, Loader<T> loader) {
            this.cache = cache;
            this.loader = loader;
        }

        @Override
        public MetricId get(MetricId metricId, T key) {
            MetricId candidate = (MetricId)this.cache.get(key);
            if (candidate != null) {
                return candidate;
            }
            MetricId addition = this.loader.load(metricId, key);
            if (addition == null) {
                throw new IllegalStateException("loader returned null value");
            }
            MetricId put = this.cache.putIfAbsent(key, addition);
            if (put != null) {
                return put;
            }
            return addition;
        }

        @Override
        public void invalidate(T key) {
            this.cache.remove(key);
        }

        @Override
        public void invalidateAll() {
            this.cache.clear();
        }
    }

    public static interface CacheBuilder {
        public <T> Cache<T> build(Loader<T> var1);
    }

    public static interface MapBuilder {
        public <T> ConcurrentMap<T, MetricId> build();
    }

    public static interface Cache<T> {
        public MetricId get(MetricId var1, T var2) throws ExecutionException;

        public void invalidate(T var1);

        public void invalidateAll();
    }

    public static interface Loader<T> {
        public MetricId load(MetricId var1, T var2);
    }
}

