/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.ffwdhttp;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.collect.Sets;
import com.spotify.ffwd.http.Batch;
import com.spotify.ffwd.http.HttpClient;
import com.spotify.metrics.core.DerivingMeter;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricFilter;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.ffwdhttp.Clock;
import com.spotify.metrics.ffwdhttp.Percentile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastForwardHttpReporter
implements AutoCloseable {
    private static final String METRIC_TYPE = "metric_type";
    private static final Logger log = LoggerFactory.getLogger(FastForwardHttpReporter.class);
    private static final SemanticMetricFilter FILTER_ALL = SemanticMetricFilter.ALL;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName(String.format("fast-forward-reporter-%d", this.count.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private final SemanticMetricRegistry registry;
    private final MetricId prefix;
    private final TimeUnit unit;
    private final long duration;
    private final HttpClient client;
    private final Set<Percentile> histogramPercentiles;
    private final Clock clock;
    private final AtomicBoolean running = new AtomicBoolean(false);

    private FastForwardHttpReporter(SemanticMetricRegistry registry, MetricId prefix, TimeUnit unit, long duration, HttpClient client, Set<Percentile> histogramPercentiles, Clock clock) {
        this.registry = registry;
        this.prefix = prefix;
        this.unit = unit;
        this.duration = duration;
        this.client = client;
        this.histogramPercentiles = new HashSet<Percentile>(histogramPercentiles);
        this.clock = clock;
    }

    public static Builder forRegistry(SemanticMetricRegistry registry, HttpClient client) {
        return new Builder(registry, client);
    }

    private void report() {
        BatchBuilder builder;
        ArrayList<Batch.Point> points = new ArrayList<Batch.Point>();
        long timestamp = this.clock.currentTimeMillis();
        for (Map.Entry entry : this.registry.getGauges(FILTER_ALL).entrySet()) {
            builder = this.createBuilder(points, timestamp, (MetricId)entry.getKey(), "gauge");
            this.reportGauge(builder, (Gauge)entry.getValue());
        }
        for (Map.Entry entry : this.registry.getCounters(FILTER_ALL).entrySet()) {
            builder = this.createBuilder(points, timestamp, (MetricId)entry.getKey(), "counter");
            this.reportCounter(builder, (Counting)entry.getValue());
        }
        for (Map.Entry entry : this.registry.getHistograms(FILTER_ALL).entrySet()) {
            builder = this.createBuilder(points, timestamp, (MetricId)entry.getKey(), "histogram");
            this.reportHistogram(builder, ((Histogram)entry.getValue()).getSnapshot());
        }
        for (Map.Entry entry : this.registry.getMeters(FILTER_ALL).entrySet()) {
            builder = this.createBuilder(points, timestamp, (MetricId)entry.getKey(), "meter");
            this.reportMeter(builder, (Meter)entry.getValue());
        }
        for (Map.Entry entry : this.registry.getTimers(FILTER_ALL).entrySet()) {
            builder = this.createBuilder(points, timestamp, (MetricId)entry.getKey(), "timer");
            this.reportTimer(builder, (Timer)entry.getValue());
        }
        for (Map.Entry entry : this.registry.getDerivingMeters(FILTER_ALL).entrySet()) {
            builder = this.createBuilder(points, timestamp, (MetricId)entry.getKey(), "deriving-meter");
            this.reportDerivingMeter(builder, (DerivingMeter)entry.getValue());
        }
        Map commonTags = this.prefix.getTags();
        Batch batch = new Batch(commonTags, points);
        this.client.sendBatch(batch).toCompletable().await();
    }

    private BatchBuilder createBuilder(List<Batch.Point> points, long timestamp, MetricId id, String metricType) {
        String key = this.joinKeys(this.prefix, id);
        String unit = this.getUnit(id.getTags());
        return new BatchBuilder(points, timestamp, key, id.getTags(), unit, metricType);
    }

    private void reportGauge(BatchBuilder builder, Gauge value) {
        if (value == null) {
            return;
        }
        builder.buildPoint(null, this.convert(value.getValue()));
    }

    private double convert(Object value) {
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).doubleValue();
        }
        return 0.0;
    }

    private void reportCounter(BatchBuilder builder, Counting value) {
        builder.buildPoint("count", value.getCount());
    }

    private void reportMeter(BatchBuilder builder, Meter value) {
        this.reportMetered(builder, (Metered)value);
        this.reportCounter(builder, (Counting)value);
    }

    private void reportTimer(BatchBuilder builderIn, Timer value) {
        BatchBuilder builder = builderIn.withUnit("ns");
        this.reportMetered(builder, (Metered)value);
        this.reportHistogram(builder, value.getSnapshot());
    }

    private void reportDerivingMeter(BatchBuilder builder, DerivingMeter value) {
        this.reportMetered(builder, (Metered)value);
    }

    private void reportHistogram(BatchBuilder builder, Snapshot s) {
        builder.buildPoint("min", s.getMin());
        builder.buildPoint("max", s.getMax());
        builder.buildPoint("mean", s.getMean());
        builder.buildPoint("median", s.getMedian());
        builder.buildPoint("stddev", s.getStdDev());
        this.reportHistogramQuantiles(builder, s);
    }

    private void reportHistogramQuantiles(BatchBuilder builder, Snapshot s) {
        for (Percentile q : this.histogramPercentiles) {
            builder.buildPoint(q.getPercentileString(), s.getValue(q.getQuantile()));
        }
    }

    private void reportMetered(BatchBuilder builder, Metered value) {
        BatchBuilder b = builder.withUnit(builder.getUnit() + "/s");
        b.buildPoint("1m", value.getOneMinuteRate());
        b.buildPoint("5m", value.getFiveMinuteRate());
    }

    private String getUnit(Map<String, String> tags) {
        String unit = tags.get("unit");
        if (unit == null) {
            return "n";
        }
        return unit;
    }

    private String joinKeys(MetricId ... parts) {
        StringBuilder key = new StringBuilder();
        for (MetricId part : parts) {
            String name = part.getKey();
            if (name == null || name.isEmpty()) continue;
            if (key.length() > 0) {
                key.append('.');
            }
            key.append(name);
        }
        return key.toString();
    }

    public void start() {
        if (this.running.getAndSet(true)) {
            return;
        }
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    FastForwardHttpReporter.this.report();
                }
                catch (Exception e) {
                    log.error("Error when trying to report metrics", (Throwable)e);
                }
            }
        }, 0L, this.duration, this.unit);
    }

    public void stop() {
        this.executorService.shutdown();
    }

    @Override
    public void close() {
        this.stop();
    }

    private static class BatchBuilder {
        private final List<Batch.Point> points;
        private final long timestamp;
        private final String key;
        private final Map<String, String> tags;
        private final String unit;
        private final String metricType;

        public BatchBuilder(List<Batch.Point> points, long timestamp, String key, Map<String, String> tags, String unit, String metricType) {
            this.points = points;
            this.timestamp = timestamp;
            this.key = key;
            this.tags = tags;
            this.unit = unit;
            this.metricType = metricType;
        }

        public String getUnit() {
            return this.unit;
        }

        public BatchBuilder withUnit(String unit) {
            return new BatchBuilder(this.points, this.timestamp, this.key, this.tags, unit, this.metricType);
        }

        public BatchBuilder withMetricType(String metricType) {
            return new BatchBuilder(this.points, this.timestamp, this.key, this.tags, this.unit, metricType);
        }

        public void buildPoint(String stat, double value) {
            this.points.add(new Batch.Point(this.key, this.statsMap(stat), value, this.timestamp));
        }

        private Map<String, String> statsMap(String stat) {
            boolean sameUnit = this.unit.equals(this.tags.get("unit"));
            boolean sameMetricType = this.metricType.equals(this.tags.get("unit"));
            if (sameMetricType && sameUnit && stat == null) {
                return this.tags;
            }
            HashMap<String, String> builder = new HashMap<String, String>(this.tags);
            if (!sameUnit) {
                builder.put("unit", this.unit);
            }
            if (stat != null) {
                builder.put("stat", stat);
            }
            if (!sameMetricType) {
                builder.put(FastForwardHttpReporter.METRIC_TYPE, this.metricType);
            }
            return builder;
        }
    }

    public static final class Builder {
        private final SemanticMetricRegistry registry;
        private final HttpClient client;
        private long time = 5L;
        private TimeUnit unit = TimeUnit.MINUTES;
        private MetricId prefix = MetricId.build((String[])new String[0]);
        private Clock clock;
        private Set<Percentile> histogramPercentiles = Sets.newHashSet((Object[])new Percentile[]{new Percentile(0.75), new Percentile(0.99)});

        public Builder(SemanticMetricRegistry registry, HttpClient client) {
            this.registry = registry;
            this.client = client;
        }

        public Builder schedule(long time, TimeUnit unit) {
            this.time = time;
            this.unit = unit;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = MetricId.build((String[])new String[]{prefix});
            return this;
        }

        public Builder prefix(MetricId prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder histogramQuantiles(double ... quantiles) {
            this.histogramPercentiles = new HashSet<Percentile>();
            for (double q : quantiles) {
                this.histogramPercentiles.add(new Percentile(q));
            }
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public FastForwardHttpReporter build() throws IOException {
            Clock clock = this.clock;
            if (clock == null) {
                clock = new Clock.SystemTime();
            }
            return new FastForwardHttpReporter(this.registry, this.prefix, this.unit, this.time, this.client, this.histogramPercentiles, clock);
        }
    }
}

