/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.ffwd;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.collect.Sets;
import com.spotify.metrics.core.DerivingMeter;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricFilter;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.ffwd.Percentile;
import eu.toolchain.ffwd.FastForward;
import eu.toolchain.ffwd.Metric;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastForwardReporter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FastForwardReporter.class);
    private static final String METRIC_TYPE = "metric_type";
    private static final SemanticMetricFilter FILTER_ALL = SemanticMetricFilter.ALL;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName(String.format("fast-forward-reporter-%d", this.count.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private final SemanticMetricRegistry registry;
    private final MetricId prefix;
    private final TimeUnit unit;
    private final long duration;
    private final FastForward client;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Set<Percentile> histogramPercentiles;

    private FastForwardReporter(SemanticMetricRegistry registry, MetricId prefix, TimeUnit unit, long duration, FastForward client) {
        this(registry, prefix, unit, duration, client, new HashSet<Percentile>());
    }

    private FastForwardReporter(SemanticMetricRegistry registry, MetricId prefix, TimeUnit unit, long duration, FastForward client, Set<Percentile> histogramPercentiles) {
        this.registry = registry;
        this.prefix = prefix;
        this.unit = unit;
        this.duration = duration;
        this.client = client;
        this.histogramPercentiles = new HashSet<Percentile>(histogramPercentiles);
    }

    public static Builder forRegistry(SemanticMetricRegistry registry) {
        return new Builder(registry);
    }

    public void report() {
        this.report(this.registry.getGauges(FILTER_ALL), this.registry.getCounters(FILTER_ALL), this.registry.getHistograms(FILTER_ALL), this.registry.getMeters(FILTER_ALL), this.registry.getTimers(FILTER_ALL), this.registry.getDerivingMeters(FILTER_ALL));
    }

    private void report(SortedMap<MetricId, Gauge> gauges, SortedMap<MetricId, Counter> counters, SortedMap<MetricId, Histogram> histograms, SortedMap<MetricId, Meter> meters, SortedMap<MetricId, Timer> timers, SortedMap<MetricId, DerivingMeter> derivingMeters) {
        for (Map.Entry<MetricId, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<MetricId, Gauge> entry : counters.entrySet()) {
            this.reportCounter(entry.getKey(), (Counting)entry.getValue());
        }
        for (Map.Entry<MetricId, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<MetricId, Gauge> entry : meters.entrySet()) {
            this.reportMetered(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<MetricId, Gauge> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue());
        }
        for (Map.Entry<MetricId, Gauge> entry : derivingMeters.entrySet()) {
            this.reportDerivingMeter(entry.getKey(), (DerivingMeter)entry.getValue());
        }
    }

    private void reportGauge(MetricId key, Gauge value) {
        if (value == null) {
            return;
        }
        key = MetricId.join((MetricId[])new MetricId[]{this.prefix, key});
        Metric m = FastForward.metric((String)key.getKey()).attributes(key.getTags()).attribute(METRIC_TYPE, "gauge");
        this.send(m.value(this.convert(value.getValue())));
    }

    private double convert(Object value) {
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).doubleValue();
        }
        return 0.0;
    }

    private void reportCounter(MetricId key, Counting value) {
        key = MetricId.join((MetricId[])new MetricId[]{this.prefix, key});
        Metric m = FastForward.metric((String)key.getKey()).attributes(key.getTags()).attribute(METRIC_TYPE, "counter");
        this.send(m.value((double)value.getCount()));
    }

    private void reportHistogram(MetricId key, Histogram value) {
        key = MetricId.join((MetricId[])new MetricId[]{this.prefix, key});
        Metric m = FastForward.metric((String)key.getKey()).attributes(key.getTags()).attribute(METRIC_TYPE, "histogram");
        this.reportHistogram(m, value.getSnapshot());
    }

    private void reportMetered(MetricId key, Meter value) {
        key = MetricId.join((MetricId[])new MetricId[]{this.prefix, key});
        Metric m = FastForward.metric((String)key.getKey()).attributes(key.getTags()).attribute(METRIC_TYPE, "meter");
        this.reportMetered(m, (Metered)value);
        this.reportCounter(key, (Counting)value);
    }

    private void reportTimer(MetricId key, Timer value) {
        key = MetricId.join((MetricId[])new MetricId[]{this.prefix, key});
        Metric m = FastForward.metric((String)key.getKey()).attributes(key.getTags()).attribute(METRIC_TYPE, "timer").attribute("unit", "ns");
        this.reportMetered(m, (Metered)value);
        this.reportHistogram(m, value.getSnapshot());
    }

    private void reportDerivingMeter(MetricId key, DerivingMeter value) {
        key = MetricId.join((MetricId[])new MetricId[]{this.prefix, key});
        Metric m = FastForward.metric((String)key.getKey()).attributes(key.getTags()).attribute(METRIC_TYPE, "deriving-meter");
        this.reportMetered(m, (Metered)value);
    }

    private void reportHistogram(Metric m, Snapshot s) {
        this.send(m.attribute("stat", "min").value((double)s.getMin()));
        this.send(m.attribute("stat", "max").value((double)s.getMax()));
        this.send(m.attribute("stat", "mean").value(s.getMean()));
        this.send(m.attribute("stat", "median").value(s.getMedian()));
        this.send(m.attribute("stat", "stddev").value(s.getStdDev()));
        this.reportHistogramQuantiles(m, s);
    }

    private void reportHistogramQuantiles(Metric m, Snapshot s) {
        for (Percentile q : this.histogramPercentiles) {
            this.send(m.attribute("stat", q.getPercentileString()).value(s.getValue(q.getQuantile())));
        }
    }

    private void reportMetered(Metric m, Metered value) {
        String u = this.getUnit(m);
        Metric r = m.attribute("unit", u + "/s");
        this.send(r.attribute("stat", "1m").value(value.getOneMinuteRate()));
        this.send(r.attribute("stat", "5m").value(value.getFiveMinuteRate()));
    }

    private String getUnit(Metric m) {
        String unit = (String)m.getAttributes().get("unit");
        if (unit == null) {
            return "n";
        }
        return unit;
    }

    private void send(Metric metric) {
        try {
            this.client.send(metric);
        }
        catch (IOException e) {
            log.error("Failed to send metric", (Throwable)e);
        }
    }

    public void start() {
        if (this.running.getAndSet(true)) {
            return;
        }
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    FastForwardReporter.this.report();
                }
                catch (Exception e) {
                    log.error("Error when trying to report metric", (Throwable)e);
                }
            }
        }, 0L, this.duration, this.unit);
    }

    public void stop() {
        this.executorService.shutdown();
    }

    @Override
    public void close() {
        this.stop();
    }

    public static final class Builder {
        private final SemanticMetricRegistry registry;
        private TimeUnit unit = TimeUnit.MINUTES;
        private long time = 5L;
        private String host = "localhost";
        private int port = 19091;
        private MetricId prefix = MetricId.build((String[])new String[0]);
        private FastForward client = null;
        private Set<Percentile> histogramPercentiles = Sets.newHashSet((Object[])new Percentile[]{new Percentile(0.75), new Percentile(0.99)});

        public Builder(SemanticMetricRegistry registry) {
            this.registry = registry;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder schedule(TimeUnit unit, long time) {
            this.unit = unit;
            this.time = time;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = MetricId.build((String[])new String[]{prefix});
            return this;
        }

        public Builder prefix(MetricId prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder fastForward(FastForward client) {
            this.client = client;
            return this;
        }

        public Builder histogramQuantiles(double ... quantiles) {
            this.histogramPercentiles = new HashSet<Percentile>();
            for (double q : quantiles) {
                this.histogramPercentiles.add(new Percentile(q));
            }
            return this;
        }

        public FastForwardReporter build() throws IOException {
            FastForward client = this.client != null ? this.client : FastForward.setup((String)this.host, (int)this.port);
            return new FastForwardReporter(this.registry, this.prefix, this.unit, this.time, client, this.histogramPercentiles);
        }
    }
}

