/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.ffwd;

import com.google.common.base.Strings;

public class Percentile {
    private final int whole;
    private final int decimal;
    private final String percentileString;
    private final double quantile;

    public Percentile(int whole, int decimal) {
        if (whole < 0 || whole >= 100) {
            throw new IllegalArgumentException("whole " + whole + " is not in [0..100)");
        }
        if (decimal < 0 || decimal > 9) {
            throw new IllegalArgumentException("decimal " + decimal + " is not in [0..9]");
        }
        this.whole = whole;
        this.decimal = decimal;
        this.percentileString = this.toPercentileString(this.whole, this.decimal);
        this.quantile = this.toQuantile(this.whole, this.decimal);
    }

    public Percentile(int whole) {
        this(whole, 0);
    }

    public Percentile(double quantile) {
        this((int)(quantile * 100.0), (int)Math.round((quantile * 100.0 - (double)((int)(quantile * 100.0))) * 10.0));
    }

    private String toPercentileString(int whole, int decimal) {
        String pString = "p" + whole;
        if (decimal != 0) {
            return pString + "." + decimal;
        }
        return pString;
    }

    private double toQuantile(int whole, int decimal) {
        return Double.parseDouble("0." + Strings.padStart((String)("" + whole), (int)2, (char)'0') + decimal);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public String getPercentileString() {
        return this.percentileString;
    }

    public String toString() {
        return this.percentileString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.decimal;
        result = 31 * result + this.whole;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percentile other = (Percentile)obj;
        if (this.decimal != other.decimal) {
            return false;
        }
        return this.whole == other.whole;
    }
}

