/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.VariantOutput;
import com.spotify.ruler.plugin.RulerExtension;
import com.spotify.ruler.plugin.RulerPlugin;
import com.spotify.ruler.plugin.RulerTask;
import com.spotify.ruler.plugin.models.AppInfo;
import com.spotify.ruler.plugin.models.DeviceSpec;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J<\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/spotify/ruler/plugin/RulerPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "name", "", "apply", "", "project", "getAppInfo", "Lorg/gradle/api/provider/Provider;", "Lcom/spotify/ruler/plugin/models/AppInfo;", "kotlin.jvm.PlatformType", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "getBundleFile", "Lorg/gradle/api/file/RegularFile;", "getDeviceSpec", "Lcom/spotify/ruler/plugin/models/DeviceSpec;", "extension", "Lcom/spotify/ruler/plugin/RulerExtension;", "getMappingFile", "getResourceMappingFile", "hasDexGuard", "", "hasProGuard", "ruler-gradle-plugin"})
public final class RulerPlugin
implements Plugin<Project> {
    @NotNull
    private final String name;

    public RulerPlugin() {
        this.name = "ruler";
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RulerExtension rulerExtension = (RulerExtension)project.getExtensions().create(this.name, RulerExtension.class, new Object[0]);
        project.getPlugins().withId("com.android.application", arg_0 -> RulerPlugin.apply$lambda-0(project, this, rulerExtension, arg_0));
    }

    private final Provider<AppInfo> getAppInfo(Project project, ApplicationVariant variant) {
        return project.provider(() -> RulerPlugin.getAppInfo$lambda-1(variant));
    }

    private final DeviceSpec getDeviceSpec(RulerExtension extension) {
        String string = (String)extension.getAbi().getOrNull();
        if (string == null) {
            throw new IllegalStateException("ABI not specified.".toString());
        }
        String string2 = (String)extension.getLocale().getOrNull();
        if (string2 == null) {
            throw new IllegalStateException("Locale not specified.".toString());
        }
        Integer n = (Integer)extension.getScreenDensity().getOrNull();
        if (n == null) {
            throw new IllegalStateException("Screen density not specified.".toString());
        }
        Integer n2 = (Integer)extension.getSdkVersion().getOrNull();
        if (n2 == null) {
            throw new IllegalStateException("SDK version not specified.".toString());
        }
        return new DeviceSpec(string, string2, ((Number)n).intValue(), ((Number)n2).intValue());
    }

    private final Provider<RegularFile> getBundleFile(Project project, ApplicationVariant variant) {
        Provider defaultBundleFile = variant.getArtifacts().get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE);
        if (!this.hasDexGuard(project)) {
            return defaultBundleFile;
        }
        Provider provider = defaultBundleFile.flatMap(arg_0 -> RulerPlugin.getBundleFile$lambda-2(project, defaultBundleFile, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"defaultBundleFile.flatMa\u2026t\n            }\n        }");
        return provider;
    }

    private final Provider<RegularFile> getMappingFile(Project project, ApplicationVariant variant) {
        String string;
        Provider defaultMappingFile = variant.getArtifacts().get((SingleArtifact)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE);
        if (this.hasDexGuard(project)) {
            string = "outputs/dexguard/mapping/bundle/" + variant.getName() + "/mapping.txt";
        } else if (this.hasProGuard(project)) {
            string = "outputs/proguard/" + variant.getName() + "/mapping/mapping.txt";
        } else {
            return defaultMappingFile;
        }
        String mappingFilePath = string;
        Provider mappingFileProvider = project.getLayout().getBuildDirectory().file(mappingFilePath);
        Provider provider = mappingFileProvider.flatMap(arg_0 -> RulerPlugin.getMappingFile$lambda-3(mappingFileProvider, defaultMappingFile, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"mappingFileProvider.flat\u2026t\n            }\n        }");
        return provider;
    }

    private final Provider<RegularFile> getResourceMappingFile(Project project, ApplicationVariant variant) {
        RegularFileProperty defaultResourceMappingFile = project.getObjects().fileProperty();
        if (!this.hasDexGuard(project)) {
            Intrinsics.checkNotNullExpressionValue((Object)defaultResourceMappingFile, (String)"defaultResourceMappingFile");
            return (Provider)defaultResourceMappingFile;
        }
        String resourceMappingFilePath = "outputs/dexguard/mapping/bundle/" + variant.getName() + "/resourcefilenamemapping.txt";
        Provider resourceMappingFileProvider = project.getLayout().getBuildDirectory().file(resourceMappingFilePath);
        Provider provider = resourceMappingFileProvider.flatMap(arg_0 -> RulerPlugin.getResourceMappingFile$lambda-4(resourceMappingFileProvider, defaultResourceMappingFile, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"resourceMappingFileProvi\u2026t\n            }\n        }");
        return provider;
    }

    private final boolean hasDexGuard(Project project) {
        return project.getPluginManager().hasPlugin("dexguard");
    }

    private final boolean hasProGuard(Project project) {
        return project.getPluginManager().hasPlugin("com.guardsquare.proguard");
    }

    private static final void apply$lambda-0(Project $project, RulerPlugin this$0, RulerExtension $rulerExtension, Plugin it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ApplicationAndroidComponentsExtension androidComponents = (ApplicationAndroidComponentsExtension)$project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
        AndroidComponentsExtension.DefaultImpls.onVariants$default((AndroidComponentsExtension)((AndroidComponentsExtension)androidComponents), null, (Function1)((Function1)new Function1<ApplicationVariant, Unit>($project, this$0, $rulerExtension){
            final /* synthetic */ Project $project;
            final /* synthetic */ RulerPlugin this$0;
            final /* synthetic */ RulerExtension $rulerExtension;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$rulerExtension = $rulerExtension;
                super(1);
            }

            public final void invoke(@NotNull ApplicationVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                String variantName = StringGroovyMethods.capitalize((CharSequence)variant.getName());
                this.$project.getTasks().register("analyze" + variantName + "Bundle", RulerTask.class, arg_0 -> apply.1.1.invoke$lambda-0(this.this$0, this.$project, variant, this.$rulerExtension, variantName, arg_0));
            }

            private static final void invoke$lambda-0(RulerPlugin this$0, Project $project, ApplicationVariant $variant, RulerExtension $rulerExtension, String $variantName, RulerTask task) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
                task.setGroup(RulerPlugin.access$getName$p(this$0));
                task.getAppInfo().set(RulerPlugin.access$getAppInfo(this$0, $project, $variant));
                Property<DeviceSpec> property = task.getDeviceSpec();
                Intrinsics.checkNotNullExpressionValue((Object)$rulerExtension, (String)"rulerExtension");
                property.set((Object)RulerPlugin.access$getDeviceSpec(this$0, $rulerExtension));
                task.getBundleFile().set(RulerPlugin.access$getBundleFile(this$0, $project, $variant));
                task.getMappingFile().set(RulerPlugin.access$getMappingFile(this$0, $project, $variant));
                task.getResourceMappingFile().set(RulerPlugin.access$getResourceMappingFile(this$0, $project, $variant));
                task.getOwnershipFile().set((Provider)$rulerExtension.getOwnershipFile());
                task.getDefaultOwner().set((Provider)$rulerExtension.getDefaultOwner());
                task.getWorkingDir().set($project.getLayout().getBuildDirectory().dir("intermediates/ruler/" + $variant.getName()));
                task.getReportDir().set($project.getLayout().getBuildDirectory().dir("reports/ruler/" + $variant.getName()));
                Object[] objectArray = new Object[]{"bundle" + $variantName};
                task.dependsOn(objectArray);
            }
        }), (int)1, null);
    }

    private static final AppInfo getAppInfo$lambda-1(ApplicationVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        String string = (String)$variant.getApplicationId().get();
        String string2 = (String)((VariantOutput)CollectionsKt.first((List)$variant.getOutputs())).getVersionName().get();
        if (string2 == null) {
            string2 = "-";
        }
        String string3 = string2;
        String string4 = $variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get()");
        return new AppInfo(string4, string, string3);
    }

    private static final Provider getBundleFile$lambda-2(Project $project, Provider $defaultBundleFile, RegularFile bundle) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$defaultBundleFile, (String)"$defaultBundleFile");
        File file = bundle.getAsFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"bundle.asFile.parentFile");
        File file2 = bundle.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"bundle.asFile");
        File dexGuardBundle = FilesKt.resolve((File)file, (String)(FilesKt.getNameWithoutExtension((File)file2) + "-protected.aab"));
        return dexGuardBundle.exists() ? $project.getLayout().getBuildDirectory().file(dexGuardBundle.getAbsolutePath()) : $defaultBundleFile;
    }

    private static final Provider getMappingFile$lambda-3(Provider $mappingFileProvider, Provider $defaultMappingFile, RegularFile mappingFile) {
        Intrinsics.checkNotNullParameter((Object)$defaultMappingFile, (String)"$defaultMappingFile");
        return mappingFile.getAsFile().exists() ? $mappingFileProvider : $defaultMappingFile;
    }

    private static final Provider getResourceMappingFile$lambda-4(Provider $resourceMappingFileProvider, RegularFileProperty $defaultResourceMappingFile, RegularFile resourceMappingFile) {
        return resourceMappingFile.getAsFile().exists() ? $resourceMappingFileProvider : (Provider)$defaultResourceMappingFile;
    }

    public static final /* synthetic */ String access$getName$p(RulerPlugin $this) {
        return $this.name;
    }

    public static final /* synthetic */ Provider access$getAppInfo(RulerPlugin $this, Project project, ApplicationVariant variant) {
        return $this.getAppInfo(project, variant);
    }

    public static final /* synthetic */ DeviceSpec access$getDeviceSpec(RulerPlugin $this, RulerExtension extension) {
        return $this.getDeviceSpec(extension);
    }

    public static final /* synthetic */ Provider access$getBundleFile(RulerPlugin $this, Project project, ApplicationVariant variant) {
        return $this.getBundleFile(project, variant);
    }

    public static final /* synthetic */ Provider access$getMappingFile(RulerPlugin $this, Project project, ApplicationVariant variant) {
        return $this.getMappingFile(project, variant);
    }

    public static final /* synthetic */ Provider access$getResourceMappingFile(RulerPlugin $this, Project project, ApplicationVariant variant) {
        return $this.getResourceMappingFile(project, variant);
    }
}

