/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin;

import com.spotify.ruler.models.AppFile;
import com.spotify.ruler.models.ComponentType;
import com.spotify.ruler.plugin.apk.ApkCreator;
import com.spotify.ruler.plugin.apk.ApkParser;
import com.spotify.ruler.plugin.apk.ApkSanitizer;
import com.spotify.ruler.plugin.attribution.Attributor;
import com.spotify.ruler.plugin.common.ClassNameSanitizer;
import com.spotify.ruler.plugin.common.ResourceNameSanitizer;
import com.spotify.ruler.plugin.dependency.DependencyComponent;
import com.spotify.ruler.plugin.dependency.DependencyEntry;
import com.spotify.ruler.plugin.dependency.DependencyParser;
import com.spotify.ruler.plugin.dependency.DependencySanitizer;
import com.spotify.ruler.plugin.models.AppInfo;
import com.spotify.ruler.plugin.models.DeviceSpec;
import com.spotify.ruler.plugin.ownership.OwnershipEntry;
import com.spotify.ruler.plugin.ownership.OwnershipFileParser;
import com.spotify.ruler.plugin.ownership.OwnershipInfo;
import com.spotify.ruler.plugin.report.HtmlReporter;
import com.spotify.ruler.plugin.report.JsonReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007JF\u0010 \u001a\u00020\u001f2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\"2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\"2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u001a\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0$0\"H\u0002J\u001a\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\"H\u0002J\n\u0010+\u001a\u0004\u0018\u00010(H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u0014\u0010\u001c\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/spotify/ruler/plugin/RulerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "appInfo", "Lorg/gradle/api/provider/Property;", "Lcom/spotify/ruler/plugin/models/AppInfo;", "getAppInfo", "()Lorg/gradle/api/provider/Property;", "bundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "defaultOwner", "", "getDefaultOwner", "deviceSpec", "Lcom/spotify/ruler/plugin/models/DeviceSpec;", "getDeviceSpec", "mappingFile", "getMappingFile", "ownershipFile", "getOwnershipFile", "reportDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportDir", "()Lorg/gradle/api/file/DirectoryProperty;", "resourceMappingFile", "getResourceMappingFile", "workingDir", "getWorkingDir", "analyze", "", "generateReports", "components", "", "Lcom/spotify/ruler/plugin/dependency/DependencyComponent;", "", "Lcom/spotify/ruler/models/AppFile;", "features", "ownershipInfo", "Lcom/spotify/ruler/plugin/ownership/OwnershipInfo;", "getDependencies", "getFilesFromBundle", "getOwnershipInfo", "ruler-gradle-plugin"})
public abstract class RulerTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<AppInfo> getAppInfo();

    @Input
    @NotNull
    public abstract Property<DeviceSpec> getDeviceSpec();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getBundleFile();

    @Optional
    @InputFile
    @NotNull
    public abstract RegularFileProperty getMappingFile();

    @Optional
    @InputFile
    @NotNull
    public abstract RegularFileProperty getResourceMappingFile();

    @Optional
    @InputFile
    @NotNull
    public abstract RegularFileProperty getOwnershipFile();

    @Input
    @NotNull
    public abstract Property<String> getDefaultOwner();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getWorkingDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportDir();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void analyze() {
        void $this$filterTo$iv$iv;
        Map<String, List<AppFile>> files = this.getFilesFromBundle();
        Map<String, List<DependencyComponent>> dependencies = this.getDependencies();
        List mainFiles = (List)MapsKt.getValue(files, (Object)"base");
        Map<String, List<AppFile>> $this$filter$iv = files;
        boolean $i$f$filter = false;
        Map<String, List<AppFile>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String feature = (String)entry.getKey();
            if (!(!Intrinsics.areEqual((Object)feature, (Object)"base"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map featureFiles = destination$iv$iv;
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        Attributor attributor = new Attributor(new DependencyComponent(string, ComponentType.INTERNAL));
        Map<DependencyComponent, List<AppFile>> components = attributor.attribute(mainFiles, dependencies);
        OwnershipInfo ownershipInfo = this.getOwnershipInfo();
        this.generateReports(components, featureFiles, ownershipInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<AppFile>> getFilesFromBundle() {
        void $this$mapValuesTo$iv$iv;
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        ApkCreator apkCreator = new ApkCreator(file);
        Object object = this.getBundleFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bundleFile.asFile.get()");
        File file2 = (File)object;
        Object object2 = this.getDeviceSpec().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"deviceSpec.get()");
        DeviceSpec deviceSpec = (DeviceSpec)object2;
        Object object3 = this.getWorkingDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"workingDir.asFile.get()");
        Map<String, List<File>> splits = apkCreator.createSplitApks(file2, deviceSpec, (File)object3);
        ApkParser apkParser = new ApkParser();
        ClassNameSanitizer classNameSanitizer = new ClassNameSanitizer((File)this.getMappingFile().getAsFile().getOrNull());
        ResourceNameSanitizer resourceNameSanitizer = new ResourceNameSanitizer((File)this.getResourceMappingFile().getAsFile().getOrNull());
        ApkSanitizer apkSanitizer = new ApkSanitizer(classNameSanitizer, resourceNameSanitizer);
        Map<String, List<File>> $this$mapValues$iv = splits;
        boolean $i$f$mapValues = false;
        Map<String, List<File>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List apks = (List)entry2.getValue();
            Iterable $this$flatMap$iv = apks;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File p0 = (File)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = apkParser.parse(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List entries = (List)destination$iv$iv2;
            List<AppFile> list = apkSanitizer.sanitize(entries);
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    private final Map<String, List<DependencyComponent>> getDependencies() {
        DependencyParser dependencyParser = new DependencyParser();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = this.getAppInfo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appInfo.get()");
        List<DependencyEntry> entries = dependencyParser.parse(project, (AppInfo)object);
        ClassNameSanitizer classNameSanitizer = new ClassNameSanitizer((File)this.getMappingFile().getAsFile().getOrNull());
        DependencySanitizer dependencySanitizer = new DependencySanitizer(classNameSanitizer);
        return dependencySanitizer.sanitize(entries);
    }

    private final OwnershipInfo getOwnershipInfo() {
        File file = (File)this.getOwnershipFile().getAsFile().getOrNull();
        if (file == null) {
            return null;
        }
        File ownershipFile = file;
        OwnershipFileParser ownershipFileParser = new OwnershipFileParser();
        List<OwnershipEntry> ownershipEntries = ownershipFileParser.parse(ownershipFile);
        Object object = this.getDefaultOwner().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultOwner.get()");
        return new OwnershipInfo(ownershipEntries, (String)object);
    }

    private final void generateReports(Map<DependencyComponent, ? extends List<AppFile>> components, Map<String, ? extends List<AppFile>> features, OwnershipInfo ownershipInfo) {
        File reportDir = (File)this.getReportDir().getAsFile().get();
        JsonReporter jsonReporter = new JsonReporter();
        Object object = this.getAppInfo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appInfo.get()");
        AppInfo appInfo = (AppInfo)object;
        Intrinsics.checkNotNullExpressionValue((Object)reportDir, (String)"reportDir");
        File jsonReport = jsonReporter.generateReport(appInfo, components, features, ownershipInfo, reportDir);
        this.getProject().getLogger().lifecycle("Wrote JSON report to " + jsonReport.toPath().toUri());
        HtmlReporter htmlReporter = new HtmlReporter();
        File htmlReport = htmlReporter.generateReport(FilesKt.readText$default((File)jsonReport, null, (int)1, null), reportDir);
        this.getProject().getLogger().lifecycle("Wrote HTML report to " + htmlReport.toPath().toUri());
    }
}

