/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.apk;

import com.android.SdkConstants;
import com.android.build.gradle.internal.SdkLocator;
import com.android.builder.errors.DefaultIssueReporter;
import com.android.builder.errors.IssueReporter;
import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.device.DeviceSpecParser;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.spotify.ruler.plugin.models.DeviceSpec;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u00062\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkCreator;", "", "rootDir", "Ljava/io/File;", "(Ljava/io/File;)V", "createSplitApks", "", "", "", "bundleFile", "deviceSpec", "Lcom/spotify/ruler/plugin/models/DeviceSpec;", "targetDir", "getAapt2Location", "Ljava/nio/file/Path;", "getAndroidSdkLocation", "parseDeviceSpec", "Lcom/android/bundle/Devices$DeviceSpec;", "Companion", "ruler-gradle-plugin"})
public final class ApkCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDir;
    @NotNull
    public static final String BASE_FEATURE_NAME = "base";

    public ApkCreator(@NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        this.rootDir = rootDir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<File>> createSplitApks(@NotNull File bundleFile, @NotNull DeviceSpec deviceSpec, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        File[] fileArray = targetDir.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File file;
                File p0 = file = $this$forEach$iv[i];
                boolean bl = false;
                FilesKt.deleteRecursively((File)p0);
            }
        }
        BuildApksCommand.builder().setBundlePath(bundleFile.toPath()).setOutputFile(targetDir.toPath()).setDeviceSpec(this.parseDeviceSpec(deviceSpec)).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)this.getAapt2Location())).setOutputFormat(BuildApksCommand.OutputFormat.DIRECTORY).build().execute();
        Commands.BuildApksResult result = Commands.BuildApksResult.parseFrom((byte[])FilesKt.readBytes((File)FilesKt.resolve((File)targetDir, (String)"toc.pb")));
        List list = result.getVariantList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.variantList");
        Commands.Variant variant = (Commands.Variant)CollectionsKt.single((List)list);
        List list2 = variant.getApkSetList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"variant.apkSetList");
        Iterable $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : iterable) {
            void $this$mapTo$iv$iv;
            Map map = destination$iv$iv;
            Commands.ApkSet apkSet = (Commands.ApkSet)element$iv$iv;
            boolean bl = false;
            String moduleName = apkSet.getModuleMetadata().getName();
            List list3 = apkSet.getApkDescriptionList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"apkSet.apkDescriptionList");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Commands.ApkDescription apkDescription = (Commands.ApkDescription)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                collection.add(FilesKt.resolve((File)targetDir, (String)string));
            }
            List moduleSplits = (List)destination$iv$iv2;
            Pair pair = TuplesKt.to((Object)moduleName, (Object)moduleSplits);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final Devices.DeviceSpec parseDeviceSpec(DeviceSpec deviceSpec) {
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(DeviceSpec.class));
        boolean $i$f$cast = false;
        StringReader reader = new StringReader($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)deviceSpec));
        Devices.DeviceSpec deviceSpec2 = DeviceSpecParser.parseDeviceSpec((Reader)reader);
        Intrinsics.checkNotNullExpressionValue((Object)deviceSpec2, (String)"parseDeviceSpec(reader)");
        return deviceSpec2;
    }

    private final Path getAapt2Location() {
        Path sdkLocation = this.getAndroidSdkLocation();
        AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), (Path)sdkLocation);
        ProgressIndicatorAdapter progressIndicator2 = new ProgressIndicatorAdapter(){};
        BuildToolInfo buildToolInfo = sdkHandler.getLatestBuildTool((ProgressIndicator)progressIndicator2, true);
        Path path = buildToolInfo.getLocation().resolve(SdkConstants.FN_AAPT2);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"buildToolInfo.location.r\u2026ve(SdkConstants.FN_AAPT2)");
        return path;
    }

    private final Path getAndroidSdkLocation() {
        StdLogger logger = new StdLogger(StdLogger.Level.WARNING);
        DefaultIssueReporter issueReporter = new DefaultIssueReporter((ILogger)logger);
        Path path = SdkLocator.getSdkDirectory((File)this.rootDir, (IssueReporter)((IssueReporter)issueReporter)).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getSdkDirectory(rootDir, issueReporter).toPath()");
        return path;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkCreator$Companion;", "", "()V", "BASE_FEATURE_NAME", "", "ruler-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

