/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.apk;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.dex.DexFiles;
import com.spotify.ruler.plugin.apk.ApkEntry;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkParser;", "", "()V", "isDexEntry", "", "entryName", "", "parse", "", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "apkFile", "Ljava/io/File;", "parseDexEntry", "bytes", "", "ruler-gradle-plugin"})
public final class ApkParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ApkEntry> parse(@NotNull File apkFile) {
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        ApkSizeCalculator sizeCalculator = ApkSizeCalculator.getDefault();
        Map downloadSizePerFile = sizeCalculator.getDownloadSizePerFile(apkFile.toPath());
        Map installSizePerFile = sizeCalculator.getRawSizePerFile(apkFile.toPath());
        List apkEntries = new ArrayList();
        Closeable closeable = new ZipFile(apkFile);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
            Iterator $this$forEach$iv = CollectionsKt.iterator(enumeration);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                ApkEntry apkEntry;
                Object element$iv = iterator.next();
                ZipEntry zipEntry = (ZipEntry)element$iv;
                boolean bl2 = false;
                String name = "/" + zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)downloadSizePerFile, (String)"downloadSizePerFile");
                Long downloadSize = (Long)MapsKt.getValue((Map)downloadSizePerFile, (Object)name);
                Intrinsics.checkNotNullExpressionValue((Object)installSizePerFile, (String)"installSizePerFile");
                Long installSize = (Long)MapsKt.getValue((Map)installSizePerFile, (Object)name);
                Collection collection = apkEntries;
                if (this.isDexEntry(name)) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zipFile.getInputStream(zipEntry)");
                    byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                    Intrinsics.checkNotNullExpressionValue((Object)downloadSize, (String)"downloadSize");
                    long l = downloadSize;
                    Intrinsics.checkNotNullExpressionValue((Object)installSize, (String)"installSize");
                    apkEntry = new ApkEntry.Dex(name, l, installSize, this.parseDexEntry(bytes));
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)downloadSize, (String)"downloadSize");
                    long l = downloadSize;
                    Intrinsics.checkNotNullExpressionValue((Object)installSize, (String)"installSize");
                    apkEntry = new ApkEntry.Default(name, l, installSize);
                }
                ApkEntry apkEntry2 = apkEntry;
                collection.add(apkEntry2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return apkEntries;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApkEntry> parseDexEntry(byte[] bytes) {
        void $this$mapTo$iv$iv;
        DexBackedDexFile dexFile = DexFiles.getDexFile((byte[])bytes);
        Set set = dexFile.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"dexFile.classes");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void classDef;
            DexBackedClassDef dexBackedClassDef = (DexBackedClassDef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = classDef.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classDef.type");
            collection.add(new ApkEntry.Default(string, classDef.getSize(), classDef.getSize()));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isDexEntry(String entryName) {
        return StringsKt.endsWith((String)entryName, (String)".dex", (boolean)true);
    }
}

