/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.apk;

import com.spotify.ruler.models.AppFile;
import com.spotify.ruler.models.FileType;
import com.spotify.ruler.plugin.apk.ApkEntry;
import com.spotify.ruler.plugin.common.ClassNameSanitizer;
import com.spotify.ruler.plugin.common.ResourceNameSanitizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0007\f\r\u000e\u000f\u0010\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer;", "", "classNameSanitizer", "Lcom/spotify/ruler/plugin/common/ClassNameSanitizer;", "resourceNameSanitizer", "Lcom/spotify/ruler/plugin/common/ResourceNameSanitizer;", "(Lcom/spotify/ruler/plugin/common/ClassNameSanitizer;Lcom/spotify/ruler/plugin/common/ResourceNameSanitizer;)V", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "entries", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "AndroidManifestBucket", "BundletoolBucket", "DexFileBucket", "ResourceBucket", "ResourcesArscBucket", "SanitizationBucket", "TypeAssigningBucket", "ruler-gradle-plugin"})
public final class ApkSanitizer {
    @NotNull
    private final ClassNameSanitizer classNameSanitizer;
    @NotNull
    private final ResourceNameSanitizer resourceNameSanitizer;

    public ApkSanitizer(@NotNull ClassNameSanitizer classNameSanitizer, @NotNull ResourceNameSanitizer resourceNameSanitizer) {
        Intrinsics.checkNotNullParameter((Object)classNameSanitizer, (String)"classNameSanitizer");
        Intrinsics.checkNotNullParameter((Object)resourceNameSanitizer, (String)"resourceNameSanitizer");
        this.classNameSanitizer = classNameSanitizer;
        this.resourceNameSanitizer = resourceNameSanitizer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AppFile> sanitize(@NotNull List<? extends ApkEntry> entries) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Object[] objectArray = new SanitizationBucket[]{new DexFileBucket(), new AndroidManifestBucket(), new BundletoolBucket(), new ResourcesArscBucket(), new ResourceBucket(), new TypeAssigningBucket()};
        List buckets = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv22;
            ApkEntry entry;
            block3: {
                entry = (ApkEntry)element$iv;
                boolean bl = false;
                Iterable $this$first$iv = buckets;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    SanitizationBucket it = (SanitizationBucket)element$iv22;
                    boolean bl2 = false;
                    if (!it.isApplicable(entry)) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            SanitizationBucket bucket = (SanitizationBucket)element$iv22;
            bucket.add(entry);
        }
        Iterable $this$flatMap$iv = buckets;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SanitizationBucket p0 = (SanitizationBucket)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.sanitize();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H&J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "", "()V", "entries", "", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "getEntries", "()Ljava/util/List;", "add", "", "entry", "isApplicable", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "ruler-gradle-plugin"})
    private static abstract class SanitizationBucket {
        @NotNull
        private final List<ApkEntry> entries = new ArrayList();

        @NotNull
        protected final List<ApkEntry> getEntries() {
            return this.entries;
        }

        public abstract boolean isApplicable(@NotNull ApkEntry var1);

        @NotNull
        public abstract List<AppFile> sanitize();

        public final boolean add(@NotNull ApkEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return this.entries.add(entry);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$DexFileBucket;", "Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "(Lcom/spotify/ruler/plugin/apk/ApkSanitizer;)V", "isApplicable", "", "entry", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "sanitizeEntry", "Lcom/spotify/ruler/plugin/apk/ApkEntry$Dex;", "ruler-gradle-plugin"})
    private final class DexFileBucket
    extends SanitizationBucket {
        @Override
        public boolean isApplicable(@NotNull ApkEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return entry instanceof ApkEntry.Dex;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AppFile> sanitize() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.getEntries();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ApkEntry entry = (ApkEntry)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.sanitizeEntry((ApkEntry.Dex)entry);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<AppFile> sanitizeEntry(ApkEntry.Dex entry) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = entry.getClasses();
            long l = 0L;
            for (Object t : iterable) {
                void p0;
                ApkEntry apkEntry = (ApkEntry)t;
                long l2 = l;
                boolean bl = false;
                long l3 = p0.getInstallSize();
                l = l2 + l3;
            }
            long sizeOfAllClasses = l;
            iterable = entry.getClasses();
            ApkSanitizer apkSanitizer = ApkSanitizer.this;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void classEntry;
                ApkEntry apkEntry = (ApkEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String name = apkSanitizer.classNameSanitizer.sanitize(classEntry.getName());
                long downloadSize = classEntry.getDownloadSize() * entry.getDownloadSize() / sizeOfAllClasses;
                long installSize = classEntry.getInstallSize() * entry.getInstallSize() / sizeOfAllClasses;
                collection.add(new AppFile(name, FileType.CLASS, downloadSize, installSize, null, 16, null));
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$AndroidManifestBucket;", "Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "()V", "isApplicable", "", "entry", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "ruler-gradle-plugin"})
    private static final class AndroidManifestBucket
    extends SanitizationBucket {
        @Override
        public boolean isApplicable(@NotNull ApkEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return Intrinsics.areEqual((Object)entry.getName(), (Object)"/AndroidManifest.xml");
        }

        @Override
        @NotNull
        public List<AppFile> sanitize() {
            Object v0;
            Iterable $this$maxByOrNull$iv = this.getEntries();
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    ApkEntry p0 = (ApkEntry)maxElem$iv;
                    boolean bl = false;
                    long maxValue$iv = p0.getInstallSize();
                    do {
                        Object e$iv = iterator$iv.next();
                        ApkEntry p02 = (ApkEntry)e$iv;
                        $i$a$-maxByOrNull-ApkSanitizer$AndroidManifestBucket$sanitize$entry$1 = false;
                        long v$iv = p02.getInstallSize();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            ApkEntry apkEntry = v0;
            if (apkEntry == null) {
                return CollectionsKt.emptyList();
            }
            ApkEntry entry = apkEntry;
            return CollectionsKt.listOf((Object)new AppFile("/AndroidManifest.xml", FileType.OTHER, entry.getDownloadSize(), entry.getInstallSize(), null, 16, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$BundletoolBucket;", "Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "()V", "isApplicable", "", "entry", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "ruler-gradle-plugin"})
    private static final class BundletoolBucket
    extends SanitizationBucket {
        @Override
        public boolean isApplicable(@NotNull ApkEntry entry) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return Intrinsics.areEqual((Object)entry.getName(), (Object)"/META-INF/MANIFEST.MF") || new Regex("/res/xml/splits\\d+\\.xml").matches(charSequence = (CharSequence)entry.getName());
        }

        @Override
        @NotNull
        public List<AppFile> sanitize() {
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$ResourcesArscBucket;", "Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "()V", "isApplicable", "", "entry", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "ruler-gradle-plugin"})
    private static final class ResourcesArscBucket
    extends SanitizationBucket {
        @Override
        public boolean isApplicable(@NotNull ApkEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return Intrinsics.areEqual((Object)entry.getName(), (Object)"/resources.arsc");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AppFile> sanitize() {
            long l;
            long l2;
            if (this.getEntries().isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable iterable = this.getEntries();
            long l3 = 0L;
            for (Object t : iterable) {
                void p0;
                ApkEntry apkEntry = (ApkEntry)t;
                l2 = l3;
                boolean bl = false;
                l = p0.getDownloadSize();
                l3 = l2 + l;
            }
            long downloadSize = l3;
            Iterable iterable2 = this.getEntries();
            long l4 = 0L;
            for (Object e : iterable2) {
                void p0;
                ApkEntry apkEntry = (ApkEntry)e;
                l2 = l4;
                boolean bl = false;
                l = p0.getInstallSize();
                l4 = l2 + l;
            }
            long installSize = l4;
            return CollectionsKt.listOf((Object)new AppFile("/resources.arsc", FileType.OTHER, downloadSize, installSize, null, 16, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$ResourceBucket;", "Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "(Lcom/spotify/ruler/plugin/apk/ApkSanitizer;)V", "isApplicable", "", "entry", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "sanitizeEntry", "ruler-gradle-plugin"})
    private final class ResourceBucket
    extends SanitizationBucket {
        @Override
        public boolean isApplicable(@NotNull ApkEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return StringsKt.startsWith$default((String)entry.getName(), (String)"/res/", (boolean)false, (int)2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AppFile> sanitize() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ApkEntry apkEntry = (ApkEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.sanitizeEntry((ApkEntry)p0));
            }
            return (List)destination$iv$iv;
        }

        private final AppFile sanitizeEntry(ApkEntry entry) {
            String name = ApkSanitizer.this.resourceNameSanitizer.sanitize(entry.getName());
            return new AppFile(name, FileType.RESOURCE, entry.getDownloadSize(), entry.getInstallSize(), null, 16, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/spotify/ruler/plugin/apk/ApkSanitizer$TypeAssigningBucket;", "Lcom/spotify/ruler/plugin/apk/ApkSanitizer$SanitizationBucket;", "()V", "isApplicable", "", "entry", "Lcom/spotify/ruler/plugin/apk/ApkEntry;", "sanitize", "", "Lcom/spotify/ruler/models/AppFile;", "sanitizeEntry", "ruler-gradle-plugin"})
    private static final class TypeAssigningBucket
    extends SanitizationBucket {
        @Override
        public boolean isApplicable(@NotNull ApkEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AppFile> sanitize() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ApkEntry apkEntry = (ApkEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.sanitizeEntry((ApkEntry)p0));
            }
            return (List)destination$iv$iv;
        }

        private final AppFile sanitizeEntry(ApkEntry entry) {
            FileType type = StringsKt.startsWith$default((String)entry.getName(), (String)"/res/", (boolean)false, (int)2, null) ? FileType.RESOURCE : (StringsKt.startsWith$default((String)entry.getName(), (String)"/assets/", (boolean)false, (int)2, null) ? FileType.ASSET : (StringsKt.startsWith$default((String)entry.getName(), (String)"/lib/", (boolean)false, (int)2, null) ? FileType.NATIVE_LIB : FileType.OTHER));
            return new AppFile(entry.getName(), type, entry.getDownloadSize(), entry.getInstallSize(), null, 16, null);
        }
    }
}

