/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.attribution;

import com.spotify.ruler.models.AppFile;
import com.spotify.ruler.models.FileType;
import com.spotify.ruler.plugin.dependency.DependencyComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JD\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fJ0\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fH\u0002J0\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fH\u0002J0\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fH\u0002J0\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fH\u0002J0\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fH\u0002J0\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006j\u0002`\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/spotify/ruler/plugin/attribution/Attributor;", "", "defaultComponent", "Lcom/spotify/ruler/plugin/dependency/DependencyComponent;", "(Lcom/spotify/ruler/plugin/dependency/DependencyComponent;)V", "attribute", "", "", "Lcom/spotify/ruler/models/AppFile;", "files", "dependencies", "", "Lcom/spotify/ruler/plugin/attribution/Dependencies;", "getComponentForAsset", "name", "getComponentForClass", "getComponentForFile", "getComponentForNativeLib", "getComponentForPackage", "getComponentForResource", "ruler-gradle-plugin"})
public final class Attributor {
    @NotNull
    private final DependencyComponent defaultComponent;

    public Attributor(@NotNull DependencyComponent defaultComponent) {
        Intrinsics.checkNotNullParameter((Object)defaultComponent, (String)"defaultComponent");
        this.defaultComponent = defaultComponent;
    }

    @NotNull
    public final Map<DependencyComponent, List<AppFile>> attribute(@NotNull List<AppFile> files, @NotNull Map<String, ? extends List<DependencyComponent>> dependencies) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Map components = new LinkedHashMap();
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            DependencyComponent dependencyComponent;
            AppFile file = (AppFile)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[file.getType().ordinal()]) {
                case 1: {
                    dependencyComponent = this.getComponentForClass(file.getName(), dependencies);
                    break;
                }
                case 2: {
                    dependencyComponent = this.getComponentForResource(file.getName(), dependencies);
                    break;
                }
                case 3: {
                    dependencyComponent = this.getComponentForAsset(file.getName(), dependencies);
                    break;
                }
                case 4: {
                    dependencyComponent = this.getComponentForNativeLib(file.getName(), dependencies);
                    break;
                }
                case 5: {
                    dependencyComponent = this.getComponentForFile(file.getName(), dependencies);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DependencyComponent dependencyComponent2 = dependencyComponent;
            if (dependencyComponent == null) {
                dependencyComponent2 = this.defaultComponent;
            }
            DependencyComponent component = dependencyComponent2;
            Map $this$getOrPut$iv = components;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(component);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(component, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(file);
        }
        return components;
    }

    /*
     * WARNING - void declaration
     */
    private final DependencyComponent getComponentForClass(String name, Map<String, ? extends List<DependencyComponent>> dependencies) {
        String packageName;
        DependencyComponent component;
        List<DependencyComponent> list = dependencies.get(name);
        boolean bl = list != null ? list.size() == 1 : false;
        if (bl) {
            return (DependencyComponent)CollectionsKt.single((List)((List)MapsKt.getValue(dependencies, (Object)name)));
        }
        String daggerFactoryName = StringsKt.removeSuffix((String)name, (CharSequence)"_Factory");
        List<DependencyComponent> list2 = dependencies.get(daggerFactoryName);
        boolean bl2 = list2 != null ? list2.size() == 1 : false;
        if (bl2) {
            return (DependencyComponent)CollectionsKt.single((List)((List)MapsKt.getValue(dependencies, (Object)daggerFactoryName)));
        }
        String daggerModuleName = StringsKt.substringBefore$default((String)name, (String)"_Provide", null, (int)2, null);
        List<DependencyComponent> list3 = dependencies.get(daggerModuleName);
        boolean bl3 = list3 != null ? list3.size() == 1 : false;
        if (bl3) {
            return (DependencyComponent)CollectionsKt.single((List)((List)MapsKt.getValue(dependencies, (Object)daggerModuleName)));
        }
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)".-$$Lambda$", (boolean)false, (int)2, null) && (component = this.getComponentForPackage(packageName = StringsKt.substringBefore$default((String)name, (String)".-$$Lambda$", null, (int)2, null), dependencies)) != null) {
            return component;
        }
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"$$ExternalSynthetic", (boolean)false, (int)2, null)) {
            void $this$filterTo$iv$iv;
            String simpleClassName = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)name, (String)"$$ExternalSynthetic", null, (int)2, null), (char)'.', null, (int)2, null);
            Map<String, ? extends List<DependencyComponent>> $this$filter$iv = dependencies;
            boolean $i$f$filter = false;
            Map<String, ? extends List<DependencyComponent>> map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)((String)it.getKey()), (char)'.', null, (int)2, null), (Object)simpleClassName)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            List candidates = CollectionsKt.flatten((Iterable)destination$iv$iv.values());
            DependencyComponent component2 = (DependencyComponent)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)candidates));
            if (component2 != null) {
                return component2;
            }
        }
        packageName = StringsKt.substringBeforeLast$default((String)name, (char)'.', null, (int)2, null);
        return this.getComponentForPackage(packageName, dependencies);
    }

    private final DependencyComponent getComponentForResource(String name, Map<String, ? extends List<DependencyComponent>> dependencies) {
        String resourceName = StringsKt.removePrefix((String)name, (CharSequence)"/res");
        List<DependencyComponent> list = dependencies.get(resourceName);
        return list != null ? (DependencyComponent)CollectionsKt.singleOrNull(list) : null;
    }

    private final DependencyComponent getComponentForAsset(String name, Map<String, ? extends List<DependencyComponent>> dependencies) {
        String assetName = StringsKt.removePrefix((String)name, (CharSequence)"/assets");
        List<DependencyComponent> list = dependencies.get(assetName);
        return list != null ? (DependencyComponent)CollectionsKt.singleOrNull(list) : null;
    }

    private final DependencyComponent getComponentForNativeLib(String name, Map<String, ? extends List<DependencyComponent>> dependencies) {
        String nativeLibName = StringsKt.removePrefix((String)name, (CharSequence)"/lib");
        List<DependencyComponent> list = dependencies.get(nativeLibName);
        boolean bl = list != null ? list.size() == 1 : false;
        if (bl) {
            return (DependencyComponent)CollectionsKt.single((List)((List)MapsKt.getValue(dependencies, (Object)nativeLibName)));
        }
        String lzmaName = StringsKt.replace$default((String)nativeLibName, (String)".lzma.", (String)".", (boolean)false, (int)4, null);
        List<DependencyComponent> list2 = dependencies.get(lzmaName);
        return list2 != null ? (DependencyComponent)CollectionsKt.singleOrNull(list2) : null;
    }

    private final DependencyComponent getComponentForFile(String name, Map<String, ? extends List<DependencyComponent>> dependencies) {
        List<DependencyComponent> list = dependencies.get(name);
        return list != null ? (DependencyComponent)CollectionsKt.singleOrNull(list) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final DependencyComponent getComponentForPackage(String name, Map<String, ? extends List<DependencyComponent>> dependencies) {
        void $this$filterTo$iv$iv;
        Map<String, ? extends List<DependencyComponent>> $this$filter$iv = dependencies;
        boolean $i$f$filter = false;
        Map<String, ? extends List<DependencyComponent>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)StringsKt.substringBeforeLast$default((String)((String)it.getKey()), (char)'.', null, (int)2, null), (Object)name)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        List candidates = CollectionsKt.flatten((Iterable)destination$iv$iv.values());
        return (DependencyComponent)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)candidates));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileType.values().length];
            nArray[FileType.CLASS.ordinal()] = 1;
            nArray[FileType.RESOURCE.ordinal()] = 2;
            nArray[FileType.ASSET.ordinal()] = 3;
            nArray[FileType.NATIVE_LIB.ordinal()] = 4;
            nArray[FileType.OTHER.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

