/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.common;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/spotify/ruler/plugin/common/ResourceNameSanitizer;", "", "mappingFile", "Ljava/io/File;", "(Ljava/io/File;)V", "mapping", "", "(Ljava/lang/String;)V", "resourceNameMapping", "", "initialize", "", "reader", "Ljava/io/Reader;", "sanitize", "resourceName", "ruler-gradle-plugin"})
public final class ResourceNameSanitizer {
    @NotNull
    private final Map<String, String> resourceNameMapping;

    public ResourceNameSanitizer(@Nullable File mappingFile) {
        block0: {
            this.resourceNameMapping = new LinkedHashMap();
            File file = mappingFile;
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            this.initialize(new FileReader(it));
        }
    }

    public ResourceNameSanitizer(@NotNull String mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        this.resourceNameMapping = new LinkedHashMap();
        this.initialize(new StringReader(mapping));
    }

    @NotNull
    public final String sanitize(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        String string = this.resourceNameMapping.get(resourceName);
        if (string == null) {
            string = resourceName;
        }
        return string;
    }

    private final void initialize(Reader reader) {
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ResourceNameSanitizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (((CharSequence)trimmed).length() == 0 || !StringsKt.startsWith$default((String)trimmed, (String)"res/", (boolean)false, (int)2, null)) {
                    return;
                }
                String[] stringArray = new String[]{" -> "};
                List split = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (split.size() != 2) {
                    return;
                }
                String clearName = (String)split.get(0);
                String obfuscatedName = StringsKt.removeSurrounding((String)((String)split.get(1)), (CharSequence)"[", (CharSequence)"]");
                ResourceNameSanitizer.access$getResourceNameMapping$p(this.this$0).put("/" + obfuscatedName, "/" + clearName);
            }
        }));
    }

    public static final /* synthetic */ Map access$getResourceNameMapping$p(ResourceNameSanitizer $this) {
        return $this.resourceNameMapping;
    }
}

