/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.dependency;

import com.spotify.ruler.plugin.dependency.DependencyEntry;
import com.spotify.ruler.plugin.dependency.DependencyParser;
import com.spotify.ruler.plugin.models.AppInfo;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lcom/spotify/ruler/plugin/dependency/DependencyParser;", "", "()V", "parse", "", "Lcom/spotify/ruler/plugin/dependency/DependencyEntry;", "project", "Lorg/gradle/api/Project;", "appInfo", "Lcom/spotify/ruler/plugin/models/AppInfo;", "ArtifactParser", "DefaultArtifactParser", "JarArtifactParser", "ruler-gradle-plugin"})
public final class DependencyParser {
    @NotNull
    public final List<DependencyEntry> parse(@NotNull Project project, @NotNull AppInfo appInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Configuration configuration = project.getConfigurations().getByName(appInfo.getVariantName() + "RuntimeClasspath");
        List entries = new ArrayList();
        JarArtifactParser jarArtifactParser = new JarArtifactParser();
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object)"android-classes");
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String artifactType = (String)element$iv;
            boolean bl = false;
            Collection collection = entries;
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
            CollectionsKt.addAll((Collection)collection, (Iterable)jarArtifactParser.parse(configuration, artifactType));
        }
        DefaultArtifactParser defaultArtifactParser = new DefaultArtifactParser();
        Object[] $i$f$forEach22 = new String[]{"android-res", "android-assets", "android-jni"};
        Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])$i$f$forEach22);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            String artifactType = (String)element$iv;
            boolean bl = false;
            Collection collection = entries;
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
            CollectionsKt.addAll((Collection)collection, (Iterable)defaultArtifactParser.parse(configuration, artifactType));
        }
        return entries;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0010"}, d2={"Lcom/spotify/ruler/plugin/dependency/DependencyParser$ArtifactParser;", "", "()V", "getComponentIdentifier", "", "artifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "parse", "", "Lcom/spotify/ruler/plugin/dependency/DependencyEntry;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "artifactType", "parseFile", "artifact", "Ljava/io/File;", "ruler-gradle-plugin"})
    private static abstract class ArtifactParser {
        @NotNull
        public abstract List<DependencyEntry> parseFile(@NotNull File var1, @NotNull ResolvedArtifactResult var2);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DependencyEntry> parse(@NotNull Configuration configuration, @NotNull String artifactType) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
            ArtifactView artifactView = configuration.getIncoming().artifactView(arg_0 -> ArtifactParser.parse$lambda-1(artifactType, arg_0));
            Set set = artifactView.getArtifacts().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"artifactView.artifacts.artifacts");
            Iterable $this$flatMap$iv = set;
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ResolvedArtifactResult artifactResult = (ResolvedArtifactResult)element$iv$iv;
                boolean bl = false;
                File file = artifactResult.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifactResult.file");
                Sequence artifactFiles2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file)), (Function1)parse.1.artifactFiles.1.INSTANCE);
                Sequence list$iv$iv = SequencesKt.flatMapIterable((Sequence)artifactFiles2, (Function1)((Function1)new Function1<File, List<? extends DependencyEntry>>(this, artifactResult){
                    final /* synthetic */ ArtifactParser this$0;
                    final /* synthetic */ ResolvedArtifactResult $artifactResult;
                    {
                        this.this$0 = $receiver;
                        this.$artifactResult = $artifactResult;
                        super(1);
                    }

                    @NotNull
                    public final List<DependencyEntry> invoke(@NotNull File artifactFile) {
                        Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
                        ResolvedArtifactResult resolvedArtifactResult = this.$artifactResult;
                        Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactResult, (String)"artifactResult");
                        return this.this$0.parseFile(artifactFile, resolvedArtifactResult);
                    }
                }));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        protected final String getComponentIdentifier(@NotNull ResolvedArtifactResult artifactResult) {
            Intrinsics.checkNotNullParameter((Object)artifactResult, (String)"artifactResult");
            String string = artifactResult.getId().getComponentIdentifier().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifactResult.id.componentIdentifier.displayName");
            return string;
        }

        private static final void parse$lambda-1$lambda-0(String $artifactType, AttributeContainer attributeContainer) {
            Intrinsics.checkNotNullParameter((Object)$artifactType, (String)"$artifactType");
            attributeContainer.attribute(Attribute.of((String)"artifactType", String.class), (Object)$artifactType);
        }

        private static final void parse$lambda-1(String $artifactType, ArtifactView.ViewConfiguration viewConfiguration) {
            Intrinsics.checkNotNullParameter((Object)$artifactType, (String)"$artifactType");
            viewConfiguration.attributes(arg_0 -> ArtifactParser.parse$lambda-1$lambda-0($artifactType, arg_0));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/spotify/ruler/plugin/dependency/DependencyParser$DefaultArtifactParser;", "Lcom/spotify/ruler/plugin/dependency/DependencyParser$ArtifactParser;", "()V", "parseFile", "", "Lcom/spotify/ruler/plugin/dependency/DependencyEntry;", "artifact", "Ljava/io/File;", "artifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "ruler-gradle-plugin"})
    private static final class DefaultArtifactParser
    extends ArtifactParser {
        @Override
        @NotNull
        public List<DependencyEntry> parseFile(@NotNull File artifact, @NotNull ResolvedArtifactResult artifactResult) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)artifactResult, (String)"artifactResult");
            String string = artifact.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.absolutePath");
            String string2 = artifactResult.getFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifactResult.file.absolutePath");
            String name = StringsKt.removePrefix((String)string, (CharSequence)string2);
            String component = this.getComponentIdentifier(artifactResult);
            return CollectionsKt.listOf((Object)new DependencyEntry.Default(name, component));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/spotify/ruler/plugin/dependency/DependencyParser$JarArtifactParser;", "Lcom/spotify/ruler/plugin/dependency/DependencyParser$ArtifactParser;", "()V", "isClassEntry", "", "entryName", "", "parseFile", "", "Lcom/spotify/ruler/plugin/dependency/DependencyEntry;", "artifact", "Ljava/io/File;", "artifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "ruler-gradle-plugin"})
    private static final class JarArtifactParser
    extends ArtifactParser {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<DependencyEntry> parseFile(@NotNull File artifact, @NotNull ResolvedArtifactResult artifactResult) {
            List list;
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)artifactResult, (String)"artifactResult");
            String component = this.getComponentIdentifier(artifactResult);
            Closeable closeable = new JarFile(artifact);
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                boolean bl = false;
                Enumeration<JarEntry> enumeration = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
                list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)parseFile.1.1.INSTANCE), (Function1)((Function1)new Function1<JarEntry, DependencyEntry>(this, component){
                    final /* synthetic */ JarArtifactParser this$0;
                    final /* synthetic */ String $component;
                    {
                        this.this$0 = $receiver;
                        this.$component = $component;
                        super(1);
                    }

                    @NotNull
                    public final DependencyEntry invoke(JarEntry entry) {
                        DependencyEntry dependencyEntry;
                        String string = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                        if (JarArtifactParser.access$isClassEntry(this.this$0, string)) {
                            String string2 = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                            dependencyEntry = new DependencyEntry.Class(string2, this.$component);
                        } else {
                            String string3 = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                            dependencyEntry = new DependencyEntry.Default(string3, this.$component);
                        }
                        return dependencyEntry;
                    }
                })));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return list;
        }

        private final boolean isClassEntry(String entryName) {
            return StringsKt.endsWith((String)entryName, (String)".class", (boolean)true);
        }

        public static final /* synthetic */ boolean access$isClassEntry(JarArtifactParser $this, String entryName) {
            return $this.isClassEntry(entryName);
        }
    }
}

