/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.dependency;

import com.spotify.ruler.models.ComponentType;
import com.spotify.ruler.plugin.common.ClassNameSanitizer;
import com.spotify.ruler.plugin.dependency.DependencyComponent;
import com.spotify.ruler.plugin.dependency.DependencyEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/spotify/ruler/plugin/dependency/DependencySanitizer;", "", "classNameSanitizer", "Lcom/spotify/ruler/plugin/common/ClassNameSanitizer;", "(Lcom/spotify/ruler/plugin/common/ClassNameSanitizer;)V", "getComponentType", "Lcom/spotify/ruler/models/ComponentType;", "entry", "Lcom/spotify/ruler/plugin/dependency/DependencyEntry;", "sanitize", "", "", "", "Lcom/spotify/ruler/plugin/dependency/DependencyComponent;", "entries", "sanitizeEntry", "ruler-gradle-plugin"})
public final class DependencySanitizer {
    @NotNull
    private final ClassNameSanitizer classNameSanitizer;

    public DependencySanitizer(@NotNull ClassNameSanitizer classNameSanitizer) {
        Intrinsics.checkNotNullParameter((Object)classNameSanitizer, (String)"classNameSanitizer");
        this.classNameSanitizer = classNameSanitizer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<DependencyComponent>> sanitize(@NotNull List<? extends DependencyEntry> entries) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Map map = new LinkedHashMap();
        Iterable $this$map$iv = entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DependencyEntry dependencyEntry = (DependencyEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.sanitizeEntry((DependencyEntry)p0));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            Object item$iv$iv;
            DependencyEntry entry = (DependencyEntry)element$iv;
            boolean bl = false;
            item$iv$iv = map;
            String key$iv = entry.getName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List components = (List)object;
            ComponentType type = this.getComponentType(entry);
            ((Collection)components).add(new DependencyComponent(entry.getComponent(), type));
        }
        return map;
    }

    private final DependencyEntry sanitizeEntry(DependencyEntry entry) {
        DependencyEntry dependencyEntry;
        String component = StringsKt.removePrefix((String)entry.getComponent(), (CharSequence)"project ");
        DependencyEntry dependencyEntry2 = entry;
        if (dependencyEntry2 instanceof DependencyEntry.Class) {
            String name = this.classNameSanitizer.sanitize(entry.getName());
            dependencyEntry = new DependencyEntry.Class(name, component);
        } else if (dependencyEntry2 instanceof DependencyEntry.Default) {
            String name = StringsKt.replace$default((String)entry.getName(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            dependencyEntry = new DependencyEntry.Default(name, component);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dependencyEntry;
    }

    private final ComponentType getComponentType(DependencyEntry entry) {
        return StringsKt.startsWith$default((CharSequence)entry.getComponent(), (char)':', (boolean)false, (int)2, null) ? ComponentType.INTERNAL : ComponentType.EXTERNAL;
    }
}

