/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.ownership;

import com.spotify.ruler.models.ComponentType;
import com.spotify.ruler.plugin.ownership.OwnershipEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/spotify/ruler/plugin/ownership/OwnershipInfo;", "", "entries", "", "Lcom/spotify/ruler/plugin/ownership/OwnershipEntry;", "defaultOwner", "", "(Ljava/util/List;Ljava/lang/String;)V", "explicitOwnershipEntries", "", "wildcardOwnershipEntries", "getOwner", "feature", "component", "componentType", "Lcom/spotify/ruler/models/ComponentType;", "file", "getWildcardOwner", "identifier", "ruler-gradle-plugin"})
public final class OwnershipInfo {
    @NotNull
    private final String defaultOwner;
    @NotNull
    private final Map<String, String> explicitOwnershipEntries;
    @NotNull
    private final Map<String, String> wildcardOwnershipEntries;

    public OwnershipInfo(@NotNull List<OwnershipEntry> entries, @NotNull String defaultOwner) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)defaultOwner, (String)"defaultOwner");
        this.defaultOwner = defaultOwner;
        this.explicitOwnershipEntries = new LinkedHashMap();
        this.wildcardOwnershipEntries = new LinkedHashMap();
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OwnershipEntry ownershipEntry = (OwnershipEntry)element$iv;
            boolean bl = false;
            String identifier = ownershipEntry.component1();
            String owner = ownershipEntry.component2();
            if (StringsKt.endsWith$default((CharSequence)identifier, (char)'*', (boolean)false, (int)2, null)) {
                this.wildcardOwnershipEntries.put(StringsKt.substringBeforeLast$default((String)identifier, (char)'*', null, (int)2, null), owner);
                continue;
            }
            this.explicitOwnershipEntries.put(identifier, owner);
        }
    }

    @NotNull
    public final String getOwner(@NotNull String component, @NotNull ComponentType componentType) {
        String owner;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        switch (WhenMappings.$EnumSwitchMapping$0[componentType.ordinal()]) {
            case 1: {
                string2 = this.explicitOwnershipEntries.get(component);
                break;
            }
            case 2: {
                string2 = this.explicitOwnershipEntries.get(StringsKt.substringBeforeLast$default((String)component, (char)':', null, (int)2, null));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if ((string = (owner = string2)) == null && (string = this.getWildcardOwner(component)) == null) {
            string = this.defaultOwner;
        }
        return string;
    }

    @NotNull
    public final String getOwner(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        String string = this.explicitOwnershipEntries.get(feature);
        if (string == null && (string = this.getWildcardOwner(feature)) == null) {
            string = this.defaultOwner;
        }
        return string;
    }

    @NotNull
    public final String getOwner(@NotNull String file, @NotNull String component, @NotNull ComponentType componentType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        String string = this.explicitOwnershipEntries.get(file);
        if (string == null && (string = this.getWildcardOwner(file)) == null) {
            string = this.getOwner(component, componentType);
        }
        return string;
    }

    @NotNull
    public final String getOwner(@NotNull String file, @NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        String string = this.explicitOwnershipEntries.get(file);
        if (string == null && (string = this.getWildcardOwner(file)) == null) {
            string = this.getOwner(feature);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getWildcardOwner(String identifier) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.wildcardOwnershipEntries.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)identifier, (String)p0, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                String p0 = (String)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = p0.length();
                do {
                    Object e$iv = iterator$iv.next();
                    String p02 = (String)e$iv;
                    $i$a$-maxByOrNull-OwnershipInfo$getWildcardOwner$matchingIdentifier$2 = false;
                    int v$iv = p02.length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        String matchingIdentifier = v0;
        return this.wildcardOwnershipEntries.get(matchingIdentifier);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentType.values().length];
            nArray[ComponentType.INTERNAL.ordinal()] = 1;
            nArray[ComponentType.EXTERNAL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

