/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ruler.plugin.report;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/spotify/ruler/plugin/report/HtmlReporter;", "", "()V", "generateReport", "Ljava/io/File;", "json", "", "targetDir", "readResourceFile", "fileName", "ruler-gradle-plugin"})
public final class HtmlReporter {
    @NotNull
    public final File generateReport(@NotNull String json, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        String html = this.readResourceFile("index.html");
        String javascript = this.readResourceFile("ruler-frontend.js");
        html = StringsKt.replaceFirst$default((String)html, (String)"<script src=\"ruler-frontend.js\"></script>", (String)("<script>" + javascript + "</script>"), (boolean)false, (int)4, null);
        html = StringsKt.replaceFirst$default((String)html, (String)"\"REPLACE_ME\"", (String)("`" + json + "`"), (boolean)false, (int)4, null);
        File reportFile = FilesKt.resolve((File)targetDir, (String)"report.html");
        FilesKt.writeText$default((File)reportFile, (String)html, null, (int)2, null);
        return reportFile;
    }

    private final String readResourceFile(String fileName) {
        URL url;
        URL uRL = this.getClass().getResource("/" + fileName);
        if (uRL == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        URL uRL2 = url = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        return new String(byArray, charset);
    }
}

