/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.dataflow.sdk.io.BigQueryIO;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;

public final class BigQueryUtil$ {
    public static final BigQueryUtil$ MODULE$;
    private final String PROJECT_ID_REGEXP;
    private final String DATASET_REGEXP;
    private final String TABLE_REGEXP;
    private final String DATASET_TABLE_REGEXP;
    private final Pattern QUERY_TABLE_SPEC;

    static {
        new BigQueryUtil$();
    }

    private String PROJECT_ID_REGEXP() {
        return this.PROJECT_ID_REGEXP;
    }

    private String DATASET_REGEXP() {
        return this.DATASET_REGEXP;
    }

    private String TABLE_REGEXP() {
        return this.TABLE_REGEXP;
    }

    private String DATASET_TABLE_REGEXP() {
        return this.DATASET_TABLE_REGEXP;
    }

    private Pattern QUERY_TABLE_SPEC() {
        return this.QUERY_TABLE_SPEC;
    }

    public TableSchema parseSchema(String schemaString) {
        return (TableSchema)new JsonObjectParser((JsonFactory)new JacksonFactory()).parseAndClose((Reader)new StringReader(schemaString), TableSchema.class);
    }

    public Set<TableReference> extractTables(String sqlQuery) {
        Matcher matcher = this.QUERY_TABLE_SPEC().matcher(sqlQuery);
        Builder b = Predef$.MODULE$.Set().newBuilder();
        while (matcher.find()) {
            b.$plus$eq((Object)BigQueryIO.parseTableSpec((String)matcher.group()));
        }
        return (Set)b.result();
    }

    private BigQueryUtil$() {
        MODULE$ = this;
        this.PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
        this.DATASET_REGEXP = "[-\\w.]{1,1024}";
        this.TABLE_REGEXP = "[-\\w$@]{1,1024}";
        this.DATASET_TABLE_REGEXP = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((?<PROJECT>", "):)?(?<DATASET>", ")\\\\.(?<TABLE>", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PROJECT_ID_REGEXP(), this.DATASET_REGEXP(), this.TABLE_REGEXP()}));
        this.QUERY_TABLE_SPEC = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(?<=\\\\[)", "(?=\\\\])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DATASET_TABLE_REGEXP()})));
    }
}

