/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.dataflow.sdk.io.BigQueryIO;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.spotify.scio.bigquery.BigQueryClient;
import com.spotify.scio.bigquery.MockBigQuery$;
import com.spotify.scio.bigquery.MockTable;
import com.spotify.scio.bigquery.types.BigQueryType;
import com.spotify.scio.bigquery.types.BigQueryType$;
import java.io.IOException;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;

@ScalaSignature(bytes="\u0006\u0001\u0005eu!B\u0001\u0003\u0011\u0003Y\u0011\u0001D'pG.\u0014\u0015nZ)vKJL(BA\u0002\u0005\u0003!\u0011\u0017nZ9vKJL(BA\u0003\u0007\u0003\u0011\u00198-[8\u000b\u0005\u001dA\u0011aB:q_RLg-\u001f\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\taQj\\2l\u0005&<\u0017+^3ssN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012!B1qa2LH#\u0001\u000f\u0011\u00051ib\u0001\u0002\b\u0003\u0001y\u0019\"!\b\t\t\u0011\u0001j\"Q1A\u0005\n\u0005\n!AY9\u0016\u0003\t\u0002\"\u0001D\u0012\n\u0005\u0011\u0012!A\u0004\"jOF+XM]=DY&,g\u000e\u001e\u0005\tMu\u0011\t\u0011)A\u0005E\u0005\u0019!-\u001d\u0011\t\u000b]iB\u0011\u0002\u0015\u0015\u0005qI\u0003\"\u0002\u0011(\u0001\u0004\u0011\u0003bB\u0016\u001e\u0005\u0004%I\u0001L\u0001\b[\u0006\u0004\b/\u001b8h+\u0005i\u0003\u0003\u0002\u00184kUj\u0011a\f\u0006\u0003aE\nq!\\;uC\ndWM\u0003\u00023%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Qz#aA'baB\u0011a\u0007Q\u0007\u0002o)\u0011\u0001(O\u0001\u0006[>$W\r\u001c\u0006\u0003\u0007iR!a\u000f\u001f\u0002\u0011M,'O^5dKNT!!\u0010 \u0002\u0007\u0005\u0004\u0018N\u0003\u0002@\u0011\u00051qm\\8hY\u0016L!!Q\u001c\u0003\u001dQ\u000b'\r\\3SK\u001a,'/\u001a8dK\"11)\bQ\u0001\n5\n\u0001\"\\1qa&tw\r\t\u0005\u0006\u000bv!\tAR\u0001\n[>\u001c7\u000eV1cY\u0016$\"a\u0012&\u0011\u00051A\u0015BA%\u0003\u0005%iunY6UC\ndW\rC\u0003L\t\u0002\u0007A*\u0001\u0005pe&<\u0017N\\1m!\ti\u0005K\u0004\u0002\u0012\u001d&\u0011qJE\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P%!)Q)\bC\u0001)R\u0011q)\u0016\u0005\u0006\u0017N\u0003\r!\u000e\u0005\u0006/v!\t\u0001W\u0001\fcV,'/\u001f*fgVdG\u000fF\u0002ZW6\u00042A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_\u0015\u00051AH]8pizJ\u0011aE\u0005\u0003CJ\tq\u0001]1dW\u0006<W-\u0003\u0002dI\n\u00191+Z9\u000b\u0005\u0005\u0014\u0002C\u00014i\u001d\taq-\u0003\u0002b\u0005%\u0011\u0011N\u001b\u0002\t)\u0006\u0014G.\u001a*po*\u0011\u0011M\u0001\u0005\u0006YZ\u0003\r\u0001T\u0001\tgFd\u0017+^3ss\"9aN\u0016I\u0001\u0002\u0004y\u0017A\u00044mCR$XM\u001c*fgVdGo\u001d\t\u0003#AL!!\u001d\n\u0003\u000f\t{w\u000e\\3b]\")1/\bC\u0001i\u0006\u0001B/\u001f9fIF+XM]=SKN,H\u000e^\u000b\u0003kj$RA^A0\u0003C\"Ra^A\u0014\u0003o\u00012A\u00172y!\tI(\u0010\u0004\u0001\u0005\u000bm\u0014(\u0019\u0001?\u0003\u0003Q\u000b2!`A\u0001!\t\tb0\u0003\u0002\u0000%\t9aj\u001c;iS:<\u0007\u0003BA\u0002\u0003CqA!!\u0002\u0002\u001c9!\u0011qAA\f\u001d\u0011\tI!!\u0006\u000f\t\u0005-\u00111\u0003\b\u0005\u0003\u001b\t\tBD\u0002]\u0003\u001fI\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011bAA\r\u0005\u0005)A/\u001f9fg&!\u0011QDA\u0010\u00031\u0011\u0015nZ)vKJLH+\u001f9f\u0015\r\tIBA\u0005\u0005\u0003G\t)CA\u0007ICN\feN\\8uCRLwN\u001c\u0006\u0005\u0003;\ty\u0002C\u0005\u0002*I\f\t\u0011q\u0001\u0002,\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u000b\u00055\u00121\u0007=\u000e\u0005\u0005=\"bAA\u0019%\u00059!/\u001a4mK\u000e$\u0018\u0002BA\u001b\u0003_\u0011\u0001b\u00117bgN$\u0016m\u001a\u0005\n\u0003s\u0011\u0018\u0011!a\u0002\u0003w\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0015\ti$!\u0016y\u001d\u0011\ty$a\u0014\u000f\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\n9ED\u0002\\\u0003\u000bJ1!!\r\u0013\u0013\u0011\tI%a\f\u0002\u000fI,h\u000e^5nK&\u0019\u0011-!\u0014\u000b\t\u0005%\u0013qF\u0005\u0005\u0003#\n\u0019&\u0001\u0005v]&4XM]:f\u0015\r\t\u0017QJ\u0005\u0005\u0003/\nIFA\u0004UsB,G+Y4\n\t\u0005m\u0013Q\f\u0002\t)f\u0004X\rV1hg*\u0019Q(a\f\t\u000b1\u0014\b\u0019\u0001'\t\u000f9\u0014\b\u0013!a\u0001_\"9\u0011QM\u000f\u0005\n\u0005\u001d\u0014a\u0003;p)\u0006\u0014G.Z*qK\u000e$R\u0001TA5\u0003[Bq!a\u001b\u0002d\u0001\u0007Q'A\u0003uC\ndW\rC\u0004\u0002p\u0005\r\u0004\u0019A8\u0002\u0011%\u001cH*Z4bGfD\u0011\"a\u001d\u001e#\u0003%\t!!\u001e\u0002+E,XM]=SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000f\u0016\u0004_\u0006e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015%#\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u00055U$%A\u0005\u0002\u0005=\u0015A\u0007;za\u0016$\u0017+^3ssJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u0012T\u0003BA;\u0003##aa_AF\u0005\u0004a\bB\u0002\u000e\u000e\t\u0003\t)\nF\u0002\u001d\u0003/Ca\u0001IAJ\u0001\u0004\u0011\u0003")
public class MockBigQuery {
    private final BigQueryClient bq;
    private final Map<TableReference, TableReference> mapping;

    public static MockBigQuery apply(BigQueryClient bigQueryClient) {
        return MockBigQuery$.MODULE$.apply(bigQueryClient);
    }

    public static MockBigQuery apply() {
        return MockBigQuery$.MODULE$.apply();
    }

    private BigQueryClient bq() {
        return this.bq;
    }

    private Map<TableReference, TableReference> mapping() {
        return this.mapping;
    }

    public MockTable mockTable(String original) {
        return this.mockTable(BigQueryIO.parseTableSpec((String)original));
    }

    public MockTable mockTable(TableReference original) {
        Predef$.MODULE$.require(!this.mapping().contains((Object)original), (Function0)new Serializable(this, original){
            public static final long serialVersionUID = 0L;
            private final TableReference original$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already registered for mocking"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BigQueryIO.toTableSpec((TableReference)this.original$1)}));
            }
            {
                this.original$1 = original$1;
            }
        });
        Table t = this.bq().getTable(original);
        TableReference temp = this.bq().temporaryTable(t.getLocation());
        this.mapping().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)original), (Object)temp));
        return new MockTable(this.bq(), t.getSchema(), original, temp);
    }

    public Seq<TableRow> queryResult(String sqlQuery, boolean flattenResults) {
        boolean isLegacy = this.bq().isLegacySql(sqlQuery, flattenResults);
        String mockQuery = (String)this.mapping().foldLeft((Object)sqlQuery, (Function2)new Serializable(this, isLegacy){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MockBigQuery $outer;
            private final boolean isLegacy$1;

            public final String apply(String x0$1, Tuple2<TableReference, TableReference> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                if (tuple2 != null) {
                    String q = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        TableReference src = (TableReference)tuple22._1();
                        TableReference dst = (TableReference)tuple22._2();
                        String string = q.replace(this.$outer.com$spotify$scio$bigquery$MockBigQuery$$toTableSpec(src, this.isLegacy$1), this.$outer.com$spotify$scio$bigquery$MockBigQuery$$toTableSpec(dst, this.isLegacy$1));
                        return string;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isLegacy$1 = isLegacy$1;
            }
        });
        try {
            return this.bq().getQueryRows(mockQuery, flattenResults).toList();
        }
        catch (Throwable throwable) {
            GoogleJsonResponseException googleJsonResponseException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof GoogleJsonResponseException && new ApiErrorExtractor().itemNotFound((IOException)(googleJsonResponseException = (GoogleJsonResponseException)throwable2))) {
                throw new RuntimeException("404 Not Found, this is most likely caused by missing source table or mock data", (Throwable)googleJsonResponseException);
            }
            throw throwable;
        }
    }

    public boolean queryResult$default$2() {
        return false;
    }

    public <T extends BigQueryType.HasAnnotation> Seq<T> typedQueryResult(String sqlQuery, boolean flattenResults, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        BigQueryType<T> bqt = BigQueryType$.MODULE$.apply(evidence$2);
        return (Seq)this.queryResult(sqlQuery, flattenResults).map(bqt.fromTableRow(), Seq$.MODULE$.canBuildFrom());
    }

    public <T extends BigQueryType.HasAnnotation> boolean typedQueryResult$default$2() {
        return false;
    }

    public String com$spotify$scio$bigquery$MockBigQuery$$toTableSpec(TableReference table2, boolean isLegacy) {
        return isLegacy ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ":", ".", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2.getProjectId(), table2.getDatasetId(), table2.getTableId()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", ".", ".", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2.getProjectId(), table2.getDatasetId(), table2.getTableId()}));
    }

    public MockBigQuery(BigQueryClient bq) {
        this.bq = bq;
        this.mapping = Map$.MODULE$.empty();
    }
}

