/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.primitives.Longs;
import com.spotify.scio.bigquery.BigQueryClient;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;

public final class BigQueryPartitionUtil$ {
    public static final BigQueryPartitionUtil$ MODULE$;
    private final String PROJECT_ID_REGEXP;
    private final String DATASET_REGEXP;
    private final String TABLE_REGEXP;
    private final String DATASET_TABLE_REGEXP_LEGACY;
    private final String DATASET_TABLE_REGEXP_STANDARD;
    private final Pattern QUERY_TABLE_SPEC_LEGACY;
    private final Pattern QUERY_TABLE_SPEC_STANDARD;

    static {
        new BigQueryPartitionUtil$();
    }

    private String PROJECT_ID_REGEXP() {
        return this.PROJECT_ID_REGEXP;
    }

    private String DATASET_REGEXP() {
        return this.DATASET_REGEXP;
    }

    private String TABLE_REGEXP() {
        return this.TABLE_REGEXP;
    }

    private String DATASET_TABLE_REGEXP_LEGACY() {
        return this.DATASET_TABLE_REGEXP_LEGACY;
    }

    private String DATASET_TABLE_REGEXP_STANDARD() {
        return this.DATASET_TABLE_REGEXP_STANDARD;
    }

    private Pattern QUERY_TABLE_SPEC_LEGACY() {
        return this.QUERY_TABLE_SPEC_LEGACY;
    }

    private Pattern QUERY_TABLE_SPEC_STANDARD() {
        return this.QUERY_TABLE_SPEC_STANDARD;
    }

    private Map<String, TableReference> extractTables(String sqlQuery) {
        Builder b = Predef$.MODULE$.Map().newBuilder();
        Matcher m1 = this.QUERY_TABLE_SPEC_LEGACY().matcher(sqlQuery);
        while (m1.find()) {
            String t = m1.group(0);
            b.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}))), (Object)BigQueryHelpers.parseTableSpec((String)t)));
        }
        Matcher m2 = this.QUERY_TABLE_SPEC_STANDARD().matcher(sqlQuery);
        while (m2.find()) {
            String t = m2.group(0);
            b.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}))), (Object)BigQueryHelpers.parseTableSpec((String)t.replaceFirst("\\.", ":"))));
        }
        return (Map)b.result();
    }

    public Set<String> com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(BigQueryClient bq, TableReference tableRef) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(tableRef.getTableId())).split('$')[0];
        return (Set)((TraversableOnce)((TraversableLike)bq.getTables(tableRef.getProjectId(), tableRef.getDatasetId()).filter((Function1)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(TableReference x$1) {
                return x$1.getTableId().startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        })).map((Function1)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final String apply(TableReference x$2) {
                return x$2.getTableId().substring(this.prefix$1.length());
            }
            {
                this.prefix$1 = prefix$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String e) {
                return Longs.tryParse((String)e) != null;
            }
        });
    }

    public String latestQuery(BigQueryClient bq, String sqlQuery) {
        String string;
        Map tables = (Map)this.extractTables(sqlQuery).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, TableReference> x$3) {
                return ((TableReference)x$3._2()).getTableId().endsWith("$LATEST");
            }
        });
        if (tables.isEmpty()) {
            string = sqlQuery;
        } else {
            Set overlaps = (Set)((TraversableOnce)tables.map((Function1)new Serializable(bq){
                public static final long serialVersionUID = 0L;
                private final BigQueryClient bq$1;

                public final Set<String> apply(Tuple2<String, TableReference> t) {
                    return BigQueryPartitionUtil$.MODULE$.com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(this.bq$1, (TableReference)t._2());
                }
                {
                    this.bq$1 = bq$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply(Set<String> x$4, Set<String> x$5) {
                    return (Set)x$4.intersect(x$5);
                }
            });
            Predef$.MODULE$.require(overlaps.nonEmpty(), (Function0)new Serializable(tables){
                public static final long serialVersionUID = 0L;
                private final Map tables$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cannot find latest common partition for ").append((Object)this.tables$1.keys().mkString(", ")).toString();
                }
                {
                    this.tables$1 = tables$1;
                }
            });
            String latest = (String)overlaps.max((Ordering)Ordering.String$.MODULE$);
            string = (String)tables.foldLeft((Object)sqlQuery, (Function2)new Serializable(latest){
                public static final long serialVersionUID = 0L;
                private final String latest$1;

                public final String apply(String x0$1, Tuple2<String, TableReference> x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                    if (tuple2 != null) {
                        String q = (String)tuple2._1();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            String spec = (String)tuple22._1();
                            String string = q.replace(spec, spec.replace("$LATEST", this.latest$1));
                            return string;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.latest$1 = latest$1;
                }
            });
        }
        return string;
    }

    public String latestTable(BigQueryClient bq, String tableSpec) {
        String string;
        TableReference ref = BigQueryHelpers.parseTableSpec((String)tableSpec);
        if (ref.getTableId().endsWith("$LATEST")) {
            Set<String> partitions = this.com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(bq, ref);
            Predef$.MODULE$.require(partitions.nonEmpty(), (Function0)new Serializable(tableSpec){
                public static final long serialVersionUID = 0L;
                private final String tableSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find latest partition for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableSpec$1}));
                }
                {
                    this.tableSpec$1 = tableSpec$1;
                }
            });
            string = tableSpec.replace("$LATEST", (CharSequence)partitions.max((Ordering)Ordering.String$.MODULE$));
        } else {
            string = tableSpec;
        }
        return string;
    }

    private BigQueryPartitionUtil$() {
        MODULE$ = this;
        this.PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
        this.DATASET_REGEXP = "[-\\w.]{1,1024}";
        this.TABLE_REGEXP = "[-\\w$@]{1,1024}($LATEST)?";
        this.DATASET_TABLE_REGEXP_LEGACY = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((?<PROJECT>", "):)?(?<DATASET>", ")\\\\.(?<TABLE>", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PROJECT_ID_REGEXP(), this.DATASET_REGEXP(), this.TABLE_REGEXP()}));
        this.DATASET_TABLE_REGEXP_STANDARD = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((?<PROJECT>", ").)?(?<DATASET>", ")\\\\.(?<TABLE>", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PROJECT_ID_REGEXP(), this.DATASET_REGEXP(), this.TABLE_REGEXP()}));
        this.QUERY_TABLE_SPEC_LEGACY = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(?<=\\\\[)", "(?=\\\\])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DATASET_TABLE_REGEXP_LEGACY()})));
        this.QUERY_TABLE_SPEC_STANDARD = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(?<=\\\\`)", "(?=\\\\`)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DATASET_TABLE_REGEXP_STANDARD()})));
    }
}

