/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.joda.time.Instant;

public class BigQueryServicesWrapper {
    private final BigQueryServices bqServices = new BigQueryServicesImpl();
    private final BigQueryOptions bqOptions;

    public BigQueryServicesWrapper(BigQueryOptions bigQueryOptions) {
        this.bqOptions = bigQueryOptions;
    }

    public void createTable(TableReference tableReference, TableSchema tableSchema) throws IOException, InterruptedException {
        Table table2 = new Table().setTableReference(tableReference).setSchema(tableSchema);
        this.bqServices.getDatasetService(this.bqOptions).createTable(table2);
    }

    public long insertAll(TableReference tableReference, List<TableRow> list) throws IOException, InterruptedException {
        List list2 = list.stream().map(tableRow -> ValueInSingleWindow.of((Object)tableRow, (Instant)BoundedWindow.TIMESTAMP_MIN_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)).collect(Collectors.toList());
        return this.bqServices.getDatasetService(this.bqOptions).insertAll(tableReference, list2, null, InsertRetryPolicy.alwaysRetry(), null);
    }
}

