/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.types;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.spotify.scio.bigquery.BigQueryClient;
import com.spotify.scio.bigquery.BigQueryClient$;
import com.spotify.scio.bigquery.BigQueryPartitionUtil$;
import com.spotify.scio.bigquery.BigQueryUtil$;
import com.spotify.scio.bigquery.types.BigQueryTag;
import com.spotify.scio.bigquery.types.MacroUtil$;
import com.spotify.scio.bigquery.types.NameProvider$;
import com.spotify.scio.bigquery.types.SchemaUtil$;
import com.spotify.scio.bigquery.types.TypeProvider$;
import com.spotify.scio.bigquery.types.TypeProvider$$anonfun$6$;
import com.spotify.scio.bigquery.validation.OverrideTypeProvider;
import com.spotify.scio.bigquery.validation.OverrideTypeProviderFinder$;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.Tuple9;
import scala.UninitializedFieldError;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.api.Constants;
import scala.reflect.api.Exprs;
import scala.reflect.api.Mirror;
import scala.reflect.api.Names;
import scala.reflect.api.Symbols;
import scala.reflect.api.Trees;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.macros.blackbox.Context;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class TypeProvider$ {
    public static final TypeProvider$ MODULE$;
    private final Logger logger;
    private BigQueryClient bigquery;
    private volatile boolean bitmap$init$0;
    private volatile boolean bitmap$0;

    static {
        new TypeProvider$();
    }

    private BigQueryClient bigquery$lzycompute() {
        TypeProvider$ typeProvider$ = this;
        synchronized (typeProvider$) {
            if (!this.bitmap$0) {
                this.bigquery = BigQueryClient$.MODULE$.defaultInstance();
                this.bitmap$0 = true;
            }
            return this.bigquery;
        }
    }

    private Logger logger() {
        if (this.bitmap$init$0) {
            return this.logger;
        }
        throw new UninitializedFieldError("Uninitialized field: TypeProvider.scala: 39");
    }

    private BigQueryClient bigquery() {
        return this.bitmap$0 ? this.bigquery : this.bigquery$lzycompute();
    }

    public Exprs.Expr<Object> tableImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        List<String> args = this.extractStrings(c, "Missing table specification");
        String tableSpec = BigQueryPartitionUtil$.MODULE$.latestTable(this.bigquery(), this.formatString(args));
        TableSchema schema = this.bigquery().getTableSchema(tableSpec);
        List traits = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TypeName().apply("HasTable"))}));
        List overrides = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("table"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("_root_"), false), c.universe().TermName().apply("java")), c.universe().TermName().apply("lang")), c.universe().TypeName().apply("String")), c.universe().Liftable().liftString().apply(args.head()))}));
        return this.schemaToType(c, schema, seq, (Seq<Trees.TreeApi>)traits, (Seq<Trees.TreeApi>)overrides);
    }

    public Exprs.Expr<Object> schemaImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        String schemaString = (String)this.extractStrings(c, "Missing schema").head();
        TableSchema schema = BigQueryUtil$.MODULE$.parseSchema(schemaString);
        return this.schemaToType(c, schema, seq, (Seq<Trees.TreeApi>)Nil$.MODULE$, (Seq<Trees.TreeApi>)Nil$.MODULE$);
    }

    public Exprs.Expr<Object> queryImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        List<String> args = this.extractStrings(c, "Missing query");
        String query2 = BigQueryPartitionUtil$.MODULE$.latestQuery(this.bigquery(), this.formatString(args));
        TableSchema schema = this.bigquery().getQuerySchema(query2);
        Seq traits = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TypeName().apply("HasQuery"))}));
        Seq overrides = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("query"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("_root_"), false), c.universe().TermName().apply("java")), c.universe().TermName().apply("lang")), c.universe().TypeName().apply("String")), c.universe().Liftable().liftString().apply(args.head()))}));
        return this.schemaToType(c, schema, seq, (Seq<Trees.TreeApi>)traits, (Seq<Trees.TreeApi>)overrides);
    }

    private List<Trees.TreeApi> getTableDescription(Context c, Trees.ClassDefApi cd) {
        Trees.ClassDefApi classDefApi = cd;
        return (List)((List)classDefApi.mods().annotations().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Trees.TreeApi x$1) {
                return ((Trees.TreeApi)x$1.children().head()).toString().matches("^new description$");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Trees.TreeApi x$2) {
                return (Trees.TreeApi)((IterableLike)x$2.children().tail()).head();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Exprs.Expr<Object> toTableImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        this.checkMacroEnclosed(c);
        OverrideTypeProvider provider = OverrideTypeProviderFinder$.MODULE$.getProvider();
        Seq seq2 = (Seq)seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Exprs.Expr<Object> x$3) {
                return x$3.tree();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (seq2 instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)seq2;
            Object clazzDef = colon2.head();
            List tail = colon2.tl$1();
            Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> option = new Object(c){
                private final Context c$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> unapply(Object tree) {
                    Object object = tree;
                    Option option = this.c$1.universe().TreeTag().unapply(object);
                    if (option.isEmpty()) return None$.MODULE$;
                    Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                    Option option2 = this.c$1.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                    if (option2.isEmpty()) return None$.MODULE$;
                    Trees.ModifiersApi qq$602fc75d$macro$94 = (Trees.ModifiersApi)((Tuple9)option2.get())._1();
                    Names.TypeNameApi qq$602fc75d$macro$95 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                    List qq$602fc75d$macro$96 = (List)((Tuple9)option2.get())._3();
                    Trees.ModifiersApi qq$602fc75d$macro$97 = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                    List list = (List)((Tuple9)option2.get())._5();
                    List qq$602fc75d$macro$99 = (List)((Tuple9)option2.get())._6();
                    List qq$602fc75d$macro$100 = (List)((Tuple9)option2.get())._7();
                    Trees.ValDefApi qq$602fc75d$macro$101 = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                    List qq$602fc75d$macro$102 = (List)((Tuple9)option2.get())._9();
                    if (!(list instanceof .colon.colon)) return None$.MODULE$;
                    .colon.colon colon2 = (.colon.colon)list;
                    List qq$602fc75d$macro$98 = (List)colon2.head();
                    List list2 = colon2.tl$1();
                    if (!Nil$.MODULE$.equals(list2)) return None$.MODULE$;
                    return new Some((Object)new Tuple9((Object)qq$602fc75d$macro$94, (Object)qq$602fc75d$macro$95, (Object)qq$602fc75d$macro$96, (Object)qq$602fc75d$macro$97, (Object)qq$602fc75d$macro$98, (Object)qq$602fc75d$macro$99, (Object)qq$602fc75d$macro$100, (Object)qq$602fc75d$macro$101, (Object)qq$602fc75d$macro$102));
                }
                {
                    this.c$1 = c$1;
                }
            }.unapply(clazzDef);
            if (!option.isEmpty()) {
                Trees.ModifiersApi mods = (Trees.ModifiersApi)((Tuple9)option.get())._1();
                Names.TypeNameApi cName = (Names.TypeNameApi)((Tuple9)option.get())._2();
                List fields = (List)((Tuple9)option.get())._5();
                List parents = (List)((Tuple9)option.get())._7();
                List body = (List)((Tuple9)option.get())._9();
                if (mods.hasFlag(c.universe().Flag().CASE())) {
                    Set set = ((TraversableOnce)parents.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Trees.TreeApi x$4) {
                            return x$4.toString();
                        }
                    }, List$.MODULE$.canBuildFrom())).toSet();
                    GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.Product", "scala.Serializable"}));
                    if (!(set != null ? !set.equals(genTraversable) : genTraversable != null)) {
                        List<Trees.TreeApi> desc = this.getTableDescription(c, (Trees.ClassDefApi)clazzDef);
                        Trees.DefDefApi defSchema = c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("schema"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.GModel()), c.universe().TypeName().apply("TableSchema")), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TermName().apply("schemaOf")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(cName)}))));
                        Option defTblDesc = desc.headOption().map((Function1)new Serializable(c){
                            public static final long serialVersionUID = 0L;
                            private final Context c$1;

                            public final Trees.DefDefApi apply(Trees.TreeApi d) {
                                return this.c$1.universe().internal().reificationSupport().SyntacticDefDef().apply(this.c$1.universe().Modifiers().apply(this.c$1.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)this.c$1.universe().TypeName().apply(""), (List)Nil$.MODULE$), this.c$1.universe().TermName().apply("tableDescription"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticTermIdent().apply(this.c$1.universe().TermName().apply("_root_"), false), this.c$1.universe().TermName().apply("java")), this.c$1.universe().TermName().apply("lang")), this.c$1.universe().TypeName().apply("String")), d);
                            }
                            {
                                this.c$1 = c$1;
                            }
                        });
                        Trees.DefDefApi defToPrettyString = c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("toPrettyString"), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.ValDefApi[]{c.universe().internal().reificationSupport().SyntacticValDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(0x2002000L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("indent"), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply("Int")), (Trees.TreeApi)c.universe().Literal().apply(c.universe().Constant().apply((Object)BoxesRunTime.boxToInteger((int)0))))}))})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply("String")), c.universe().internal().reificationSupport().SyntacticApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".types.SchemaUtil"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MacroUtil$.MODULE$.SBQ()}))), c.universe().TermName().apply("toPrettyString")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().This().apply(c.universe().TypeName().apply("")), c.universe().TermName().apply("schema")), c.universe().Liftable().liftString().apply((Object)cName.toString()), c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("indent"), false)}))}))));
                        Trees.TreeApi fnTrait = c.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fields.size())})))), (List)((List)fields.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Trees.TreeApi apply(Trees.ValDefApi x$5) {
                                return (Trees.TreeApi)x$5.children().head();
                            }
                        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(cName)})), List$.MODULE$.canBuildFrom()));
                        Seq traits = (Seq)((TraversableLike)(fields.size() <= 22 ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{fnTrait})) : Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(defTblDesc.map((Function1)new Serializable(c){
                            public static final long serialVersionUID = 0L;
                            private final Context c$1;

                            public final Trees.SelectApi apply(Trees.DefDefApi x$6) {
                                return this.c$1.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(this.c$1, MacroUtil$.MODULE$.SType()), this.c$1.universe().TypeName().apply("HasTableDescription"));
                            }
                            {
                                this.c$1 = c$1;
                            }
                        })), Seq$.MODULE$.canBuildFrom());
                        List taggedFields = (List)fields.map((Function1)new Serializable(c, provider){
                            public static final long serialVersionUID = 0L;
                            private final Context c$1;
                            private final OverrideTypeProvider provider$1;

                            public final Trees.ValDefApi apply(Trees.ValDefApi x0$1) {
                                Option option;
                                block3: {
                                    Trees.ValDefApi valDefApi;
                                    block2: {
                                        valDefApi = x0$1;
                                        Option option2 = this.c$1.universe().ValDefTag().unapply((Object)valDefApi);
                                        if (option2.isEmpty()) break block2;
                                        Trees.ValDefApi valDefApi2 = (Trees.ValDefApi)option2.get();
                                        option = this.c$1.universe().ValDef().unapply(valDefApi2);
                                        if (!option.isEmpty()) break block3;
                                    }
                                    throw new MatchError((Object)valDefApi);
                                }
                                Trees.ModifiersApi m = (Trees.ModifiersApi)((Tuple4)option.get())._1();
                                Names.TermNameApi n = (Names.TermNameApi)((Tuple4)option.get())._2();
                                Trees.TreeApi tpt = (Trees.TreeApi)((Tuple4)option.get())._3();
                                Trees.TreeApi rhs = (Trees.TreeApi)((Tuple4)option.get())._4();
                                this.provider$1.initializeToTable(this.c$1, m, n, tpt);
                                Trees.TreeApi[] treeApiArray = new Trees.TreeApi[1];
                                scala.reflect.macros.Universe $u = this.c$1.universe();
                                Mirror $m = this.c$1.universe().rootMirror();
                                public final class Com_spotify_scio_bigquery_types_TypeProvider$$anonfun$6$$typecreator1$1
                                extends TypeCreator {
                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return $m.staticClass("com.spotify.scio.bigquery.types.BigQueryTag").asType().toTypeConstructor();
                                    }

                                    public Com_spotify_scio_bigquery_types_TypeProvider$$anonfun$6$$typecreator1$1(anonfun.6 $outer) {
                                    }
                                }
                                treeApiArray[0] = this.c$1.universe().Liftable().liftType().apply((Object)this.c$1.universe().typeOf($u.TypeTag().apply($m, (TypeCreator)new Com_spotify_scio_bigquery_types_TypeProvider$$anonfun$6$$typecreator1$1(this))));
                                Trees.ValDefApi valDefApi = this.c$1.universe().ValDef().apply(this.c$1.universe().Modifiers().apply(m.flags(), m.privateWithin(), m.annotations()), n, (Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticAnnotatedType().apply(tpt, this.c$1.universe().internal().reificationSupport().SyntacticNew().apply((List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])treeApiArray)), (Trees.TreeApi)this.c$1.universe().noSelfType(), (List)Nil$.MODULE$)), rhs);
                                return valDefApi;
                            }
                            {
                                this.c$1 = c$1;
                                this.provider$1 = provider$1;
                            }
                        }, List$.MODULE$.canBuildFrom());
                        Trees.TreeApi caseClassTree = this.caseClass(c, cName, (Seq<Trees.TreeApi>)taggedFields, (Seq<Trees.TreeApi>)body);
                        Option maybeCompanion = tail.headOption();
                        Tuple3 tuple3 = new Tuple3((Object)c.universe().internal().reificationSupport().SyntacticBlock().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{caseClassTree, this.companion(c, cName, (Seq<Trees.TreeApi>)traits, (Seq<Trees.TreeApi>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{defSchema, defToPrettyString}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(defTblDesc), Seq$.MODULE$.canBuildFrom())), taggedFields.size(), (Option<Trees.TreeApi>)maybeCompanion)}))), (Object)caseClassTree, (Object)cName.toString());
                        Tuple3 tuple32 = tuple3;
                        if (tuple32 != null) {
                            Tuple3 tuple33;
                            Trees.TreeApi r = (Trees.TreeApi)tuple32._1();
                            Trees.TreeApi caseClassTree2 = (Trees.TreeApi)tuple32._2();
                            String name = (String)tuple32._3();
                            Tuple3 tuple34 = tuple33 = new Tuple3((Object)r, (Object)caseClassTree2, (Object)name);
                            Trees.TreeApi r2 = (Trees.TreeApi)tuple34._1();
                            Trees.TreeApi caseClassTree3 = (Trees.TreeApi)tuple34._2();
                            String name2 = (String)tuple34._3();
                            MacroUtil$.MODULE$.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TypeProvider.toTableImpl:"})).s((Seq)Nil$.MODULE$));
                            MacroUtil$.MODULE$.debug(r2);
                            if (this.shouldDumpClassesForPlugin()) {
                                this.dumpCodeForScalaPlugin(c, (Seq<Trees.TreeApi>)((Seq)Seq$.MODULE$.empty()), caseClassTree3, name2);
                            }
                            return c.Expr(r2, c.universe().WeakTypeTag().Any());
                        }
                        throw new MatchError((Object)tuple32);
                    }
                    throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation, don't extend the case class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazzDef})));
                }
            }
        }
        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq2})));
    }

    private Exprs.Expr<Object> schemaToType(Context c, TableSchema schema, Seq<Exprs.Expr<Object>> annottees, Seq<Trees.TreeApi> traits, Seq<Trees.TreeApi> overrides) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        Seq<Trees.TreeApi> seq2 = traits;
        Seq<Trees.TreeApi> seq3 = overrides;
        this.checkMacroEnclosed(c);
        OverrideTypeProvider provider = OverrideTypeProviderFinder$.MODULE$.getProvider();
        Tuple2 tuple2 = this.toFields$1(schema.getFields(), c, provider);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq fields = (Seq)tuple2._1();
            Seq records = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fields, (Object)records);
            Seq fields2 = (Seq)tuple23._1();
            Seq records2 = (Seq)tuple23._2();
            Seq seq4 = (Seq)seq.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Trees.TreeApi apply(Exprs.Expr<Object> x$14) {
                    return x$14.tree();
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (seq4 instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)seq4;
                Object clazzDef = colon2.head();
                List tail = colon2.tl$1();
                Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> option = new Object(c){
                    private final Context c$3;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> unapply(Object tree) {
                        Object object = tree;
                        Option option = this.c$3.universe().TreeTag().unapply(object);
                        if (option.isEmpty()) return None$.MODULE$;
                        Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                        Option option2 = this.c$3.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                        if (option2.isEmpty()) return None$.MODULE$;
                        Trees.ModifiersApi qq$1edb3ed2$macro$126 = (Trees.ModifiersApi)((Tuple9)option2.get())._1();
                        Names.TypeNameApi qq$1edb3ed2$macro$127 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                        List qq$1edb3ed2$macro$128 = (List)((Tuple9)option2.get())._3();
                        Trees.ModifiersApi qq$1edb3ed2$macro$129 = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                        List list = (List)((Tuple9)option2.get())._5();
                        List qq$1edb3ed2$macro$131 = (List)((Tuple9)option2.get())._6();
                        List qq$1edb3ed2$macro$132 = (List)((Tuple9)option2.get())._7();
                        Trees.ValDefApi qq$1edb3ed2$macro$133 = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                        List qq$1edb3ed2$macro$134 = (List)((Tuple9)option2.get())._9();
                        if (!(list instanceof .colon.colon)) return None$.MODULE$;
                        .colon.colon colon2 = (.colon.colon)list;
                        List qq$1edb3ed2$macro$130 = (List)colon2.head();
                        List list2 = colon2.tl$1();
                        if (!Nil$.MODULE$.equals(list2)) return None$.MODULE$;
                        return new Some((Object)new Tuple9((Object)qq$1edb3ed2$macro$126, (Object)qq$1edb3ed2$macro$127, (Object)qq$1edb3ed2$macro$128, (Object)qq$1edb3ed2$macro$129, (Object)qq$1edb3ed2$macro$130, (Object)qq$1edb3ed2$macro$131, (Object)qq$1edb3ed2$macro$132, (Object)qq$1edb3ed2$macro$133, (Object)qq$1edb3ed2$macro$134));
                    }
                    {
                        this.c$3 = c$3;
                    }
                }.unapply(clazzDef);
                if (!option.isEmpty()) {
                    Trees.ModifiersApi mods = (Trees.ModifiersApi)((Tuple9)option.get())._1();
                    Names.TypeNameApi cName = (Names.TypeNameApi)((Tuple9)option.get())._2();
                    List cfields = (List)((Tuple9)option.get())._5();
                    List parents = (List)((Tuple9)option.get())._7();
                    List body = (List)((Tuple9)option.get())._9();
                    if (BoxesRunTime.equals((Object)mods.flags(), (Object)c.universe().NoFlags())) {
                        Set set = ((TraversableOnce)parents.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Trees.TreeApi x$15) {
                                return x$15.toString();
                            }
                        }, List$.MODULE$.canBuildFrom())).toSet();
                        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.AnyRef"}));
                        if (!(set != null ? !set.equals(genTraversable) : genTraversable != null)) {
                            if (cfields.nonEmpty()) {
                                throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation, don't provide class fields ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazzDef})));
                            }
                            List<Trees.TreeApi> desc = this.getTableDescription(c, (Trees.ClassDefApi)clazzDef);
                            Option defTblDesc = desc.headOption().map((Function1)new Serializable(c){
                                public static final long serialVersionUID = 0L;
                                private final Context c$3;

                                public final Trees.DefDefApi apply(Trees.TreeApi d) {
                                    return this.c$3.universe().internal().reificationSupport().SyntacticDefDef().apply(this.c$3.universe().Modifiers().apply(this.c$3.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)this.c$3.universe().TypeName().apply(""), (List)Nil$.MODULE$), this.c$3.universe().TermName().apply("tableDescription"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(this.c$3.universe().TermName().apply("_root_"), false), this.c$3.universe().TermName().apply("java")), this.c$3.universe().TermName().apply("lang")), this.c$3.universe().TypeName().apply("String")), d);
                                }
                                {
                                    this.c$3 = c$3;
                                }
                            });
                            Seq defTblTrait = Option$.MODULE$.option2Iterable(defTblDesc.map((Function1)new Serializable(c){
                                public static final long serialVersionUID = 0L;
                                private final Context c$3;

                                public final Trees.SelectApi apply(Trees.DefDefApi x$16) {
                                    return this.c$3.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(this.c$3, MacroUtil$.MODULE$.SType()), this.c$3.universe().TypeName().apply("HasTableDescription"));
                                }
                                {
                                    this.c$3 = c$3;
                                }
                            })).toSeq();
                            Trees.DefDefApi defSchema = c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("schema"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.GModel()), c.universe().TypeName().apply("TableSchema")), c.universe().internal().reificationSupport().SyntacticApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SUtil()), c.universe().TermName().apply("parseSchema")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().Liftable().liftString().apply((Object)schema.toString())}))}))));
                            Trees.DefDefApi defToPrettyString = c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("toPrettyString"), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.ValDefApi[]{c.universe().internal().reificationSupport().SyntacticValDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(0x2002000L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("indent"), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply("Int")), (Trees.TreeApi)c.universe().Literal().apply(c.universe().Constant().apply((Object)BoxesRunTime.boxToInteger((int)0))))}))})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply("String")), c.universe().internal().reificationSupport().SyntacticApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".types.SchemaUtil"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MacroUtil$.MODULE$.SBQ()}))), c.universe().TermName().apply("toPrettyString")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().This().apply(c.universe().TypeName().apply("")), c.universe().TermName().apply("schema")), c.universe().Liftable().liftString().apply((Object)cName.toString()), c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("indent"), false)}))}))));
                            Trees.TreeApi caseClassTree = this.caseClass(c, cName, (Seq<Trees.TreeApi>)fields2, (Seq<Trees.TreeApi>)body);
                            Option maybeCompanion = tail.headOption();
                            Tuple3 tuple3 = new Tuple3((Object)c.universe().internal().reificationSupport().SyntacticBlock().apply((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{caseClassTree, this.companion(c, cName, (Seq<Trees.TreeApi>)((Seq)seq2.$plus$plus((GenTraversableOnce)defTblTrait, Seq$.MODULE$.canBuildFrom())), (Seq<Trees.TreeApi>)((Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{defSchema, defToPrettyString}))).$plus$plus(seq3, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(defTblDesc), Seq$.MODULE$.canBuildFrom())), fields2.size(), (Option<Trees.TreeApi>)maybeCompanion)})).$plus$plus((GenTraversableOnce)records2.toList(), List$.MODULE$.canBuildFrom())), (Object)caseClassTree, (Object)cName.toString());
                            Tuple3 tuple32 = tuple3;
                            if (tuple32 != null) {
                                Tuple3 tuple33;
                                Trees.TreeApi r = (Trees.TreeApi)tuple32._1();
                                Trees.TreeApi caseClassTree2 = (Trees.TreeApi)tuple32._2();
                                String name = (String)tuple32._3();
                                Tuple3 tuple34 = tuple33 = new Tuple3((Object)r, (Object)caseClassTree2, (Object)name);
                                Trees.TreeApi r2 = (Trees.TreeApi)tuple34._1();
                                Trees.TreeApi caseClassTree3 = (Trees.TreeApi)tuple34._2();
                                String name2 = (String)tuple34._3();
                                MacroUtil$.MODULE$.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TypeProvider.schemaToType[", "]:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema})));
                                MacroUtil$.MODULE$.debug(r2);
                                if (this.shouldDumpClassesForPlugin()) {
                                    this.dumpCodeForScalaPlugin(c, (Seq<Trees.TreeApi>)records2, caseClassTree3, name2);
                                }
                                return c.Expr(r2, c.universe().WeakTypeTag().Any());
                            }
                            throw new MatchError((Object)tuple32);
                        }
                        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation, don't extend the class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazzDef})));
                    }
                }
            }
            throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq4})));
        }
        throw new MatchError((Object)tuple2);
    }

    private List<String> extractStrings(Context c, String errorMessage) {
        Trees.TreeApi treeApi = c.macroApplication();
        Option option = c.universe().ApplyTag().unapply((Object)treeApi);
        if (!option.isEmpty()) {
            Trees.ApplyApi applyApi = (Trees.ApplyApi)option.get();
            Option option2 = c.universe().Apply().unapply(applyApi);
            if (!option2.isEmpty()) {
                Object object = ((Tuple2)option2.get())._1();
                Option option3 = c.universe().SelectTag().unapply(object);
                if (!option3.isEmpty()) {
                    Trees.SelectApi selectApi = (Trees.SelectApi)option3.get();
                    Option option4 = c.universe().Select().unapply(selectApi);
                    if (!option4.isEmpty()) {
                        Object object2 = ((Tuple2)option4.get())._1();
                        Option option5 = c.universe().ApplyTag().unapply(object2);
                        if (!option5.isEmpty()) {
                            List xs;
                            Trees.ApplyApi applyApi2 = (Trees.ApplyApi)option5.get();
                            Option option6 = c.universe().Apply().unapply(applyApi2);
                            if (!option6.isEmpty() && (xs = (List)((Tuple2)option6.get())._2()) instanceof List) {
                                List list = xs;
                                List args = (List)list.map((Function1)new Serializable(c, errorMessage){
                                    public static final long serialVersionUID = 0L;
                                    private final Context c$2;
                                    private final String errorMessage$1;

                                    public final String apply(Trees.TreeApi tree) {
                                        return TypeProvider$.MODULE$.com$spotify$scio$bigquery$types$TypeProvider$$str$1(tree, this.c$2, this.errorMessage$1);
                                    }
                                    {
                                        this.c$2 = c$2;
                                        this.errorMessage$1 = errorMessage$1;
                                    }
                                }, List$.MODULE$.canBuildFrom());
                                if (args.isEmpty()) {
                                    throw c.abort(c.enclosingPosition(), errorMessage);
                                }
                                List list2 = args;
                                return list2;
                            }
                        }
                    }
                }
            }
        }
        throw c.abort(c.enclosingPosition(), errorMessage);
    }

    private String formatString(List<String> xs) {
        return ((SeqLike)xs.tail()).isEmpty() ? (String)xs.head() : new StringOps(Predef$.MODULE$.augmentString((String)xs.head())).format((Seq)xs.tail());
    }

    private Trees.TreeApi caseClass(Context c, Names.TypeNameApi name, Seq<Trees.TreeApi> fields, Seq<Trees.TreeApi> body) {
        Names.TypeNameApi typeNameApi = name;
        Seq<Trees.TreeApi> seq = fields;
        Seq<Trees.TreeApi> seq2 = body;
        return c.universe().internal().reificationSupport().SyntacticClassDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2048L), (Names.NameApi)c.universe().TypeName().apply(""), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticNew().apply((List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("_root_"), false), c.universe().TermName().apply("com")), c.universe().TermName().apply("spotify")), c.universe().TermName().apply("scio")), c.universe().TermName().apply("bigquery")), c.universe().TermName().apply("types")), c.universe().TypeName().apply("BigQueryTag"))})), (Trees.TreeApi)c.universe().noSelfType(), (List)Nil$.MODULE$)}))), typeNameApi, (List)Nil$.MODULE$, c.universe().NoMods(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{seq.toList()})), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TypeName().apply("HasAnnotation")), c.universe().internal().reificationSupport().ScalaDot().apply((Names.NameApi)c.universe().TypeName().apply("Product")), c.universe().internal().reificationSupport().ScalaDot().apply((Names.NameApi)c.universe().TypeName().apply("Serializable"))})), (Trees.TreeApi)c.universe().noSelfType(), seq2.toList());
    }

    private Trees.TreeApi companion(Context c, Names.TypeNameApi name, Seq<Trees.TreeApi> traits, Seq<Trees.TreeApi> methods, int numFields, Option<Trees.TreeApi> originalCompanion) {
        Trees.ModuleDefApi moduleDefApi;
        Names.TypeNameApi typeNameApi = name;
        Seq<Trees.TreeApi> seq = traits;
        Seq<Trees.TreeApi> seq2 = methods;
        Option<Trees.TreeApi> option = originalCompanion;
        Object overrideFlag = seq.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Trees.TreeApi x$18) {
                return x$18.toString().contains("Function");
            }
        }) ? c.universe().Flag().OVERRIDE() : c.universe().NoFlags();
        Nil$ tupled = numFields > 1 && numFields <= 22 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().addFlagOps(c.universe().NoFlags()).$bar(overrideFlag), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("tupled"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticEmptyTypeTree().apply(), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().Typed().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply(typeNameApi.toString()), false), c.universe().TermName().apply("apply")), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticFunction().apply((List)Nil$.MODULE$, c.universe().EmptyTree())), c.universe().TermName().apply("tupled")))})) : Nil$.MODULE$;
        Seq m = (Seq)((TraversableLike)this.converters(c, typeNameApi).$plus$plus((GenTraversableOnce)tupled, Seq$.MODULE$.canBuildFrom())).$plus$plus(seq2, Seq$.MODULE$.canBuildFrom());
        Names.TermNameApi tn = c.universe().TermName().apply(typeNameApi.toString());
        if (option.isDefined()) {
            Tuple4 tuple4;
            Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
            Option<Tuple6<Trees.ModifiersApi, Names.TermNameApi, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> option2 = new Object(c){
                private final Context c$4;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Option<Tuple6<Trees.ModifiersApi, Names.TermNameApi, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> unapply(Object tree) {
                    Object object = tree;
                    Option option = this.c$4.universe().TreeTag().unapply(object);
                    if (option.isEmpty()) return None$.MODULE$;
                    Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                    Option option2 = this.c$4.universe().internal().reificationSupport().SyntacticObjectDef().unapply(treeApi);
                    if (option2.isEmpty()) {
                        return None$.MODULE$;
                    }
                    Trees.ModifiersApi qq$b563b94b$macro$152 = (Trees.ModifiersApi)((Tuple6)option2.get())._1();
                    Names.TermNameApi qq$b563b94b$macro$153 = (Names.TermNameApi)((Tuple6)option2.get())._2();
                    List qq$b563b94b$macro$154 = (List)((Tuple6)option2.get())._3();
                    List qq$b563b94b$macro$155 = (List)((Tuple6)option2.get())._4();
                    Trees.ValDefApi qq$b563b94b$macro$156 = (Trees.ValDefApi)((Tuple6)option2.get())._5();
                    List qq$b563b94b$macro$157 = (List)((Tuple6)option2.get())._6();
                    return new Some((Object)new Tuple6((Object)qq$b563b94b$macro$152, (Object)qq$b563b94b$macro$153, (Object)qq$b563b94b$macro$154, (Object)qq$b563b94b$macro$155, (Object)qq$b563b94b$macro$156, (Object)qq$b563b94b$macro$157));
                }
                {
                    this.c$4 = c$4;
                }
            }.unapply(treeApi);
            if (option2.isEmpty()) {
                throw new MatchError((Object)treeApi);
            }
            Trees.ModifiersApi mods = (Trees.ModifiersApi)((Tuple6)option2.get())._1();
            Names.TermNameApi cName = (Names.TermNameApi)((Tuple6)option2.get())._2();
            List parents = (List)((Tuple6)option2.get())._4();
            List body = (List)((Tuple6)option2.get())._6();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)mods, (Object)cName, (Object)parents, (Object)body);
            Trees.ModifiersApi mods2 = (Trees.ModifiersApi)tuple42._1();
            Names.TermNameApi cName2 = (Names.TermNameApi)tuple42._2();
            List parents2 = (List)tuple42._3();
            List body2 = (List)tuple42._4();
            Set filteredTraits = (Set)((TraversableOnce)seq.$plus$plus((GenTraversableOnce)parents2, Seq$.MODULE$.canBuildFrom())).toSet().filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Trees.TreeApi x$20) {
                    String string = x$20.toString();
                    String string2 = "scala.AnyRef";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            });
            moduleDefApi = c.universe().internal().reificationSupport().SyntacticObjectDef().apply(mods2, cName2, (List)Nil$.MODULE$, (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TypeName().apply("HasSchema")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})))})).$plus$plus((GenTraversableOnce)filteredTraits.toList(), List$.MODULE$.canBuildFrom()), (Trees.TreeApi)c.universe().noSelfType(), (List)body2.$plus$plus((GenTraversableOnce)m, List$.MODULE$.canBuildFrom()));
        } else {
            moduleDefApi = c.universe().internal().reificationSupport().SyntacticObjectDef().apply(c.universe().NoMods(), tn, (List)Nil$.MODULE$, (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TypeName().apply("HasSchema")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})))})).$plus$plus((GenTraversableOnce)seq.toList(), List$.MODULE$.canBuildFrom()), (Trees.TreeApi)c.universe().noSelfType(), m.toList());
        }
        return moduleDefApi;
    }

    private Seq<Trees.TreeApi> converters(Context c, Names.TypeNameApi name) {
        Names.TypeNameApi typeNameApi = name;
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("fromAvro"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, c.universe().internal().reificationSupport().SyntacticFunctionType().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("_root_"), false), c.universe().TermName().apply("org")), c.universe().TermName().apply("apache")), c.universe().TermName().apply("avro")), c.universe().TermName().apply("generic")), c.universe().TypeName().apply("GenericRecord"))})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TermName().apply("fromAvro")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})))), c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("fromTableRow"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, c.universe().internal().reificationSupport().SyntacticFunctionType().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.GModel()), c.universe().TypeName().apply("TableRow"))})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TermName().apply("fromTableRow")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})))), c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("toTableRow"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, c.universe().internal().reificationSupport().SyntacticFunctionType().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.GModel()), c.universe().TypeName().apply("TableRow"))), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.SType()), c.universe().TermName().apply("toTableRow")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)}))))}));
    }

    private void checkMacroEnclosed(Context c) {
        Symbols.SymbolApi owner = c.internal().enclosingOwner();
        if (!owner.isPackage() && owner.isClass()) {
            return;
        }
        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@BigQueryType declaration must be inside a class or object."})).s((Seq)Nil$.MODULE$));
    }

    private boolean shouldDumpClassesForPlugin() {
        return package$.MODULE$.props().apply((Object)"bigquery.plugin.disable.dump") == null || !new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().apply((Object)"bigquery.plugin.disable.dump"))).toBoolean();
    }

    private Path getBQClassCacheDir() {
        return package$.MODULE$.props().apply((Object)"bigquery.class.cache.directory") == null ? Paths.get((String)package$.MODULE$.props().apply((Object)"java.io.tmpdir"), new String[0]).resolve("bigquery-classes") : Paths.get((String)package$.MODULE$.props().apply((Object)"bigquery.class.cache.directory"), new String[0]);
    }

    private Seq<String> pShowCode(Context c, Seq<Trees.TreeApi> records, Trees.TreeApi caseClass) {
        Seq<Trees.TreeApi> seq = records;
        Trees.TreeApi treeApi = caseClass;
        return (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{treeApi}))).$plus$plus(seq, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(c){
            public static final long serialVersionUID = 0L;
            public final Context c$5;

            /*
             * Unable to fully structure code
             */
            public final String apply(Trees.TreeApi x0$2) {
                block3: {
                    block2: {
                        var2_2 = x0$2;
                        var3_3 = new Object(this){
                            private final /* synthetic */ anonfun.pShowCode.1 $outer;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> unapply(Object tree) {
                                Object object = tree;
                                Option option = this.$outer.c$5.universe().TreeTag().unapply(object);
                                if (option.isEmpty()) return None$.MODULE$;
                                Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                                Option option2 = this.$outer.c$5.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                                if (option2.isEmpty()) return None$.MODULE$;
                                Trees.ModifiersApi qq$07fba1f8$macro$180 = (Trees.ModifiersApi)((Tuple9)option2.get())._1();
                                Names.TypeNameApi qq$07fba1f8$macro$181 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                                List qq$07fba1f8$macro$182 = (List)((Tuple9)option2.get())._3();
                                Trees.ModifiersApi qq$07fba1f8$macro$183 = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                                List list = (List)((Tuple9)option2.get())._5();
                                List qq$07fba1f8$macro$185 = (List)((Tuple9)option2.get())._6();
                                List qq$07fba1f8$macro$186 = (List)((Tuple9)option2.get())._7();
                                Trees.ValDefApi qq$07fba1f8$macro$187 = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                                List qq$07fba1f8$macro$188 = (List)((Tuple9)option2.get())._9();
                                if (!(list instanceof .colon.colon)) return None$.MODULE$;
                                .colon.colon colon2 = (.colon.colon)list;
                                List qq$07fba1f8$macro$184 = (List)colon2.head();
                                List list2 = colon2.tl$1();
                                if (!Nil$.MODULE$.equals(list2)) return None$.MODULE$;
                                return new Some((Object)new Tuple9((Object)qq$07fba1f8$macro$180, (Object)qq$07fba1f8$macro$181, (Object)qq$07fba1f8$macro$182, (Object)qq$07fba1f8$macro$183, (Object)qq$07fba1f8$macro$184, (Object)qq$07fba1f8$macro$185, (Object)qq$07fba1f8$macro$186, (Object)qq$07fba1f8$macro$187, (Object)qq$07fba1f8$macro$188));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }.unapply(var2_2);
                        if (var3_3.isEmpty()) ** GOTO lbl33
                        mods = (Trees.ModifiersApi)((Tuple9)var3_3.get())._1();
                        name = (Names.TypeNameApi)((Tuple9)var3_3.get())._2();
                        fields = (List)((Tuple9)var3_3.get())._5();
                        parents = (List)((Tuple9)var3_3.get())._7();
                        if (!mods.hasFlag(this.c$5.universe().Flag().CASE())) ** GOTO lbl33
                        f = ((TraversableOnce)fields.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.pShowCode.1 $outer;

                            public final String apply(Trees.ValDefApi x0$3) {
                                Option option;
                                block3: {
                                    Trees.ValDefApi valDefApi;
                                    block2: {
                                        valDefApi = x0$3;
                                        Option option2 = this.$outer.c$5.universe().ValDefTag().unapply((Object)valDefApi);
                                        if (option2.isEmpty()) break block2;
                                        Trees.ValDefApi valDefApi2 = (Trees.ValDefApi)option2.get();
                                        option = this.$outer.c$5.universe().ValDef().unapply(valDefApi2);
                                        if (!option.isEmpty()) break block3;
                                    }
                                    throw new MatchError((Object)valDefApi);
                                }
                                Names.TermNameApi fname = (Names.TermNameApi)((Tuple4)option.get())._2();
                                Trees.TreeApi ftpt = (Trees.TreeApi)((Tuple4)option.get())._3();
                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaUtil$.MODULE$.escapeNameIfReserved(fname.toString()), ftpt}));
                                return string;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, List$.MODULE$.canBuildFrom())).mkString(", ").replaceAll(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BigQueryTag.class.getName()})), "");
                        var10_9 = false;
                        var11_10 = null;
                        var12_11 = parents;
                        if (!Nil$.MODULE$.equals(var12_11)) break block2;
                        var13_12 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"case class ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, f}));
                        ** GOTO lbl30
                    }
                    if (!(var12_11 instanceof .colon.colon)) break block3;
                    var10_9 = true;
                    var11_10 = (.colon.colon)var12_11;
                    h = (Trees.TreeApi)var11_10.head();
                    var15_14 = var11_10.tl$1();
                    if (!Nil$.MODULE$.equals(var15_14)) break block3;
                    var13_12 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"case class ", "(", ") extends ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, f, h}));
                    ** GOTO lbl30
                }
                if (var10_9) {
                    h = (Trees.TreeApi)var11_10.head();
                    t = var11_10.tl$1();
                    var13_12 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"case class ", "(", ") extends ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, f, h, t.mkString(" with ", " with ", "")}));
lbl30:
                    // 3 sources

                    var8_17 = var13_12;
                } else {
                    throw new MatchError((Object)var12_11);
lbl33:
                    // 2 sources

                    var8_17 = "";
                }
                return var8_17;
            }
            {
                this.c$5 = c$5;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String genHashForMacro(String owner, String srcFile) {
        return Hashing.murmur3_32().newHasher().putString((CharSequence)owner, Charsets.UTF_8).putString((CharSequence)srcFile, Charsets.UTF_8).hash().toString();
    }

    private void dumpCodeForScalaPlugin(Context c, Seq<Trees.TreeApi> records, Trees.TreeApi caseClassTree, String name) {
        Seq<Trees.TreeApi> seq = records;
        Trees.TreeApi treeApi = caseClassTree;
        String owner = c.internal().enclosingOwner().fullName();
        String srcFile = c.macroApplication().pos().source().file().canonicalPath();
        String hash = this.genHashForMacro(owner, srcFile);
        String prettyCode = this.pShowCode(c, seq, treeApi).mkString("\n");
        Path classCacheDir = this.getBQClassCacheDir();
        File genSrcFile = classCacheDir.resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, hash}))).toFile();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will dump generated ", " of ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, owner, srcFile, genSrcFile})));
        Files.createParentDirs((File)genSrcFile);
        Files.write((CharSequence)prettyCode, (File)genSrcFile, (Charset)Charsets.UTF_8);
    }

    private final Tuple2 getRawType$1(TableFieldSchema tfs, Context c$3, OverrideTypeProvider provider$2) {
        String string;
        block13: {
            Tuple2 tuple2;
            block14: {
                Tuple2 tuple22;
                block3: {
                    Tuple2 tuple23;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            string = tfs.getType();
                                                            if (!provider$2.shouldOverrideType(tfs)) break block2;
                                                            tuple22 = new Tuple2((Object)provider$2.getScalaType(c$3, tfs), (Object)Nil$.MODULE$);
                                                            break block3;
                                                        }
                                                        boolean bl = "BOOLEAN".equals(string) ? true : "BOOL".equals(string);
                                                        if (!bl) break block4;
                                                        tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Boolean")), (Object)Nil$.MODULE$);
                                                        break block3;
                                                    }
                                                    boolean bl = "INTEGER".equals(string) ? true : "INT64".equals(string);
                                                    if (!bl) break block5;
                                                    tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Long")), (Object)Nil$.MODULE$);
                                                    break block3;
                                                }
                                                boolean bl = "FLOAT".equals(string) ? true : "FLOAT64".equals(string);
                                                if (!bl) break block6;
                                                tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Double")), (Object)Nil$.MODULE$);
                                                break block3;
                                            }
                                            if (!"STRING".equals(string)) break block7;
                                            tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("java")), c$3.universe().TermName().apply("lang")), c$3.universe().TypeName().apply("String")), (Object)Nil$.MODULE$);
                                            break block3;
                                        }
                                        if (!"BYTES".equals(string)) break block8;
                                        tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("com")), c$3.universe().TermName().apply("google")), c$3.universe().TermName().apply("protobuf")), c$3.universe().TypeName().apply("ByteString")), (Object)Nil$.MODULE$);
                                        break block3;
                                    }
                                    if (!"TIMESTAMP".equals(string)) break block9;
                                    tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("org")), c$3.universe().TermName().apply("joda")), c$3.universe().TermName().apply("time")), c$3.universe().TypeName().apply("Instant")), (Object)Nil$.MODULE$);
                                    break block3;
                                }
                                if (!"DATE".equals(string)) break block10;
                                tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("org")), c$3.universe().TermName().apply("joda")), c$3.universe().TermName().apply("time")), c$3.universe().TypeName().apply("LocalDate")), (Object)Nil$.MODULE$);
                                break block3;
                            }
                            if (!"TIME".equals(string)) break block11;
                            tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("org")), c$3.universe().TermName().apply("joda")), c$3.universe().TermName().apply("time")), c$3.universe().TypeName().apply("LocalTime")), (Object)Nil$.MODULE$);
                            break block3;
                        }
                        if (!"DATETIME".equals(string)) break block12;
                        tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("org")), c$3.universe().TermName().apply("joda")), c$3.universe().TermName().apply("time")), c$3.universe().TypeName().apply("LocalDateTime")), (Object)Nil$.MODULE$);
                        break block3;
                    }
                    boolean bl = "RECORD".equals(string) ? true : "STRUCT".equals(string);
                    if (!bl) break block13;
                    String name = NameProvider$.MODULE$.getUniqueName(tfs.getName());
                    tuple2 = this.toFields$1(tfs.getFields(), c$3, provider$2);
                    if (tuple2 == null) break block14;
                    Seq fields = (Seq)tuple2._1();
                    Seq records = (Seq)tuple2._2();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)fields, (Object)records);
                    Seq fields2 = (Seq)tuple24._1();
                    Seq records2 = (Seq)tuple24._2();
                    tuple22 = new Tuple2((Object)c$3.universe().Ident().apply((Names.NameApi)c$3.universe().TypeName().apply(name)), ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.ClassDefApi[]{c$3.universe().internal().reificationSupport().SyntacticClassDef().apply(c$3.universe().Modifiers().apply(c$3.universe().internal().reificationSupport().FlagsRepr().apply(2048L), (Names.NameApi)c$3.universe().TypeName().apply(""), (List)Nil$.MODULE$), c$3.universe().TypeName().apply(name), (List)Nil$.MODULE$, c$3.universe().NoMods(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{fields2.toList()})), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c$3.universe().internal().reificationSupport().ScalaDot().apply((Names.NameApi)c$3.universe().TypeName().apply("Product")), c$3.universe().internal().reificationSupport().ScalaDot().apply((Names.NameApi)c$3.universe().TypeName().apply("Serializable"))})), (Trees.TreeApi)c$3.universe().noSelfType(), (List)Nil$.MODULE$)}))).$plus$plus((GenTraversableOnce)records2, Seq$.MODULE$.canBuildFrom()));
                }
                return tuple22;
            }
            throw new MatchError((Object)tuple2);
        }
        throw c$3.abort(c$3.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type: ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private final Tuple2 getFieldType$1(TableFieldSchema tfs, Context c$3, OverrideTypeProvider provider$2) {
        Tuple2 tuple2;
        block2: {
            String string;
            block6: {
                Trees.TreeApi treeApi;
                Seq r;
                block4: {
                    Trees.TreeApi t;
                    block5: {
                        block3: {
                            Tuple2 tuple22;
                            tuple2 = this.getRawType$1(tfs, c$3, provider$2);
                            if (tuple2 == null) break block2;
                            Trees.TreeApi t2 = (Trees.TreeApi)tuple2._1();
                            Seq r2 = (Seq)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)t2, (Object)r2);
                            t = (Trees.TreeApi)tuple23._1();
                            r = (Seq)tuple23._2();
                            string = tfs.getMode();
                            boolean bl = "NULLABLE".equals(string) ? true : string == null;
                            if (!bl) break block3;
                            treeApi = c$3.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Option")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{t})));
                            break block4;
                        }
                        if (!"REQUIRED".equals(string)) break block5;
                        treeApi = t;
                        break block4;
                    }
                    if (!"REPEATED".equals(string)) break block6;
                    treeApi = c$3.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("List")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{t})));
                }
                Trees.TreeApi ft = treeApi;
                return new Tuple2((Object)ft, (Object)r);
            }
            throw c$3.abort(c$3.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mode: ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
        }
        throw new MatchError((Object)tuple2);
    }

    public final Tuple2 com$spotify$scio$bigquery$types$TypeProvider$$toField$1(TableFieldSchema tfs, Context c$3, OverrideTypeProvider provider$2) {
        Tuple2 tuple2 = this.getFieldType$1(tfs, c$3, provider$2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Trees.TreeApi ft = (Trees.TreeApi)tuple2._1();
            Seq r = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)ft, (Object)r);
            Trees.TreeApi ft2 = (Trees.TreeApi)tuple23._1();
            Seq r2 = (Seq)tuple23._2();
            Trees.TreeApi[] treeApiArray = new Trees.TreeApi[1];
            scala.reflect.macros.Universe $u = c$3.universe();
            Mirror $m = c$3.universe().rootMirror();
            public final class Com_spotify_scio_bigquery_types_TypeProvider$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("com.spotify.scio.bigquery.types.BigQueryTag").asType().toTypeConstructor();
                }

                public Com_spotify_scio_bigquery_types_TypeProvider$$typecreator2$1() {
                }
            }
            treeApiArray[0] = c$3.universe().Liftable().liftType().apply((Object)c$3.universe().typeOf($u.TypeTag().apply($m, (TypeCreator)new Com_spotify_scio_bigquery_types_TypeProvider$$typecreator2$1())));
            Trees.ValDefApi params = c$3.universe().internal().reificationSupport().SyntacticValDef().apply(c$3.universe().Modifiers().apply(c$3.universe().internal().reificationSupport().FlagsRepr().apply(16L), (Names.NameApi)c$3.universe().TypeName().apply(""), (List)Nil$.MODULE$), c$3.universe().TermName().apply(tfs.getName()), (Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticAnnotatedType().apply(ft2, c$3.universe().internal().reificationSupport().SyntacticNew().apply((List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])treeApiArray)), (Trees.TreeApi)c$3.universe().noSelfType(), (List)Nil$.MODULE$)), c$3.universe().EmptyTree());
            return new Tuple2((Object)params, (Object)r2);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Tuple2 toFields$1(java.util.List fields, Context c$3, OverrideTypeProvider provider$2) {
        Buffer f = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(c$3, provider$2){
            public static final long serialVersionUID = 0L;
            private final Context c$3;
            private final OverrideTypeProvider provider$2;

            public final Tuple2<Trees.TreeApi, Seq<Trees.TreeApi>> apply(TableFieldSchema s) {
                return TypeProvider$.MODULE$.com$spotify$scio$bigquery$types$TypeProvider$$toField$1(s, this.c$3, this.provider$2);
            }
            {
                this.c$3 = c$3;
                this.provider$2 = provider$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new Tuple2(f.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Tuple2<Trees.TreeApi, Seq<Trees.TreeApi>> x$11) {
                return (Trees.TreeApi)x$11._1();
            }
        }, Buffer$.MODULE$.canBuildFrom()), f.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Trees.TreeApi> apply(Tuple2<Trees.TreeApi, Seq<Trees.TreeApi>> x$12) {
                return (Seq)x$12._2();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public final String com$spotify$scio$bigquery$types$TypeProvider$$str$1(Trees.TreeApi tree, Context c$2, String errorMessage$1) {
        block4: {
            String string;
            block3: {
                String string2;
                Object s;
                Option option;
                Trees.TreeApi treeApi;
                block2: {
                    String string3;
                    Object s2;
                    treeApi = tree;
                    Option option2 = c$2.universe().LiteralTag().unapply((Object)treeApi);
                    if (option2.isEmpty()) break block2;
                    Trees.LiteralApi literalApi = (Trees.LiteralApi)option2.get();
                    Option option3 = c$2.universe().Literal().unapply(literalApi);
                    if (option3.isEmpty()) break block2;
                    Object object = option3.get();
                    Option option4 = c$2.universe().ConstantTag().unapply(object);
                    if (option4.isEmpty()) break block2;
                    Constants.ConstantApi constantApi = (Constants.ConstantApi)option4.get();
                    Option option5 = c$2.universe().Constant().unapply(constantApi);
                    if (option5.isEmpty() || !((s2 = option5.get()) instanceof String)) break block2;
                    string = string3 = (String)s2;
                    break block3;
                }
                if ((option = c$2.universe().SelectTag().unapply((Object)treeApi)).isEmpty()) break block4;
                Trees.SelectApi selectApi = (Trees.SelectApi)option.get();
                Option option6 = c$2.universe().Select().unapply(selectApi);
                if (option6.isEmpty()) break block4;
                Object object = ((Tuple2)option6.get())._1();
                Object object2 = ((Tuple2)option6.get())._2();
                Option option7 = c$2.universe().LiteralTag().unapply(object);
                if (option7.isEmpty()) break block4;
                Trees.LiteralApi literalApi = (Trees.LiteralApi)option7.get();
                Option option8 = c$2.universe().Literal().unapply(literalApi);
                if (option8.isEmpty()) break block4;
                Object object3 = option8.get();
                Option option9 = c$2.universe().ConstantTag().unapply(object3);
                if (option9.isEmpty()) break block4;
                Constants.ConstantApi constantApi = (Constants.ConstantApi)option9.get();
                Option option10 = c$2.universe().Constant().unapply(constantApi);
                if (option10.isEmpty() || !((s = option10.get()) instanceof String)) break block4;
                String string4 = (String)s;
                Option option11 = c$2.universe().TermNameTag().unapply(object2);
                if (option11.isEmpty()) break block4;
                Names.TermNameApi termNameApi = (Names.TermNameApi)option11.get();
                Option option12 = c$2.universe().TermName().unapply(termNameApi);
                if (option12.isEmpty() || !"stripMargin".equals(string2 = (String)option12.get())) break block4;
                string = new StringOps(Predef$.MODULE$.augmentString(string4)).stripMargin();
            }
            return string;
        }
        throw c$2.abort(c$2.enclosingPosition(), errorMessage$1);
    }

    private TypeProvider$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.bitmap$init$0 = true;
    }
}

