/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FluentBackoff;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchedBigQueryTableRowIterator
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PatchedBigQueryTableRowIterator.class);
    @Nullable
    private TableReference ref;
    @Nullable
    private final String projectId;
    @Nullable
    private TableSchema schema;
    @Nullable
    private JobConfigurationQuery queryConfig;
    private final Bigquery client;
    private String pageToken;
    private Iterator<TableRow> iteratorOverCurrentBatch;
    private TableRow current;
    private boolean lastPage = false;
    private static final int MAX_RETRIES = 3;
    private static final Duration INITIAL_BACKOFF_TIME = Duration.standardSeconds((long)1L);
    private static final Duration QUERY_COMPLETION_POLL_TIME = Duration.standardSeconds((long)1L);
    private String temporaryDatasetId = null;
    private String temporaryTableId = null;
    private static final Collection<String> RESERVED_FIELD_NAMES = ClassInfo.of(TableRow.class).getNames();

    private PatchedBigQueryTableRowIterator(@Nullable TableReference tableReference, @Nullable JobConfigurationQuery jobConfigurationQuery, @Nullable String string, Bigquery bigquery) {
        this.ref = tableReference;
        this.queryConfig = jobConfigurationQuery;
        this.projectId = string;
        this.client = (Bigquery)Preconditions.checkNotNull((Object)bigquery, (Object)"client");
    }

    public static PatchedBigQueryTableRowIterator fromTable(TableReference tableReference, Bigquery bigquery) {
        Preconditions.checkNotNull((Object)tableReference, (Object)"ref");
        Preconditions.checkNotNull((Object)bigquery, (Object)"client");
        return new PatchedBigQueryTableRowIterator(tableReference, null, tableReference.getProjectId(), bigquery);
    }

    static PatchedBigQueryTableRowIterator fromQuery(JobConfigurationQuery jobConfigurationQuery, String string, Bigquery bigquery) {
        Preconditions.checkNotNull((Object)jobConfigurationQuery, (Object)"queryConfig");
        Preconditions.checkNotNull((Object)string, (Object)"projectId");
        Preconditions.checkNotNull((Object)bigquery, (Object)"client");
        return new PatchedBigQueryTableRowIterator(null, jobConfigurationQuery, string, bigquery);
    }

    public void open() throws IOException, InterruptedException {
        if (this.queryConfig != null) {
            this.ref = this.executeQueryAndWaitForCompletion();
        }
        this.schema = this.getTable(this.ref).getSchema();
    }

    public boolean advance() throws IOException, InterruptedException {
        while (true) {
            if (this.iteratorOverCurrentBatch != null && this.iteratorOverCurrentBatch.hasNext()) {
                this.current = this.getTypedTableRow(this.schema.getFields(), (Map)this.iteratorOverCurrentBatch.next());
                return true;
            }
            if (this.lastPage) {
                return false;
            }
            Bigquery.Tabledata.List list = this.client.tabledata().list(this.ref.getProjectId(), this.ref.getDatasetId(), this.ref.getTableId());
            if (this.pageToken != null) {
                list.setPageToken(this.pageToken);
            }
            TableDataList tableDataList = (TableDataList)PatchedBigQueryTableRowIterator.executeWithBackOff(list, String.format("Error reading from BigQuery table %s of dataset %s.", this.ref.getTableId(), this.ref.getDatasetId()));
            this.pageToken = tableDataList.getPageToken();
            Iterator<Object> iterator = this.iteratorOverCurrentBatch = tableDataList.getRows() != null ? tableDataList.getRows().iterator() : Collections.emptyIterator();
            if (this.pageToken != null && (tableDataList.getTotalRows() == null || tableDataList.getTotalRows() != 0L)) continue;
            this.lastPage = true;
        }
    }

    public TableRow getCurrent() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    @Nullable
    private Object getTypedCellValue(TableFieldSchema tableFieldSchema, Object object) {
        if (Data.isNull((Object)object)) {
            return null;
        }
        if (Objects.equals(tableFieldSchema.getMode(), "REPEATED")) {
            TableFieldSchema tableFieldSchema2 = tableFieldSchema.clone().setMode("REQUIRED");
            List list = (List)object;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map map : list) {
                builder.add(this.getTypedCellValue(tableFieldSchema2, map.get("v")));
            }
            return builder.build();
        }
        if (tableFieldSchema.getType().equals("RECORD")) {
            Map map = (Map)object;
            return this.getTypedTableRow(tableFieldSchema.getFields(), map);
        }
        if (tableFieldSchema.getType().equals("FLOAT")) {
            return Double.parseDouble((String)object);
        }
        if (tableFieldSchema.getType().equals("BOOLEAN")) {
            return Boolean.parseBoolean((String)object);
        }
        if (tableFieldSchema.getType().equals("TIMESTAMP")) {
            return BigQueryAvroUtils.formatTimestamp((String)((String)object));
        }
        return object;
    }

    private TableRow getTypedTableRow(List<TableFieldSchema> list, Map<String, Object> map) {
        Object object;
        List list2;
        TableRow tableRow;
        if (map instanceof TableRow) {
            tableRow = (TableRow)map;
            list2 = tableRow.getF();
            tableRow.setF(null);
        } else {
            tableRow = new TableRow();
            object = (List)map.get("f");
            list2 = object;
        }
        Preconditions.checkState((list2.size() == list.size() ? 1 : 0) != 0, (String)"Expected that the row has the same number of cells %s as fields in the schema %s", (int)list2.size(), (int)list.size());
        object = list2.iterator();
        Iterator<TableFieldSchema> iterator = list.iterator();
        while (object.hasNext()) {
            Map map2 = (Map)object.next();
            TableFieldSchema tableFieldSchema = iterator.next();
            Object object2 = this.getTypedCellValue(tableFieldSchema, map2.get("v"));
            String string = tableFieldSchema.getName();
            Preconditions.checkArgument((!RESERVED_FIELD_NAMES.contains(string) ? 1 : 0) != 0, (String)"BigQueryIO does not support records with columns named %s", (Object)string);
            if (object2 == null) continue;
            tableRow.set(string, object2);
        }
        return tableRow;
    }

    private Table getTable(TableReference tableReference) throws IOException, InterruptedException {
        Bigquery.Tables.Get get = this.client.tables().get(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
        return (Table)PatchedBigQueryTableRowIterator.executeWithBackOff(get, String.format("Error opening BigQuery table %s of dataset %s.", tableReference.getTableId(), tableReference.getDatasetId()));
    }

    private void createDataset(String string, @Nullable String string2) throws IOException, InterruptedException {
        Dataset dataset = new Dataset();
        DatasetReference datasetReference = new DatasetReference();
        datasetReference.setProjectId(this.projectId);
        datasetReference.setDatasetId(string);
        dataset.setDatasetReference(datasetReference);
        if (string2 != null) {
            dataset.setLocation(string2);
        }
        PatchedBigQueryTableRowIterator.executeWithBackOff(this.client.datasets().insert(this.projectId, dataset), String.format("Error when trying to create the temporary dataset %s in project %s.", string, this.projectId));
    }

    private void deleteTable(String string, String string2) throws IOException, InterruptedException {
        PatchedBigQueryTableRowIterator.executeWithBackOff(this.client.tables().delete(this.projectId, string, string2), String.format("Error when trying to delete the temporary table %s in dataset %s of project %s. Manual deletion may be required.", string2, string, this.projectId));
    }

    private void deleteDataset(String string) throws IOException, InterruptedException {
        PatchedBigQueryTableRowIterator.executeWithBackOff(this.client.datasets().delete(this.projectId, string), String.format("Error when trying to delete the temporary dataset %s in project %s. Manual deletion may be required.", string, this.projectId));
    }

    private TableReference executeQueryAndWaitForCompletion() throws IOException, InterruptedException {
        Random random;
        Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Unable to execute a query without a configured project id");
        Preconditions.checkState((this.queryConfig != null ? 1 : 0) != 0, (Object)"Unable to execute a query without a configured query");
        Job job = new Job().setConfiguration(new JobConfiguration().setQuery(this.queryConfig).setDryRun(Boolean.valueOf(true)));
        JobStatistics jobStatistics = ((Job)PatchedBigQueryTableRowIterator.executeWithBackOff(this.client.jobs().insert(this.projectId, job), String.format("Error when trying to dry run query %s.", this.queryConfig.toPrettyString()))).getStatistics();
        String string = null;
        List list = jobStatistics.getQuery().getReferencedTables();
        if (list != null && !list.isEmpty()) {
            random = this.getTable((TableReference)list.get(0));
            string = random.getLocation();
        }
        random = new Random(System.currentTimeMillis());
        this.temporaryDatasetId = "_beam_temporary_dataset_" + random.nextInt(1000000);
        this.temporaryTableId = "beam_temporary_table_" + random.nextInt(1000000);
        this.createDataset(this.temporaryDatasetId, string);
        Job job2 = new Job();
        JobConfiguration jobConfiguration = new JobConfiguration();
        jobConfiguration.setQuery(this.queryConfig);
        job2.setConfiguration(jobConfiguration);
        TableReference tableReference = new TableReference();
        tableReference.setProjectId(this.projectId);
        tableReference.setDatasetId(this.temporaryDatasetId);
        tableReference.setTableId(this.temporaryTableId);
        this.queryConfig.setDestinationTable(tableReference);
        this.queryConfig.setAllowLargeResults(Boolean.valueOf(true));
        Job job3 = (Job)PatchedBigQueryTableRowIterator.executeWithBackOff(this.client.jobs().insert(this.projectId, job2), String.format("Error when trying to execute the job for query %s.", this.queryConfig.toPrettyString()));
        JobReference jobReference = job3.getJobReference();
        while (true) {
            Job job4;
            JobStatus jobStatus;
            if ((jobStatus = (job4 = (Job)PatchedBigQueryTableRowIterator.executeWithBackOff(this.client.jobs().get(this.projectId, jobReference.getJobId()), String.format("Error when trying to get status of the job for query %s.", this.queryConfig.toPrettyString()))).getStatus()).getState().equals("DONE")) {
                ErrorProto errorProto = jobStatus.getErrorResult();
                if (errorProto == null) {
                    return job4.getConfiguration().getQuery().getDestinationTable();
                }
                this.temporaryTableId = null;
                throw new IOException(String.format("Executing query %s failed: %s", this.queryConfig.toPrettyString(), errorProto.getMessage()));
            }
            Uninterruptibles.sleepUninterruptibly((long)QUERY_COMPLETION_POLL_TIME.getMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public static <T> T executeWithBackOff(AbstractGoogleClientRequest<T> abstractGoogleClientRequest, String string) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backOff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(INITIAL_BACKOFF_TIME).backoff());
        Object object = null;
        while (true) {
            try {
                object = abstractGoogleClientRequest.execute();
            }
            catch (IOException iOException) {
                LOG.error("{}", (Object)string, (Object)iOException);
                if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff)) continue;
                String string2 = String.format("%s Failing to execute job after %d attempts.", string, 4);
                LOG.error("{}", (Object)string2, (Object)iOException);
                throw new IOException(string2, iOException);
            }
            break;
        }
        return (T)object;
    }

    @Override
    public void close() {
        this.lastPage = true;
        try {
            if (this.temporaryDatasetId != null) {
                if (this.temporaryTableId != null) {
                    this.deleteTable(this.temporaryDatasetId, this.temporaryTableId);
                }
                this.deleteDataset(this.temporaryDatasetId);
            }
        }
        catch (IOException | InterruptedException exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(exception);
        }
    }
}

