/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.auth.Credentials;
import com.spotify.scio.ScioContext;
import com.spotify.scio.bigquery.Reads$;
import com.spotify.scio.bigquery.StorageUtil$;
import com.spotify.scio.bigquery.Table;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.BigQuery$;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.QueryJob;
import com.spotify.scio.bigquery.package$;
import com.spotify.scio.bigquery.types.BigQueryType;
import com.spotify.scio.coders.Coder$;
import com.spotify.scio.coders.CoderMaterializer$;
import com.spotify.scio.values.SCollection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.util.Try;

public final class Reads$ {
    public static final Reads$ MODULE$;
    public final ConcurrentHashMap<ScioContext, BigQuery> com$spotify$scio$bigquery$Reads$$cache;

    static {
        new Reads$();
    }

    private BigQuery client(ScioContext sc) {
        return this.com$spotify$scio$bigquery$Reads$$cache.computeIfAbsent(sc, new Function<ScioContext, BigQuery>(){

            public BigQuery apply(ScioContext context) {
                GcpOptions opts = (GcpOptions)context.optionsAs(ClassTag$.MODULE$.apply(GcpOptions.class));
                return BigQuery$.MODULE$.apply(opts.getProject(), (Function0<Credentials>)new Serializable(this, opts){
                    public static final long serialVersionUID = 0L;
                    private final GcpOptions opts$1;

                    public final Credentials apply() {
                        return this.opts$1.getGcpCredential();
                    }
                    {
                        this.opts$1 = opts$1;
                    }
                });
            }
        });
    }

    public <T> SCollection<T> bqReadQuery(ScioContext sc, BigQueryIO.TypedRead<T> typedRead, String sqlQuery, boolean flattenResults, ClassTag<T> evidence$1) {
        PCollection pCollection;
        BigQuery bigQueryClient = this.client(sc);
        if (bigQueryClient.isCacheEnabled()) {
            Try read2 = bigQueryClient.query().newQueryJob(sqlQuery, flattenResults).map((Function1)new Serializable(sc, typedRead, bigQueryClient){
                public static final long serialVersionUID = 0L;
                private final ScioContext sc$1;
                private final BigQueryIO.TypedRead typedRead$1;
                public final BigQuery bigQueryClient$1;

                public final BigQueryIO.TypedRead<T> apply(QueryJob job) {
                    this.sc$1.onClose((Function1)new Serializable(this, job){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;
                        private final QueryJob job$1;

                        public final void apply(BoxedUnit x$1) {
                            this.$outer.bigQueryClient$1.waitForJobs((Seq<BigQueryJob>)Predef$.MODULE$.wrapRefArray((Object[])new BigQueryJob[]{this.job$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.job$1 = job$1;
                        }
                    });
                    return this.typedRead$1.from(job.table()).withoutValidation();
                }
                {
                    this.sc$1 = sc$1;
                    this.typedRead$1 = typedRead$1;
                    this.bigQueryClient$1 = bigQueryClient$1;
                }
            });
            pCollection = (PCollection)sc.applyInternal((PTransform)read2.get());
        } else {
            BigQueryIO.TypedRead baseQuery = flattenResults ? typedRead.fromQuery(sqlQuery) : typedRead.fromQuery(sqlQuery).withoutResultFlattening();
            BigQueryIO.TypedRead query2 = bigQueryClient.query().isLegacySql(sqlQuery, flattenResults) ? baseQuery : baseQuery.usingStandardSql();
            pCollection = (PCollection)sc.applyInternal((PTransform)query2);
        }
        return sc.wrap(pCollection);
    }

    public <T> boolean bqReadQuery$default$4(ScioContext sc) {
        return false;
    }

    public <T> SCollection<T> bqReadStorage(ScioContext sc, BigQueryIO.TypedRead<T> typedRead, Table table2, List<String> selectedFields2, String rowRestriction2, ClassTag<T> evidence$2) {
        BigQueryIO.TypedRead read2 = typedRead.from(table2.spec()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withReadOptions(StorageUtil$.MODULE$.tableReadOptions(selectedFields2, rowRestriction2));
        return sc.wrap((PCollection)sc.applyInternal((PTransform)read2));
    }

    public <T> List<String> bqReadStorage$default$4(ScioContext sc) {
        return Nil$.MODULE$;
    }

    public <T> String bqReadStorage$default$5(ScioContext sc) {
        return null;
    }

    public <T extends BigQueryType.HasAnnotation> BigQueryIO.TypedRead<T> avroBigQueryRead(ScioContext sc, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        Function1<GenericRecord, T> fn = package$.MODULE$.BigQueryType().apply(evidence$4).fromAvro();
        return BigQueryIO.read((SerializableFunction)new SerializableFunction<SchemaAndRecord, T>(fn){
            private final Function1 fn$1;

            public T apply(SchemaAndRecord input) {
                return (T)((BigQueryType.HasAnnotation)this.fn$1.apply((Object)input.getRecord()));
            }
            {
                this.fn$1 = fn$1;
            }
        }).withCoder(CoderMaterializer$.MODULE$.beam(sc, Coder$.MODULE$.kryo(evidence$3)));
    }

    public <T> SCollection<T> bqReadTable(ScioContext sc, BigQueryIO.TypedRead<T> typedRead, TableReference table2, ClassTag<T> evidence$5) {
        return sc.wrap((PCollection)sc.applyInternal((PTransform)typedRead.from(table2)));
    }

    private Reads$() {
        MODULE$ = this;
        this.com$spotify$scio$bigquery$Reads$$cache = new ConcurrentHashMap();
    }
}

