/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.spotify.scio.bigquery.BigQueryUtil$;
import com.spotify.scio.bigquery.client.AvroCompression$;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.CompressionT;
import com.spotify.scio.bigquery.client.CsvCompression$;
import com.spotify.scio.bigquery.client.ExtractJob;
import com.spotify.scio.bigquery.client.ExtractOps$;
import com.spotify.scio.bigquery.client.JobOps;
import com.spotify.scio.bigquery.client.JsonCompression$;
import com.spotify.scio.bigquery.client.NoCompressionT;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=tAB\u0001\u0003\u0011\u0003\u0011A\"\u0001\u0006FqR\u0014\u0018m\u0019;PaNT!a\u0001\u0003\u0002\r\rd\u0017.\u001a8u\u0015\t)a!\u0001\u0005cS\u001e\fX/\u001a:z\u0015\t9\u0001\"\u0001\u0003tG&|'BA\u0005\u000b\u0003\u001d\u0019\bo\u001c;jMfT\u0011aC\u0001\u0004G>l\u0007CA\u0007\u000f\u001b\u0005\u0011aAB\b\u0003\u0011\u0003\u0011\u0001C\u0001\u0006FqR\u0014\u0018m\u0019;PaN\u001c\"AD\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0011\u0015Ab\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0007\t\u000fqq!\u0019!C\u0005;\u00051Aj\\4hKJ,\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nQa\u001d7gi)T\u0011aI\u0001\u0004_J<\u0017BA\u0013!\u0005\u0019aunZ4fe\"1qE\u0004Q\u0001\ny\tq\u0001T8hO\u0016\u0014\bEB\u0003\u0010\u0005\t\u0011\u0011f\u0005\u0002)#!A1\u0001\u000bB\u0001B\u0003%1\u0006\u0005\u0002-y9\u0011QF\u000f\b\u0003]er!a\f\u001d\u000f\u0005A:dBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!\u0014$\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011BA\u001e\u0003\u0003!\u0011\u0015nZ)vKJL\u0018BA\u001f?\u0005\u0019\u0019E.[3oi*\u00111H\u0001\u0005\t\u0001\"\u0012\t\u0011)A\u0005\u0003\u0006Q!n\u001c2TKJ4\u0018nY3\u0011\u00055\u0011\u0015BA\"\u0003\u0005\u0019QuNY(qg\")\u0001\u0004\u000bC\u0001\u000bR\u0019ai\u0012%\u0011\u00055A\u0003\"B\u0002E\u0001\u0004Y\u0003\"\u0002!E\u0001\u0004\t\u0005\"\u0002&)\t\u0003Y\u0015!B1t\u0007N4HC\u0002'P1\u000el'\u000f\u0005\u0002\u0013\u001b&\u0011aj\u0005\u0002\u0005+:LG\u000fC\u0003Q\u0013\u0002\u0007\u0011+A\u0006t_V\u00148-\u001a+bE2,\u0007C\u0001*V\u001d\t\u00112+\u0003\u0002U'\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!6\u0003C\u0003Z\u0013\u0002\u0007!,A\beKN$\u0018N\\1uS>tWK]5t!\rY\u0006-\u0015\b\u00039zs!AM/\n\u0003QI!aX\n\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\u0005\u0019&\u001cHO\u0003\u0002`'!9A-\u0013I\u0001\u0002\u0004)\u0017aC2p[B\u0014Xm]:j_:\u0004\"AZ5\u000f\u000559\u0017B\u00015\u0003\u00039\u00195O^\"p[B\u0014Xm]:j_:L!A[6\u0003\u0017\r{W\u000e\u001d:fgNLwN\\\u0005\u0003Y\n\u0011AbQ8naJ,7o]5p]RCqA\\%\u0011\u0002\u0003\u0007q.\u0001\bgS\u0016dG\rR3mS6LG/\u001a:\u0011\u0007I\u0001\u0018+\u0003\u0002r'\t1q\n\u001d;j_:Dqa]%\u0011\u0002\u0003\u0007A/A\u0006qe&tG\u000fS3bI\u0016\u0014\bc\u0001\nqkB\u0011!C^\u0005\u0003oN\u0011qAQ8pY\u0016\fg\u000eC\u0003zQ\u0011\u0005!0\u0001\u0004bg*\u001bxN\u001c\u000b\u0005\u0019ndX\u0010C\u0003Qq\u0002\u0007\u0011\u000bC\u0003Zq\u0002\u0007!\fC\u0004eqB\u0005\t\u0019\u0001@\u0011\u0005}LgbA\u0007\u0002\u0002%\u0019\u00111\u0001\u0002\u0002\u001f)\u001bxN\\\"p[B\u0014Xm]:j_:Dq!a\u0002)\t\u0003\tI!\u0001\u0004bg\u00063(o\u001c\u000b\b\u0019\u0006-\u0011QBA\b\u0011\u0019\u0001\u0016Q\u0001a\u0001#\"1\u0011,!\u0002A\u0002iC\u0011\u0002ZA\u0003!\u0003\u0005\r!!\u0005\u0011\u0007\u0005M\u0011ND\u0002\u000e\u0003+I1!a\u0006\u0003\u0003=\teO]8D_6\u0004(/Z:tS>t\u0007bBA\u000eQ\u0011%\u0011QD\u0001\fKb\u0004xN\u001d;UC\ndW\rF\u0007M\u0003?\t\t#a\t\u0002(\u0005%\u00121\u0006\u0005\u0007!\u0006e\u0001\u0019A)\t\re\u000bI\u00021\u0001[\u0011\u001d\t)#!\u0007A\u0002E\u000baAZ8s[\u0006$\bB\u00023\u0002\u001a\u0001\u0007q\u000e\u0003\u0005o\u00033\u0001\n\u00111\u0001p\u0011!\u0019\u0018\u0011\u0004I\u0001\u0002\u0004!\b\"CA\u0018QE\u0005I\u0011AA\u0019\u0003=\t7oQ:wI\u0011,g-Y;mi\u0012\u001aTCAA\u001aU\r)\u0017QG\u0016\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011I\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0005m\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\n\u0015\u0012\u0002\u0013\u0005\u00111J\u0001\u0010CN\u001c5O\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\n\u0016\u0004_\u0006U\u0002\"CA)QE\u0005I\u0011AA*\u0003=\t7oQ:wI\u0011,g-Y;mi\u0012*TCAA+U\r!\u0018Q\u0007\u0005\n\u00033B\u0013\u0013!C\u0005\u0003\u0017\nQ#\u001a=q_J$H+\u00192mK\u0012\"WMZ1vYR$S\u0007C\u0005\u0002^!\n\n\u0011\"\u0003\u0002T\u0005)R\r\u001f9peR$\u0016M\u00197fI\u0011,g-Y;mi\u00122\u0004\"CA1QE\u0005I\u0011AA2\u0003A\t7OS:p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0002f)\u001aa0!\u000e\t\u0013\u0005%\u0004&%A\u0005\u0002\u0005-\u0014\u0001E1t\u0003Z\u0014x\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tiG\u000b\u0003\u0002\u0012\u0005U\u0002")
public final class ExtractOps {
    private final BigQuery.Client client;
    private final JobOps jobService;

    public void asCsv(String sourceTable, List<String> destinationUris, CompressionT.Compression compression, Option<String> fieldDelimiter, Option<Object> printHeader) {
        this.exportTable(sourceTable, destinationUris, "CSV", compression.name(), fieldDelimiter, printHeader);
    }

    public CompressionT.Compression asCsv$default$3() {
        return new NoCompressionT.NoCompression(CsvCompression$.MODULE$);
    }

    public Option<String> asCsv$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> asCsv$default$5() {
        return None$.MODULE$;
    }

    public void asJson(String sourceTable, List<String> destinationUris, CompressionT.Compression compression) {
        this.exportTable(sourceTable, destinationUris, "NEWLINE_DELIMITED_JSON", compression.name(), this.exportTable$default$5(), this.exportTable$default$6());
    }

    public CompressionT.Compression asJson$default$3() {
        return new NoCompressionT.NoCompression(JsonCompression$.MODULE$);
    }

    public void asAvro(String sourceTable, List<String> destinationUris, CompressionT.Compression compression) {
        this.exportTable(sourceTable, destinationUris, "AVRO", compression.name(), this.exportTable$default$5(), this.exportTable$default$6());
    }

    public CompressionT.Compression asAvro$default$3() {
        return new NoCompressionT.NoCompression(AvroCompression$.MODULE$);
    }

    private void exportTable(String sourceTable, List<String> destinationUris, String format, Option<String> compression, Option<String> fieldDelimiter, Option<Object> printHeader) {
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)sourceTable);
        JobConfigurationExtract jobConfigExtract = new JobConfigurationExtract().setSourceTable(tableRef).setDestinationUris((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(destinationUris).asJava()).setDestinationFormat(format);
        compression.foreach((Function1)new Serializable(this, jobConfigExtract){
            public static final long serialVersionUID = 0L;
            private final JobConfigurationExtract jobConfigExtract$1;

            public final JobConfigurationExtract apply(String x$1) {
                return this.jobConfigExtract$1.setCompression(x$1);
            }
            {
                this.jobConfigExtract$1 = jobConfigExtract$1;
            }
        });
        fieldDelimiter.foreach((Function1)new Serializable(this, jobConfigExtract){
            public static final long serialVersionUID = 0L;
            private final JobConfigurationExtract jobConfigExtract$1;

            public final JobConfigurationExtract apply(String x$1) {
                return this.jobConfigExtract$1.setFieldDelimiter(x$1);
            }
            {
                this.jobConfigExtract$1 = jobConfigExtract$1;
            }
        });
        printHeader.foreach((Function1)new Serializable(this, jobConfigExtract){
            public static final long serialVersionUID = 0L;
            private final JobConfigurationExtract jobConfigExtract$1;

            public final JobConfigurationExtract apply(boolean x$1) {
                return this.jobConfigExtract$1.setPrintHeader(Predef$.MODULE$.boolean2Boolean(x$1));
            }
            {
                this.jobConfigExtract$1 = jobConfigExtract$1;
            }
        });
        JobConfiguration jobConfig = new JobConfiguration().setExtract(jobConfigExtract);
        String fullJobId = BigQueryUtil$.MODULE$.generateJobId(this.client.project());
        JobReference jobReference = new JobReference().setProjectId(this.client.project()).setJobId(fullJobId);
        Job job = new Job().setConfiguration(jobConfig).setJobReference(jobReference);
        ExtractOps$.MODULE$.com$spotify$scio$bigquery$client$ExtractOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracting table ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceTable, destinationUris.mkString(", ")})));
        this.client.underlying().jobs().insert(this.client.project(), job).execute();
        ExtractJob extractJob = new ExtractJob(destinationUris, (Option<JobReference>)new Some((Object)jobReference), tableRef);
        this.jobService.waitForJobs((Seq<BigQueryJob>)Predef$.MODULE$.wrapRefArray((Object[])new BigQueryJob[]{extractJob}));
    }

    private Option<String> exportTable$default$5() {
        return None$.MODULE$;
    }

    private Option<Object> exportTable$default$6() {
        return None$.MODULE$;
    }

    public ExtractOps(BigQuery.Client client, JobOps jobService) {
        this.client = client;
        this.jobService = jobService;
    }
}

