/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.types;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.spotify.scio.bigquery.types.NameProvider$;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;

public final class SchemaUtil$ {
    public static final SchemaUtil$ MODULE$;
    private final Seq<String> scalaReservedWords;
    private volatile boolean bitmap$init$0;

    static {
        new SchemaUtil$();
    }

    public String toPrettyString(TableSchema schema2, String name, int indent) {
        return new StringBuilder().append((Object)"@BigQueryType.toTable\n").append((Object)this.getCaseClass(schema2.getFields(), name, indent)).toString();
    }

    private Tuple2<String, Seq<String>> getRawType(TableFieldSchema tfs, int indent) {
        String string;
        block16: {
            Tuple2 tuple2;
            String string2;
            block6: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        string = tfs.getType();
                                                        if (!"BOOLEAN".equals(string)) break block5;
                                                        string2 = "Boolean";
                                                        break block6;
                                                    }
                                                    boolean bl = "INTEGER".equals(string) ? true : "INT64".equals(string);
                                                    if (!bl) break block7;
                                                    string2 = "Long";
                                                    break block6;
                                                }
                                                boolean bl = "FLOAT".equals(string) ? true : "FLOAT64".equals(string);
                                                if (!bl) break block8;
                                                string2 = "Double";
                                                break block6;
                                            }
                                            if (!"STRING".equals(string)) break block9;
                                            string2 = "String";
                                            break block6;
                                        }
                                        if (!"NUMERIC".equals(string)) break block10;
                                        string2 = "BigDecimal";
                                        break block6;
                                    }
                                    if (!"BYTES".equals(string)) break block11;
                                    string2 = "ByteString";
                                    break block6;
                                }
                                if (!"TIMESTAMP".equals(string)) break block12;
                                string2 = "Instant";
                                break block6;
                            }
                            if (!"DATE".equals(string)) break block13;
                            string2 = "LocalDate";
                            break block6;
                        }
                        if (!"TIME".equals(string)) break block14;
                        string2 = "LocalTime";
                        break block6;
                    }
                    if (!"DATETIME".equals(string)) break block15;
                    string2 = "LocalDateTime";
                    break block6;
                }
                boolean bl = "RECORD".equals(string) ? true : "STRUCT".equals(string);
                if (!bl) break block16;
                string2 = NameProvider$.MODULE$.getUniqueName(tfs.getName());
            }
            String name = string2;
            String string3 = tfs.getType();
            String string4 = "RECORD";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String nested = this.getCaseClass(tfs.getFields(), name, indent);
                tuple2 = new Tuple2((Object)name, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nested})));
            } else {
                tuple2 = new Tuple2((Object)name, (Object)Seq$.MODULE$.empty());
            }
            return tuple2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type: ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public Tuple2<String, Seq<String>> com$spotify$scio$bigquery$types$SchemaUtil$$getFieldType(TableFieldSchema tfs, int indent) {
        Tuple2<String, Seq<String>> tuple2;
        block2: {
            String string;
            block6: {
                String string2;
                Seq nested;
                block4: {
                    String rawType;
                    block5: {
                        block3: {
                            Tuple2 tuple22;
                            tuple2 = this.getRawType(tfs, indent);
                            if (tuple2 == null) break block2;
                            String rawType2 = (String)tuple2._1();
                            Seq nested2 = (Seq)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rawType2, (Object)nested2);
                            rawType = (String)tuple23._1();
                            nested = (Seq)tuple23._2();
                            string = tfs.getMode();
                            boolean bl = "NULLABLE".equals(string) ? true : string == null;
                            if (!bl) break block3;
                            string2 = new StringBuilder().append((Object)"Option[").append((Object)rawType).append((Object)"]").toString();
                            break block4;
                        }
                        if (!"REQUIRED".equals(string)) break block5;
                        string2 = rawType;
                        break block4;
                    }
                    if (!"REPEATED".equals(string)) break block6;
                    string2 = new StringBuilder().append((Object)"List[").append((Object)rawType).append((Object)"]").toString();
                }
                String fieldType = string2;
                return new Tuple2((Object)fieldType, (Object)nested);
            }
            throw new MatchError((Object)string);
        }
        throw new MatchError(tuple2);
    }

    private String getCaseClass(List<TableFieldSchema> fields, String name, int indent) {
        String string;
        Buffer xs = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(indent){
            public static final long serialVersionUID = 0L;
            private final int indent$1;

            public final Tuple2<String, Seq<String>> apply(TableFieldSchema f) {
                Tuple2<String, Seq<String>> tuple2 = SchemaUtil$.MODULE$.com$spotify$scio$bigquery$types$SchemaUtil$$getFieldType(f, this.indent$1);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String fieldType = (String)tuple2._1();
                    Seq nested = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldType, (Object)nested);
                    String fieldType2 = (String)tuple23._1();
                    Seq nested2 = (Seq)tuple23._2();
                    return new Tuple2((Object)new StringBuilder().append((Object)SchemaUtil$.MODULE$.escapeNameIfReserved(f.getName())).append((Object)": ").append((Object)fieldType2).toString(), (Object)nested2);
                }
                throw new MatchError(tuple2);
            }
            {
                this.indent$1 = indent$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer lines = (Buffer)xs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<String>> x$3) {
                return (String)x$3._1();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer nested = (Buffer)xs.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Seq<String>> x$4) {
                return (Seq)x$4._2();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"case class ", "("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        Object object = indent > 0 ? sb.append("\n") : BoxedUnit.UNIT;
        if (indent > 0) {
            String w = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(indent);
            string = ((TraversableOnce)lines.map((Function1)new Serializable(w){
                public static final long serialVersionUID = 0L;
                private final String w$1;

                public final String apply(String x$5) {
                    return new StringBuilder().append((Object)this.w$1).append((Object)x$5).toString();
                }
                {
                    this.w$1 = w$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",\n");
        } else {
            string = lines.mkString(", ");
        }
        String body = string;
        sb.append(body);
        sb.append(")");
        String string2 = sb.toString();
        return ((TraversableOnce)nested.$plus$colon((Object)string2, Buffer$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String escapeNameIfReserved(String name) {
        return this.scalaReservedWords().contains((Object)name) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})) : name;
    }

    public Seq<String> scalaReservedWords() {
        if (this.bitmap$init$0) {
            return this.scalaReservedWords;
        }
        throw new UninitializedFieldError("Uninitialized field: SchemaUtil.scala: 102");
    }

    private SchemaUtil$() {
        MODULE$ = this;
        this.scalaReservedWords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"}));
        this.bitmap$init$0 = true;
    }
}

