/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.auth.Credentials;
import com.spotify.scio.ScioContext;
import com.spotify.scio.bigquery.BigQueryStorage$ReadParam$;
import com.spotify.scio.bigquery.Reads$;
import com.spotify.scio.bigquery.Table;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.BigQuery$;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.QueryJob;
import com.spotify.scio.values.SCollection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Try;

public final class Reads$ {
    public static final Reads$ MODULE$;
    public final ConcurrentHashMap<ScioContext, BigQuery> com$spotify$scio$bigquery$Reads$$cache;

    static {
        new Reads$();
    }

    private BigQuery client(ScioContext sc) {
        return this.com$spotify$scio$bigquery$Reads$$cache.computeIfAbsent(sc, new Function<ScioContext, BigQuery>(){

            public BigQuery apply(ScioContext context) {
                GcpOptions opts = (GcpOptions)context.optionsAs(ClassTag$.MODULE$.apply(GcpOptions.class));
                return BigQuery$.MODULE$.apply(opts.getProject(), (Function0<Credentials>)new Serializable(this, opts){
                    public static final long serialVersionUID = 0L;
                    private final GcpOptions opts$1;

                    public final Credentials apply() {
                        return this.opts$1.getGcpCredential();
                    }
                    {
                        this.opts$1 = opts$1;
                    }
                });
            }
        });
    }

    public <T> SCollection<T> bqReadQuery(ScioContext sc, BigQueryIO.TypedRead<T> typedRead, String sqlQuery, boolean flattenResults) {
        PCollection pCollection;
        BigQuery bigQueryClient = this.client(sc);
        if (bigQueryClient.isCacheEnabled()) {
            Try read2 = bigQueryClient.query().newQueryJob(sqlQuery, flattenResults).map((Function1)new Serializable(sc, typedRead, bigQueryClient){
                public static final long serialVersionUID = 0L;
                private final ScioContext sc$1;
                private final BigQueryIO.TypedRead typedRead$1;
                public final BigQuery bigQueryClient$1;

                public final BigQueryIO.TypedRead<T> apply(QueryJob job) {
                    this.sc$1.onClose((Function1)new Serializable(this, job){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;
                        private final QueryJob job$1;

                        public final void apply(BoxedUnit x$1) {
                            this.$outer.bigQueryClient$1.waitForJobs((Seq<BigQueryJob>)Predef$.MODULE$.wrapRefArray((Object[])new BigQueryJob[]{this.job$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.job$1 = job$1;
                        }
                    });
                    return this.typedRead$1.from(job.table()).withoutValidation();
                }
                {
                    this.sc$1 = sc$1;
                    this.typedRead$1 = typedRead$1;
                    this.bigQueryClient$1 = bigQueryClient$1;
                }
            });
            pCollection = (PCollection)sc.applyInternal((PTransform)read2.get());
        } else {
            BigQueryIO.TypedRead baseQuery = flattenResults ? typedRead.fromQuery(sqlQuery) : typedRead.fromQuery(sqlQuery).withoutResultFlattening();
            BigQueryIO.TypedRead query2 = bigQueryClient.query().isLegacySql(sqlQuery, flattenResults) ? baseQuery : baseQuery.usingStandardSql();
            pCollection = (PCollection)sc.applyInternal((PTransform)query2);
        }
        return sc.wrap(pCollection);
    }

    public <T> boolean bqReadQuery$default$4(ScioContext sc) {
        return false;
    }

    public <T> SCollection<T> bqReadStorage(ScioContext sc, BigQueryIO.TypedRead<T> typedRead, Table table2, List<String> selectedFields2, Option<String> rowRestriction2, ClassTag<T> evidence$1) {
        ObjectRef read2 = ObjectRef.create((Object)typedRead.from(table2.spec()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withSelectedFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(selectedFields2).asJava()));
        BigQueryIO.TypedRead typedRead2 = (BigQueryIO.TypedRead)read2.elem;
        read2.elem = (BigQueryIO.TypedRead)rowRestriction2.fold((Function0)new Serializable(read2){
            public static final long serialVersionUID = 0L;
            private final ObjectRef read$1;

            public final BigQueryIO.TypedRead<T> apply() {
                return (BigQueryIO.TypedRead)this.read$1.elem;
            }
            {
                this.read$1 = read$1;
            }
        }, (Function1)new Serializable(typedRead2){
            public static final long serialVersionUID = 0L;
            private final BigQueryIO.TypedRead eta$0$1$1;

            public final BigQueryIO.TypedRead<T> apply(String x$1) {
                return this.eta$0$1$1.withRowRestriction(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        return sc.wrap((PCollection)sc.applyInternal((PTransform)((BigQueryIO.TypedRead)read2.elem)));
    }

    public <T> List<String> bqReadStorage$default$4(ScioContext sc) {
        return BigQueryStorage$ReadParam$.MODULE$.DefaultSelectFields();
    }

    public <T> Option<String> bqReadStorage$default$5(ScioContext sc) {
        return BigQueryStorage$ReadParam$.MODULE$.DefaultRowRestriction();
    }

    private Reads$() {
        MODULE$ = this;
        this.com$spotify$scio$bigquery$Reads$$cache = new ConcurrentHashMap();
    }
}

