/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobStatistics;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.ExtractJob;
import com.spotify.scio.bigquery.client.LoadJob;
import com.spotify.scio.bigquery.client.QueryJob;
import org.apache.commons.io.FileUtils;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class JobOps$ {
    public static final JobOps$ MODULE$;
    private final Logger com$spotify$scio$bigquery$client$JobOps$$Logger;
    private final PeriodFormatter PeriodFormatter;
    private volatile byte bitmap$init$0;

    static {
        new JobOps$();
    }

    public Logger com$spotify$scio$bigquery$client$JobOps$$Logger() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.com$spotify$scio$bigquery$client$JobOps$$Logger;
        }
        throw new UninitializedFieldError("Uninitialized field: JobOps.scala: 32");
    }

    private PeriodFormatter PeriodFormatter() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.PeriodFormatter;
        }
        throw new UninitializedFieldError("Uninitialized field: JobOps.scala: 34");
    }

    public void com$spotify$scio$bigquery$client$JobOps$$logJobStatistics(BigQueryJob bqJob, Job job) {
        BigQueryJob bigQueryJob;
        block5: {
            JobStatistics stats;
            block3: {
                block4: {
                    block2: {
                        stats = job.getStatistics();
                        this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bqJob.show()})));
                        bigQueryJob = bqJob;
                        if (!(bigQueryJob instanceof ExtractJob)) break block2;
                        Long destinationFileCount = (Long)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(stats.getExtract().getDestinationUriFileCounts()).asScala()).reduce((Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Long apply(Long x$1, Long x$2) {
                                return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(x$1) + Predef$.MODULE$.Long2long(x$2));
                            }
                        });
                        this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total destination file count: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destinationFileCount})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(bigQueryJob instanceof LoadJob)) break block4;
                    String inputFileBytes = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(stats.getLoad().getInputFileBytes()));
                    String outputBytes = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(stats.getLoad().getOutputBytes()));
                    Long outputRows = stats.getLoad().getOutputRows();
                    this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input file bytes: ", ", output bytes: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputFileBytes, outputBytes}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"output rows: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputRows}))).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(bigQueryJob instanceof QueryJob)) break block5;
                QueryJob queryJob = (QueryJob)bigQueryJob;
                this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryJob.query()})));
                String bytes = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(stats.getQuery().getTotalBytesProcessed()));
                Boolean cacheHit = stats.getQuery().getCacheHit();
                this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total bytes processed: ", ", cache hit: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bytes, cacheHit})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            String elapsed = this.PeriodFormatter().print((ReadablePeriod)new Period(Predef$.MODULE$.Long2long(stats.getEndTime()) - Predef$.MODULE$.Long2long(stats.getCreationTime())));
            String pending = this.PeriodFormatter().print((ReadablePeriod)new Period(Predef$.MODULE$.Long2long(stats.getStartTime()) - Predef$.MODULE$.Long2long(stats.getCreationTime())));
            String execution = this.PeriodFormatter().print((ReadablePeriod)new Period(Predef$.MODULE$.Long2long(stats.getEndTime()) - Predef$.MODULE$.Long2long(stats.getStartTime())));
            this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elapsed: ", ", pending: ", ", execution: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elapsed, pending, execution})));
            return;
        }
        throw new MatchError((Object)bigQueryJob);
    }

    private JobOps$() {
        MODULE$ = this;
        this.com$spotify$scio$bigquery$client$JobOps$$Logger = LoggerFactory.getLogger(this.getClass());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.PeriodFormatter = new PeriodFormatterBuilder().appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSecondsWithOptionalMillis().appendSuffix("s").toFormatter();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

