/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.spotify.scio.bigquery.StorageUtil$;
import com.spotify.scio.bigquery.Table;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.Cache$;
import com.spotify.scio.bigquery.client.Cache$Read$;
import com.spotify.scio.bigquery.client.Cache$Show$;
import com.spotify.scio.bigquery.client.TableOps$;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtilsWrapper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesWrapper;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.joda.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Random$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001drAB\u0001\u0003\u0011\u0003\u0011A\"\u0001\u0005UC\ndWm\u00149t\u0015\t\u0019A!\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b\u0019\t\u0001BY5hcV,'/\u001f\u0006\u0003\u000f!\tAa]2j_*\u0011\u0011BC\u0001\bgB|G/\u001b4z\u0015\u0005Y\u0011aA2p[B\u0011QBD\u0007\u0002\u0005\u00191qB\u0001E\u0001\u0005A\u0011\u0001\u0002V1cY\u0016|\u0005o]\n\u0003\u001dE\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0007\"\u0002\r\u000f\t\u0003Q\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u00031Aq\u0001\b\bC\u0002\u0013%Q$\u0001\u0004M_\u001e<WM]\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0006g24GG\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015\u0002#A\u0002'pO\u001e,'\u000f\u0003\u0004(\u001d\u0001\u0006IAH\u0001\b\u0019><w-\u001a:!\u0011\u001dIcB1A\u0005\n)\n1\u0002V1cY\u0016\u0004&/\u001a4jqV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\rM#(/\u001b8h\u0011\u0019!d\u0002)A\u0005W\u0005aA+\u00192mKB\u0013XMZ5yA!9aG\u0004b\u0001\n\u00139\u0014!\u0004+j[\u00164uN]7biR,'/F\u00019!\tI\u0004)D\u0001;\u0015\tYD(\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003{y\nA\u0001^5nK*\u0011qHI\u0001\u0005U>$\u0017-\u0003\u0002Bu\t\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\t\r\rs\u0001\u0015!\u00039\u00039!\u0016.\\3G_Jl\u0017\r\u001e;fe\u0002Bq!\u0012\bC\u0002\u0013%!&\u0001\u000bTi\u0006<\u0017N\\4ECR\f7/\u001a;Qe\u00164\u0017\u000e\u001f\u0005\u0007\u000f:\u0001\u000b\u0011B\u0016\u0002+M#\u0018mZ5oO\u0012\u000bG/Y:fiB\u0013XMZ5yA!9\u0011J\u0004b\u0001\n\u0013Q\u0015aH*uC\u001eLgn\u001a#bi\u0006\u001cX\r\u001e+bE2,W\t\u001f9je\u0006$\u0018n\u001c8NgV\t1\n\u0005\u0002\u0013\u0019&\u0011Qj\u0005\u0002\u0005\u0019>tw\r\u0003\u0004P\u001d\u0001\u0006IaS\u0001!'R\fw-\u001b8h\t\u0006$\u0018m]3u)\u0006\u0014G.Z#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004R\u001d\t\u0007I\u0011\u0002\u0016\u00023M#\u0018mZ5oO\u0012\u000bG/Y:fi\u0012+7o\u0019:jaRLwN\u001c\u0005\u0007':\u0001\u000b\u0011B\u0016\u00025M#\u0018mZ5oO\u0012\u000bG/Y:fi\u0012+7o\u0019:jaRLwN\u001c\u0011\u0007\u000b=\u0011!AA+\u0014\u0005Q\u000b\u0002\u0002C\u0002U\u0005\u0003\u0005\u000b\u0011B,\u0011\u0005aCgBA-g\u001d\tQVM\u0004\u0002\\I:\u0011Al\u0019\b\u0003;\nt!AX1\u000e\u0003}S!\u0001Y\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003O\n\t\u0001BQ5h#V,'/_\u0005\u0003S*\u0014aa\u00117jK:$(BA4\u0003\u0011\u0015AB\u000b\"\u0001m)\tig\u000e\u0005\u0002\u000e)\")1a\u001ba\u0001/\")\u0001\u000f\u0016C\u0001c\u0006!!o\\<t)\r\u0011\u00181\u0001\t\u0004gb\\hB\u0001;w\u001d\tqV/C\u0001\u0015\u0013\t98#A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(\u0001C%uKJ\fGo\u001c:\u000b\u0005]\u001c\u0002C\u0001?\u007f\u001d\tQV0\u0003\u0002x\t%\u0019q0!\u0001\u0003\u0011Q\u000b'\r\\3S_^T!a\u001e\u0003\t\u000f\u0005\u0015q\u000e1\u0001\u0002\b\u0005)A/\u00192mKB!\u0011\u0011BA\u0006\u001b\u0005!\u0011bAA\u0007\t\t)A+\u00192mK\"9\u0011\u0011\u0003+\u0005\u0002\u0005M\u0011\u0001C1we>\u0014vn^:\u0015\t\u0005U\u00111\u0006\t\u0005gb\f9\u0002\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000f\u001d,g.\u001a:jG*!\u0011\u0011EA\u0012\u0003\u0011\tgO]8\u000b\u0007\u0005\u0015\"%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003S\tYBA\u0007HK:,'/[2SK\u000e|'\u000f\u001a\u0005\t\u0003\u000b\ty\u00011\u0001\u0002\b!9\u0011q\u0006+\u0005\u0002\u0005E\u0012aC:u_J\fw-\u001a*poN$RA]A\u001a\u0003kA\u0001\"!\u0002\u0002.\u0001\u0007\u0011q\u0001\u0005\t\u0003o\ti\u00031\u0001\u0002:\u0005Y!/Z1e\u001fB$\u0018n\u001c8t!\u0011\tY$a\u001a\u000f\t\u0005u\u0012\u0011\r\b\u0005\u0003\u007f\tYF\u0004\u0003\u0002B\u0005Uc\u0002BA\"\u0003#rA!!\u0012\u0002L9\u0019Q,a\u0012\n\u0007\u0005%#\"\u0001\u0004h_><G.Z\u0005\u0005\u0003\u001b\ny%A\u0003dY>,HMC\u0002\u0002J)I1!BA*\u0015\u0011\ti%a\u0014\n\t\u0005]\u0013\u0011L\u0001\bgR|'/Y4f\u0015\r)\u00111K\u0005\u0005\u0003;\ny&A\u0004wc\t,G/Y\u0019\u000b\t\u0005]\u0013\u0011L\u0005\u0005\u0003G\n)'A\u0006SK\u0006$w\n\u001d;j_:\u001c(\u0002BA/\u0003?JA!!\u001b\u0002l\t\u0001B+\u00192mKJ+\u0017\rZ(qi&|gn\u001d\u0006\u0005\u0003G\n)\u0007C\u0004\u0002pQ#\t!!\u001d\u0002\u001fM$xN]1hK\u00063(o\u001c*poN$b!!\u0006\u0002t\u0005U\u0004\u0002CA\u0003\u0003[\u0002\r!a\u0002\t\u0011\u0005]\u0012Q\u000ea\u0001\u0003sAq!!\u001fU\t\u0003\tY(\u0001\u0004tG\",W.\u0019\u000b\u0005\u0003{\n\u0019\n\u0005\u0003\u0002\u0000\u0005=UBAAA\u0015\u0011\t\u0019)!\"\u0002\u000b5|G-\u001a7\u000b\u0007\u0015\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001C:feZL7-Z:\u000b\t\u00055\u0015qJ\u0001\u0004CBL\u0017\u0002BAI\u0003\u0003\u00131\u0002V1cY\u0016\u001c6\r[3nC\"A\u0011QSA<\u0001\u0004\t9*A\u0005uC\ndWm\u00159fGB!\u0011\u0011TAP\u001d\r\u0011\u00121T\u0005\u0004\u0003;\u001b\u0012A\u0002)sK\u0012,g-C\u00023\u0003CS1!!(\u0014\u0011\u001d\tI\b\u0016C\u0001\u0003K#B!! \u0002(\"A\u0011\u0011VAR\u0001\u0004\tY+\u0001\u0005uC\ndWMU3g!\u0011\ty(!,\n\t\u0005=\u0016\u0011\u0011\u0002\u000f)\u0006\u0014G.\u001a*fM\u0016\u0014XM\\2f\u0011\u001d\t\u0019\f\u0016C\u0001\u0003k\u000b\u0011c\u001d;pe\u0006<WMU3bIN\u001b\u0007.Z7b)!\t9,a0\u0002B\u0006-\u0007\u0003BA]\u0003wk!!a\b\n\t\u0005u\u0016q\u0004\u0002\u0007'\u000eDW-\\1\t\u0011\u0005U\u0015\u0011\u0017a\u0001\u0003/C!\"a1\u00022B\u0005\t\u0019AAc\u00039\u0019X\r\\3di\u0016$g)[3mIN\u0004Ra]Ad\u0003/K1!!3{\u0005\u0011a\u0015n\u001d;\t\u0015\u00055\u0017\u0011\u0017I\u0001\u0002\u0004\ty-\u0001\bs_^\u0014Vm\u001d;sS\u000e$\u0018n\u001c8\u0011\u000bI\t\t.a&\n\u0007\u0005M7C\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000b!F\u0011AAl)\u0011\tI.!8\u0011\t\u0005}\u00141\\\u0005\u0005\u0003\u001b\t\t\t\u0003\u0005\u0002\u0016\u0006U\u0007\u0019AAL\u0011\u001d\t)\u0001\u0016C\u0001\u0003C$B!!7\u0002d\"A\u0011\u0011VAp\u0001\u0004\tY\u000bC\u0004\u0002hR#\t!!;\u0002\u001fQ\f'\r\\3SK\u001a,'/\u001a8dKN$b!a;\u0002r\u0006U\b#B:\u0002n\u0006-\u0016bAAxu\n\u00191+Z9\t\u0011\u0005M\u0018Q\u001da\u0001\u0003/\u000b\u0011\u0002\u001d:pU\u0016\u001cG/\u00133\t\u0011\u0005]\u0018Q\u001da\u0001\u0003/\u000b\u0011\u0002Z1uCN,G/\u00133\t\u000f\u0005mH\u000b\"\u0001\u0002~\u000611M]3bi\u0016$B!a@\u0003\u0006A\u0019!C!\u0001\n\u0007\t\r1C\u0001\u0003V]&$\b\u0002CA\u0003\u0003s\u0004\r!!7\t\u000f\u0005mH\u000b\"\u0001\u0003\nQ1\u0011q B\u0006\u0005\u001bA\u0001\"!\u0002\u0003\b\u0001\u0007\u00111\u0016\u0005\t\u0003s\u00129\u00011\u0001\u0002~!9\u00111 +\u0005\u0002\tEACBA\u0000\u0005'\u0011)\u0002\u0003\u0005\u0002\u0016\n=\u0001\u0019AAL\u0011!\tIHa\u0004A\u0002\u0005u\u0004b\u0002B\r)\u0012\u0005!1D\u0001\u0007KbL7\u000f^:\u0015\t\tu!1\u0005\t\u0004%\t}\u0011b\u0001B\u0011'\t9!i\\8mK\u0006t\u0007\u0002CAU\u0005/\u0001\r!a+\t\u000f\teA\u000b\"\u0001\u0003(Q!!Q\u0004B\u0015\u0011!\t)J!\nA\u0002\u0005]\u0005b\u0002B\u0017)\u0012\u0005!qF\u0001\noJLG/\u001a*poN$2b\u0013B\u0019\u0005k\u0011IDa\u000f\u0003\u0004\"A!1\u0007B\u0016\u0001\u0004\tY+\u0001\buC\ndWMU3gKJ,gnY3\t\u000fA\u0014Y\u00031\u0001\u00038A!1/a2|\u0011!\tIHa\u000bA\u0002\u0005u\u0004\u0002\u0003B\u001f\u0005W\u0001\rAa\u0010\u0002!]\u0014\u0018\u000e^3ESN\u0004xn]5uS>t\u0007\u0003\u0002B!\u0005{rAAa\u0011\u0003x9!!Q\tB9\u001d\u0011\u00119E!\u001c\u000f\t\t%#q\r\b\u0005\u0005\u0017\u0012\tG\u0004\u0003\u0003N\tmc\u0002\u0002B(\u0005/rAA!\u0015\u0003V9\u0019aLa\u0015\n\u0003\rJ1!!\n#\u0013\u0011\u0011I&a\t\u0002\t\t,\u0017-\\\u0005\u0005\u0005;\u0012y&A\u0002tI.TAA!\u0017\u0002$%!!1\rB3\u0003\tIwN\u0003\u0003\u0003^\t}\u0013\u0002\u0002B5\u0005W\n1aZ2q\u0015\u0011\u0011\u0019G!\u001a\n\u0007\u0015\u0011yG\u0003\u0003\u0003j\t-\u0014\u0002\u0002B:\u0005k\n!BQ5h#V,'/_%P\u0015\r)!qN\u0005\u0005\u0005s\u0012Y(A\u0003Xe&$XM\u0003\u0003\u0003t\tU\u0014\u0002\u0002B@\u0005\u0003\u0013\u0001c\u0016:ji\u0016$\u0015n\u001d9pg&$\u0018n\u001c8\u000b\t\te$1\u0010\u0005\t\u0005\u000b\u0013Y\u00031\u0001\u0003\b\u0006\t2M]3bi\u0016$\u0015n\u001d9pg&$\u0018n\u001c8\u0011\t\t\u0005#\u0011R\u0005\u0005\u0005\u0017\u0013\tIA\tDe\u0016\fG/\u001a#jgB|7/\u001b;j_:DqA!\fU\t\u0003\u0011y\tF\u0006L\u0005#\u0013\u0019J!&\u0003\u0018\ne\u0005\u0002CAK\u0005\u001b\u0003\r!a&\t\u000fA\u0014i\t1\u0001\u00038!Q\u0011\u0011\u0010BG!\u0003\u0005\r!! \t\u0015\tu\"Q\u0012I\u0001\u0002\u0004\u0011y\u0004\u0003\u0006\u0003\u0006\n5\u0005\u0013!a\u0001\u0005\u000fC\u0001B!(U\t\u0003!!qT\u0001\u0014o&$\bNQ5h#V,'/_*feZL7-Z\u000b\u0005\u0005C\u00139\u000b\u0006\u0003\u0003$\ne\u0006\u0003\u0002BS\u0005Oc\u0001\u0001\u0002\u0005\u0003*\nm%\u0019\u0001BV\u0005\u0005!\u0016\u0003\u0002BW\u0005g\u00032A\u0005BX\u0013\r\u0011\tl\u0005\u0002\b\u001d>$\b.\u001b8h!\r\u0011\"QW\u0005\u0004\u0005o\u001b\"aA!os\"A!1\u0018BN\u0001\u0004\u0011i,A\u0001g!\u001d\u0011\"q\u0018Bb\u0005GK1A!1\u0014\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003F\n\u001dWB\u0001B;\u0013\u0011\u0011IM!\u001e\u0003/\tKw-U;fef\u001cVM\u001d<jG\u0016\u001cxK]1qa\u0016\u0014\b\u0002\u0003Bg)\u0012\u0005AAa4\u0002\r\u0011,G.\u001a;f)\u0011\tyP!5\t\u0011\u0005\u0015!1\u001aa\u0001\u0003WC\u0001B!6U\t\u0003!!q[\u0001\u0016aJ,\u0007/\u0019:f'R\fw-\u001b8h\t\u0006$\u0018m]3u)\u0011\tyP!7\t\u0011\tm'1\u001ba\u0001\u0003/\u000b\u0001\u0002\\8dCRLwN\u001c\u0005\t\u0005?$F\u0011\u0001\u0003\u0003b\u0006y1M]3bi\u0016$V-\u001c9pe\u0006\u0014\u0018\u0010\u0006\u0003\u0002,\n\r\b\u0002\u0003Bn\u0005;\u0004\r!a&\t\u000f\t\u001dH\u000b\"\u0003\u0003j\u0006\u00012\u000f^1hS:<G)\u0019;bg\u0016$\u0018\n\u001a\u000b\u0005\u0003/\u0013Y\u000f\u0003\u0005\u0003\\\n\u0015\b\u0019AAL\u0011%\u0011y\u000fVI\u0001\n\u0003\u0011\t0A\nxe&$XMU8xg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003t*\"\u0011Q\u0010B{W\t\u00119\u0010\u0005\u0003\u0003z\u000e\rQB\u0001B~\u0015\u0011\u0011iPa@\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0001'\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u0015!1 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB\u0005)F\u0005I\u0011AB\u0006\u0003M9(/\u001b;f%><8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019iA\u000b\u0003\u0003@\tU\b\"CB\t)F\u0005I\u0011AB\n\u0003M9(/\u001b;f%><8\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019)B\u000b\u0003\u0003\b\nU\b\"CB\r)F\u0005I\u0011AB\u000e\u0003m\u0019Ho\u001c:bO\u0016\u0014V-\u00193TG\",W.\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0004\u0016\u0005\u0003\u000b\u0014)\u0010C\u0005\u0004\"Q\u000b\n\u0011\"\u0001\u0004$\u0005Y2\u000f^8sC\u001e,'+Z1e'\u000eDW-\\1%I\u00164\u0017-\u001e7uIM*\"a!\n+\t\u0005='Q\u001f")
public final class TableOps {
    public final BigQuery.Client com$spotify$scio$bigquery$client$TableOps$$client;

    public Iterator<TableRow> rows(Table table2) {
        return this.storageRows(table2, ReadOptions.TableReadOptions.getDefaultInstance());
    }

    public Iterator<GenericRecord> avroRows(Table table2) {
        return this.storageAvroRows(table2, ReadOptions.TableReadOptions.getDefaultInstance());
    }

    public Iterator<TableRow> storageRows(Table table2, ReadOptions.TableReadOptions readOptions) {
        return (Iterator)this.withBigQueryService((Function1)new Serializable(this, table2, readOptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final Table table$2;
            private final ReadOptions.TableReadOptions readOptions$1;

            public final Iterator<TableRow> apply(BigQueryServicesWrapper bqServices) {
                com.google.api.services.bigquery.model.Table tb = bqServices.getTable(this.table$2.ref(), (java.util.List<String>)this.readOptions$1.getSelectedFieldsList());
                return this.$outer.storageAvroRows(this.table$2, this.readOptions$1).map((Function1)new Serializable(this, tb){
                    public static final long serialVersionUID = 0L;
                    private final com.google.api.services.bigquery.model.Table tb$1;

                    public final TableRow apply(GenericRecord gr) {
                        return BigQueryAvroUtilsWrapper.convertGenericRecordToTableRow(gr, this.tb$1.getSchema());
                    }
                    {
                        this.tb$1 = tb$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$2 = table$2;
                this.readOptions$1 = readOptions$1;
            }
        });
    }

    public Iterator<GenericRecord> storageAvroRows(Table table2, ReadOptions.TableReadOptions readOptions) {
        TableReferenceProto.TableReference.Builder tableRefProto = TableReferenceProto.TableReference.newBuilder().setDatasetId(table2.ref().getDatasetId()).setTableId(table2.ref().getTableId());
        Object object = table2.ref().getProjectId() == null ? BoxedUnit.UNIT : tableRefProto.setProjectId(table2.ref().getProjectId());
        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(tableRefProto).setReadOptions(readOptions).setParent(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"projects/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$spotify$scio$bigquery$client$TableOps$$client.project()}))).setRequestedStreams(1).setFormat(Storage.DataFormat.AVRO).build();
        Storage.ReadSession session = this.com$spotify$scio$bigquery$client$TableOps$$client.storage().createReadSession(request);
        Storage.ReadRowsRequest readRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(session.getStreams(0))).build();
        Schema schema2 = new Schema.Parser().parse(session.getAvroSchema().getSchema());
        GenericDatumReader reader = new GenericDatumReader(schema2);
        Iterable responses = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.com$spotify$scio$bigquery$client$TableOps$$client.storage().readRowsCallable().call((Object)readRowsRequest)).asScala();
        ObjectRef decoder = ObjectRef.create(null);
        return responses.iterator().flatMap((Function1)new Serializable(this, reader, decoder){
            public static final long serialVersionUID = 0L;
            private final GenericDatumReader reader$1;
            private final ObjectRef decoder$1;

            /*
             * WARNING - void declaration
             */
            public final Iterator<GenericRecord> apply(Storage.ReadRowsResponse resp) {
                byte[] bytes = resp.getAvroRows().getSerializedBinaryRows().toByteArray();
                this.decoder$1.elem = DecoderFactory.get().binaryDecoder(bytes, (BinaryDecoder)this.decoder$1.elem);
                ArrayBuffer res = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                while (!((BinaryDecoder)this.decoder$1.elem).isEnd()) {
                    void var3_3;
                    var3_3.$plus$eq(this.reader$1.read(null, (Decoder)((BinaryDecoder)this.decoder$1.elem)));
                }
                return res.toIterator();
            }
            {
                this.reader$1 = reader$1;
                this.decoder$1 = decoder$1;
            }
        });
    }

    public TableSchema schema(String tableSpec) {
        return this.schema(BigQueryHelpers.parseTableSpec((String)tableSpec));
    }

    public TableSchema schema(TableReference tableRef) {
        return Cache$.MODULE$.getOrElse(BigQueryHelpers.toTableSpec((TableReference)tableRef), Cache$.MODULE$.SchemaCache(), new Serializable(this, tableRef){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final TableReference tableRef$1;

            public final TableSchema apply() {
                return this.$outer.table(this.tableRef$1).getSchema();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableRef$1 = tableRef$1;
            }
        }, Cache$Read$.MODULE$.readTableSchema(), Cache$Show$.MODULE$.showTableSchema());
    }

    public Schema storageReadSchema(String tableSpec, List<String> selectedFields2, Option<String> rowRestriction2) {
        return Cache$.MODULE$.getOrElse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";", ";", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableSpec, selectedFields2.mkString(","), rowRestriction2})), Cache$.MODULE$.SchemaCache(), new Serializable(this, tableSpec, selectedFields2, rowRestriction2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final String tableSpec$1;
            private final List selectedFields$1;
            private final Option rowRestriction$1;

            public final Schema apply() {
                TableReference tableRef = BigQueryHelpers.parseTableSpec((String)this.tableSpec$1);
                TableReferenceProto.TableReference.Builder tableRefProto = TableReferenceProto.TableReference.newBuilder();
                Object object = tableRef.getProjectId() == null ? BoxedUnit.UNIT : tableRefProto.setProjectId(tableRef.getProjectId());
                tableRefProto.setDatasetId(tableRef.getDatasetId()).setTableId(tableRef.getTableId()).build();
                Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(tableRefProto.build()).setReadOptions(StorageUtil$.MODULE$.tableReadOptions((List<String>)this.selectedFields$1, (Option<String>)this.rowRestriction$1)).setParent(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"projects/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project()}))).build();
                Storage.ReadSession session = this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.storage().createReadSession(request);
                return new Schema.Parser().parse(session.getAvroSchema().getSchema());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableSpec$1 = tableSpec$1;
                this.selectedFields$1 = selectedFields$1;
                this.rowRestriction$1 = rowRestriction$1;
            }
        }, Cache$Read$.MODULE$.readAvroSchema(), Cache$Show$.MODULE$.showAvroSchema());
    }

    public List<String> storageReadSchema$default$2() {
        return Nil$.MODULE$;
    }

    public Option<String> storageReadSchema$default$3() {
        return None$.MODULE$;
    }

    public com.google.api.services.bigquery.model.Table table(String tableSpec) {
        return this.table(BigQueryHelpers.parseTableSpec((String)tableSpec));
    }

    public com.google.api.services.bigquery.model.Table table(TableReference tableRef) {
        String p = (String)Option$.MODULE$.apply((Object)tableRef.getProjectId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;

            public final String apply() {
                return this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (com.google.api.services.bigquery.model.Table)this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().tables().get(p, tableRef.getDatasetId(), tableRef.getTableId()).execute();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TableReference> tableReferences(String projectId, String datasetId) {
        Builder b = Seq$.MODULE$.newBuilder();
        Bigquery.Tables.List req = this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().tables().list(projectId, datasetId);
        TableList rep = (TableList)req.execute();
        Option$.MODULE$.apply((Object)rep.getTables()).foreach((Function1)new Serializable(this, b){
            public static final long serialVersionUID = 0L;
            public final Builder b$1;

            public final void apply(java.util.List<TableList.Tables> x$1) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$tableReferences$1 $outer;

                    public final Builder<TableReference, Seq<TableReference>> apply(TableList.Tables x$2) {
                        return this.$outer.b$1.$plus$eq((Object)x$2.getTableReference());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.b$1 = b$1;
            }
        });
        while (rep.getNextPageToken() != null) {
            void var3_3;
            TableList tableList;
            void var4_4;
            tableList = (TableList)var4_4.setPageToken(tableList.getNextPageToken()).execute();
            Option$.MODULE$.apply((Object)tableList.getTables()).foreach((Function1)new Serializable(this, (Builder)var3_3){
                public static final long serialVersionUID = 0L;
                public final Builder b$1;

                public final void apply(java.util.List<TableList.Tables> x$3) {
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$tableReferences$2 $outer;

                        public final Builder<TableReference, Seq<TableReference>> apply(TableList.Tables x$4) {
                            return this.$outer.b$1.$plus$eq((Object)x$4.getTableReference());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.b$1 = b$1;
                }
            });
        }
        return (Seq)b.result();
    }

    public void create(com.google.api.services.bigquery.model.Table table2) {
        this.withBigQueryService((Function1)new Serializable(this, table2){
            public static final long serialVersionUID = 0L;
            private final com.google.api.services.bigquery.model.Table table$1;

            public final void apply(BigQueryServicesWrapper x$5) {
                x$5.createTable(this.table$1);
            }
            {
                this.table$1 = table$1;
            }
        });
    }

    public void create(TableReference table2, TableSchema schema2) {
        this.create(new com.google.api.services.bigquery.model.Table().setTableReference(table2).setSchema(schema2));
    }

    public void create(String tableSpec, TableSchema schema2) {
        this.create(BigQueryHelpers.parseTableSpec((String)tableSpec), schema2);
    }

    public boolean exists(TableReference tableRef) {
        Throwable throwable;
        Throwable throwable22;
        block3: {
            boolean bl;
            try {
                this.table(tableRef);
                bl = true;
            }
            catch (Throwable throwable22) {
                boolean bl2;
                throwable = throwable22;
                if (!(throwable instanceof GoogleJsonResponseException)) break block3;
                GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)throwable;
                String string = ((GoogleJsonError.ErrorInfo)googleJsonResponseException.getDetails().getErrors().get(0)).getReason();
                String string2 = "notFound";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
                bl = bl2 = false;
            }
            return bl;
        }
        if (throwable != null) {
            Throwable throwable3 = throwable;
            throw throwable3;
        }
        throw throwable22;
    }

    public boolean exists(String tableSpec) {
        return this.exists(BigQueryHelpers.parseTableSpec((String)tableSpec));
    }

    public long writeRows(TableReference tableReference, List<TableRow> rows2, TableSchema schema2, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition) {
        return BoxesRunTime.unboxToLong(this.withBigQueryService((Function1)new Serializable(this, tableReference, rows2, schema2, writeDisposition, createDisposition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final TableReference tableReference$1;
            private final List rows$1;
            private final TableSchema schema$1;
            private final BigQueryIO.Write.WriteDisposition writeDisposition$1;
            private final BigQueryIO.Write.CreateDisposition createDisposition$1;

            public final long apply(BigQueryServicesWrapper service) {
                BigQueryIO.Write.WriteDisposition writeDisposition;
                block7: {
                    block5: {
                        block6: {
                            block4: {
                                com.google.api.services.bigquery.model.Table table2 = new com.google.api.services.bigquery.model.Table().setTableReference(this.tableReference$1).setSchema(this.schema$1);
                                BigQueryIO.Write.CreateDisposition createDisposition = this.createDisposition$1;
                                BigQueryIO.Write.CreateDisposition createDisposition2 = BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED;
                                if (!(createDisposition != null ? !createDisposition.equals(createDisposition2) : createDisposition2 != null)) {
                                    service.createTable(table2);
                                }
                                if (!BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.equals(writeDisposition = this.writeDisposition$1)) break block4;
                                this.$outer.delete(this.tableReference$1);
                                service.createTable(table2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block5;
                            }
                            if (!BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.equals(writeDisposition)) break block6;
                            Predef$.MODULE$.require(service.isTableEmpty(this.tableReference$1));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block5;
                        }
                        if (!BigQueryIO.Write.WriteDisposition.WRITE_APPEND.equals(writeDisposition)) break block7;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return service.insertAll(this.tableReference$1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.rows$1).asJava());
                }
                throw new MatchError((Object)writeDisposition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableReference$1 = tableReference$1;
                this.rows$1 = rows$1;
                this.schema$1 = schema$1;
                this.writeDisposition$1 = writeDisposition$1;
                this.createDisposition$1 = createDisposition$1;
            }
        }));
    }

    public long writeRows(String tableSpec, List<TableRow> rows2, TableSchema schema2, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition) {
        return this.writeRows(BigQueryHelpers.parseTableSpec((String)tableSpec), rows2, schema2, writeDisposition, createDisposition);
    }

    public TableSchema writeRows$default$3() {
        return null;
    }

    public BigQueryIO.Write.WriteDisposition writeRows$default$4() {
        return BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
    }

    public BigQueryIO.Write.CreateDisposition writeRows$default$5() {
        return BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withBigQueryService(Function1<BigQueryServicesWrapper, T> f) {
        Object object;
        BigQueryOptions options = (BigQueryOptions)PipelineOptionsFactory.create().as(BigQueryOptions.class);
        options.setProject(this.com$spotify$scio$bigquery$client$TableOps$$client.project());
        options.setGcpCredential(this.com$spotify$scio$bigquery$client$TableOps$$client.credentials());
        try {
            object = f.apply((Object)new BigQueryServicesWrapper(options));
        }
        catch (Throwable throwable) {
            void var2_2;
            Option$.MODULE$.apply((Object)((GcsOptions)var2_2.as(GcsOptions.class)).getExecutorService()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ExecutorService x$6) {
                    x$6.shutdown();
                }
            });
            throw throwable;
        }
        Option$.MODULE$.apply((Object)((GcsOptions)options.as(GcsOptions.class)).getExecutorService()).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        return (T)object;
    }

    public void delete(TableReference table2) {
        this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().tables().delete(table2.getProjectId(), table2.getDatasetId(), table2.getTableId()).execute();
    }

    public void prepareStagingDataset(String location) {
        Throwable throwable;
        Throwable throwable22;
        block3: {
            String datasetId = this.stagingDatasetId(location);
            try {
                this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().datasets().get(this.com$spotify$scio$bigquery$client$TableOps$$client.project(), datasetId).execute();
                TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Staging dataset ", ":", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$spotify$scio$bigquery$client$TableOps$$client.project(), datasetId})));
            }
            catch (Throwable throwable22) {
                GoogleJsonResponseException googleJsonResponseException;
                throwable = throwable22;
                if (!(throwable instanceof GoogleJsonResponseException) || !ApiErrorExtractor.INSTANCE.itemNotFound((IOException)(googleJsonResponseException = (GoogleJsonResponseException)throwable))) break block3;
                TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$Logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating staging dataset ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$spotify$scio$bigquery$client$TableOps$$client.project(), datasetId})));
                DatasetReference dsRef = new DatasetReference().setProjectId(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).setDatasetId(datasetId);
                Dataset ds = new Dataset().setDatasetReference(dsRef).setDefaultTableExpirationMs(Predef$.MODULE$.long2Long(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$StagingDatasetTableExpirationMs())).setDescription(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$StagingDatasetDescription()).setLocation(location);
                this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().datasets().insert(this.com$spotify$scio$bigquery$client$TableOps$$client.project(), ds).execute();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        Option option = NonFatal$.MODULE$.unapply(throwable);
        if (option.isEmpty()) {
            throw throwable22;
        }
        Throwable e = (Throwable)option.get();
        throw e;
    }

    public TableReference createTemporary(String location) {
        String now = Instant.now().toString(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$TimeFormatter());
        String tableId = new StringBuilder().append((Object)TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$TablePrefix()).append((Object)"_").append((Object)now).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(Integer.MAX_VALUE))).toString();
        return new TableReference().setProjectId(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).setDatasetId(this.stagingDatasetId(location)).setTableId(tableId);
    }

    private String stagingDatasetId(String location) {
        return new StringBuilder().append((Object)TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$StagingDatasetPrefix()).append((Object)location.toLowerCase().replaceAll("-", "_")).toString();
    }

    public TableOps(BigQuery.Client client) {
        this.com$spotify$scio$bigquery$client$TableOps$$client = client;
    }
}

