/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.spotify.scio.bigquery.client.BigQuery;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.util.Try$;

public final class BigQueryPartitionUtil$ {
    public static final BigQueryPartitionUtil$ MODULE$ = new BigQueryPartitionUtil$();
    private static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final String DATASET_REGEXP;
    private static final String TABLE_REGEXP;
    private static final String DATASET_TABLE_REGEXP_LEGACY;
    private static final String DATASET_TABLE_REGEXP_STANDARD;
    private static final Pattern QUERY_TABLE_SPEC_LEGACY;
    private static final Pattern QUERY_TABLE_SPEC_STANDARD;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        DATASET_REGEXP = "[-\\w.]{1,1024}";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        TABLE_REGEXP = "[-\\w$@]{1,1024}($LATEST)?";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        DATASET_TABLE_REGEXP_LEGACY = new StringBuilder(40).append("((?<PROJECT>").append(PROJECT_ID_REGEXP).append("):)?(?<DATASET>").append(DATASET_REGEXP).append(")\\.(?<TABLE>").append(TABLE_REGEXP).append(")").toString();
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        DATASET_TABLE_REGEXP_STANDARD = new StringBuilder(40).append("((?<PROJECT>").append(PROJECT_ID_REGEXP).append(").)?(?<DATASET>").append(DATASET_REGEXP).append(")\\.(?<TABLE>").append(TABLE_REGEXP).append(")").toString();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        QUERY_TABLE_SPEC_LEGACY = Pattern.compile(new StringBuilder(13).append("(?<=\\[)").append(DATASET_TABLE_REGEXP_LEGACY).append("(?=\\])").toString());
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
        QUERY_TABLE_SPEC_STANDARD = Pattern.compile(new StringBuilder(13).append("(?<=\\`)").append(DATASET_TABLE_REGEXP_STANDARD).append("(?=\\`)").toString());
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x40);
    }

    private Map<String, TableReference> extractTables(String sqlQuery) {
        Builder b = Predef$.MODULE$.Map().newBuilder();
        Matcher m1 = QUERY_TABLE_SPEC_LEGACY.matcher(sqlQuery);
        while (m1.find()) {
            String t = m1.group(0);
            b.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(2).append("[").append(t).append("]").toString()), (Object)BigQueryHelpers.parseTableSpec((String)t)));
        }
        Matcher m2 = QUERY_TABLE_SPEC_STANDARD.matcher(sqlQuery);
        while (m2.find()) {
            String t = m2.group(0);
            b.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(2).append("`").append(t).append("`").toString()), (Object)BigQueryHelpers.parseTableSpec((String)t.replaceFirst("\\.", ":"))));
        }
        return (Map)b.result();
    }

    public Set<String> com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(BigQuery bq, TableReference tableRef) {
        String prefix = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(tableRef.getTableId()), '$')[0];
        return (Set)((IterableOnceOps)((IterableOps)bq.tables().tableReferences(tableRef.getProjectId(), tableRef.getDatasetId()).filter((Function1)new Serializable(prefix){
            private static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(TableReference x$1) {
                return x$1.getTableId().startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        })).map((Function1)new Serializable(prefix){
            private static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final String apply(TableReference x$2) {
                return x$2.getTableId().substring(this.prefix$1.length());
            }
            {
                this.prefix$1 = prefix$1;
            }
        })).toSet().filter((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final boolean apply(String e) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, e){
                    private static final long serialVersionUID = 0L;
                    private final String e$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(this.e$1));
                    }
                    {
                        this.e$1 = e$1;
                    }
                }).isSuccess();
            }
        });
    }

    public String latestQuery(BigQuery bq, String sqlQuery) {
        String string;
        Map tables = (Map)this.extractTables(sqlQuery).filter((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, TableReference> x$3) {
                return ((TableReference)x$3._2()).getTableId().endsWith("$LATEST");
            }
        });
        if (tables.isEmpty()) {
            string = sqlQuery;
        } else {
            Set overlaps = (Set)((IterableOnceOps)tables.map((Function1)new Serializable(bq){
                private static final long serialVersionUID = 0L;
                private final BigQuery bq$1;

                public final Set<String> apply(Tuple2<String, TableReference> t) {
                    return BigQueryPartitionUtil$.MODULE$.com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(this.bq$1, (TableReference)t._2());
                }
                {
                    this.bq$1 = bq$1;
                }
            })).reduce((Function2)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final Set<String> apply(Set<String> x$4, Set<String> x$5) {
                    return (Set)x$4.intersect(x$5);
                }
            });
            Predef$.MODULE$.require(overlaps.nonEmpty(), (Function0)new Serializable(tables){
                private static final long serialVersionUID = 0L;
                private final Map tables$1;

                public final String apply() {
                    return new StringBuilder(40).append("Cannot find latest common partition for ").append(this.tables$1.keys().mkString(", ")).toString();
                }
                {
                    this.tables$1 = tables$1;
                }
            });
            String latest = (String)overlaps.max((Ordering)Ordering.String$.MODULE$);
            string = (String)tables.foldLeft((Object)sqlQuery, (Function2)new Serializable(latest){
                private static final long serialVersionUID = 0L;
                private final String latest$1;

                public final String apply(String x0$1, Tuple2<String, TableReference> x1$1) {
                    Tuple2 tuple2;
                    String q;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2((Object)x0$1, x1$1);
                            if (tuple22 == null) break block2;
                            q = (String)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    String spec = (String)tuple2._1();
                    String string = q.replace(spec, spec.replace("$LATEST", this.latest$1));
                    return string;
                }
                {
                    this.latest$1 = latest$1;
                }
            });
        }
        return string;
    }

    public String latestTable(BigQuery bq, String tableSpec) {
        String string;
        TableReference ref = BigQueryHelpers.parseTableSpec((String)tableSpec);
        if (ref.getTableId().endsWith("$LATEST")) {
            Set<String> partitions = this.com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(bq, ref);
            Predef$.MODULE$.require(partitions.nonEmpty(), (Function0)new Serializable(tableSpec){
                private static final long serialVersionUID = 0L;
                private final String tableSpec$1;

                public final String apply() {
                    return new StringBuilder(33).append("Cannot find latest partition for ").append(this.tableSpec$1).toString();
                }
                {
                    this.tableSpec$1 = tableSpec$1;
                }
            });
            string = tableSpec.replace("$LATEST", (CharSequence)partitions.max((Ordering)Ordering.String$.MODULE$));
        } else {
            string = tableSpec;
        }
        return string;
    }

    private BigQueryPartitionUtil$() {
    }
}

