/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.spotify.scio.bigquery.BigQueryUtil$;
import com.spotify.scio.bigquery.client.AvroCompression$;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.CompressionT;
import com.spotify.scio.bigquery.client.CsvCompression$;
import com.spotify.scio.bigquery.client.ExtractJob;
import com.spotify.scio.bigquery.client.ExtractOps$;
import com.spotify.scio.bigquery.client.JobOps;
import com.spotify.scio.bigquery.client.JsonCompression$;
import com.spotify.scio.bigquery.client.NoCompressionT;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005EtA\u0002\u000b\u0016\u0011\u0003)rD\u0002\u0004\"+!\u0005QC\t\u0005\u0006S\u0005!\ta\u000b\u0005\bY\u0005\u0011\r\u0011\"\u0003.\u0011\u00191\u0014\u0001)A\u0005]\u0019)\u0011%\u0006\u0002\u0016o!Aa#\u0002B\u0001B\u0003%\u0001\b\u0003\u0005M\u000b\t\u0005\t\u0015!\u0003N\u0011\u0015IS\u0001\"\u0001Q\u0011\u0015!V\u0001\"\u0001V\u0011%\t9!BI\u0001\n\u0003\tI\u0001C\u0005\u0002 \u0015\t\n\u0011\"\u0001\u0002\"!I\u0011QE\u0003\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\b\u0003W)A\u0011AA\u0017\u0011%\ti$BI\u0001\n\u0003\ty\u0004C\u0004\u0002D\u0015!\t!!\u0012\t\u0013\u0005US!%A\u0005\u0002\u0005]\u0003bBA.\u000b\u0011%\u0011Q\f\u0005\n\u0003[*\u0011\u0013!C\u0005\u0003CA\u0011\"a\u001c\u0006#\u0003%I!a\n\u0002\u0015\u0015CHO]1di>\u00038O\u0003\u0002\u0017/\u000511\r\\5f]RT!\u0001G\r\u0002\u0011\tLw-];fefT!AG\u000e\u0002\tM\u001c\u0017n\u001c\u0006\u00039u\tqa\u001d9pi&4\u0017PC\u0001\u001f\u0003\r\u0019w.\u001c\t\u0003A\u0005i\u0011!\u0006\u0002\u000b\u000bb$(/Y2u\u001fB\u001c8CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001 \u0003\u0019aunZ4feV\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005)1\u000f\u001c45U*\t1'A\u0002pe\u001eL!!\u000e\u0019\u0003\r1{wmZ3s\u0003\u001daunZ4fe\u0002\u001a\"!B\u0012\u0011\u0005eJeB\u0001\u001eH\u001d\tYdI\u0004\u0002=\u000b:\u0011Q\b\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002\u00193%\u0011acF\u0005\u0003\u0011V\t\u0001BQ5h#V,'/_\u0005\u0003\u0015.\u0013aa\u00117jK:$(B\u0001%\u0016\u0003)QwNY*feZL7-\u001a\t\u0003A9K!aT\u000b\u0003\r){'m\u00149t)\r\t&k\u0015\t\u0003A\u0015AQA\u0006\u0005A\u0002aBQ\u0001\u0014\u0005A\u00025\u000bQ!Y:DgZ$bAV-d]bl\bC\u0001\u0013X\u0013\tAVE\u0001\u0003V]&$\b\"\u0002.\n\u0001\u0004Y\u0016aC:pkJ\u001cW\rV1cY\u0016\u0004\"\u0001\u00181\u000f\u0005us\u0006CA &\u0013\tyV%\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0&\u0011\u0015!\u0017\u00021\u0001f\u0003=!Wm\u001d;j]\u0006$\u0018n\u001c8Ve&\u001c\bc\u00014l7:\u0011q-\u001b\b\u0003\u007f!L\u0011AJ\u0005\u0003U\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002m[\n!A*[:u\u0015\tQW\u0005C\u0004p\u0013A\u0005\t\u0019\u00019\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\t\u0003cRt!\u0001\t:\n\u0005M,\u0012AD\"tm\u000e{W\u000e\u001d:fgNLwN\\\u0005\u0003kZ\u00141bQ8naJ,7o]5p]&\u0011q/\u0006\u0002\r\u0007>l\u0007O]3tg&|g\u000e\u0016\u0005\bs&\u0001\n\u00111\u0001{\u000391\u0017.\u001a7e\t\u0016d\u0017.\\5uKJ\u00042\u0001J>\\\u0013\taXE\u0001\u0004PaRLwN\u001c\u0005\b}&\u0001\n\u00111\u0001\u0000\u0003-\u0001(/\u001b8u\u0011\u0016\fG-\u001a:\u0011\t\u0011Z\u0018\u0011\u0001\t\u0004I\u0005\r\u0011bAA\u0003K\t9!i\\8mK\u0006t\u0017aD1t\u0007N4H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-!f\u00019\u0002\u000e-\u0012\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001a\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti\"a\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbg\u000e\u001bh\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019CK\u0002{\u0003\u001b\tq\"Y:DgZ$C-\u001a4bk2$H%N\u000b\u0003\u0003SQ3a`A\u0007\u0003\u0019\t7OS:p]R9a+a\f\u00022\u0005M\u0002\"\u0002.\u000e\u0001\u0004Y\u0006\"\u00023\u000e\u0001\u0004)\u0007\u0002C8\u000e!\u0003\u0005\r!!\u000e\u0011\u0007\u0005]BOD\u0002!\u0003sI1!a\u000f\u0016\u0003=Q5o\u001c8D_6\u0004(/Z:tS>t\u0017\u0001E1t\u0015N|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tE\u000b\u0003\u00026\u00055\u0011AB1t\u0003Z\u0014x\u000eF\u0004W\u0003\u000f\nI%a\u0013\t\u000bi{\u0001\u0019A.\t\u000b\u0011|\u0001\u0019A3\t\u0011=|\u0001\u0013!a\u0001\u0003\u001b\u00022!a\u0014u\u001d\r\u0001\u0013\u0011K\u0005\u0004\u0003'*\u0012aD!we>\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0002!\u0005\u001c\u0018I\u001e:pI\u0011,g-Y;mi\u0012\u001aTCAA-U\u0011\ti%!\u0004\u0002\u0017\u0015D\bo\u001c:u)\u0006\u0014G.\u001a\u000b\u000e-\u0006}\u0013\u0011MA2\u0003O\nI'a\u001b\t\u000bi\u000b\u0002\u0019A.\t\u000b\u0011\f\u0002\u0019A3\t\r\u0005\u0015\u0014\u00031\u0001\\\u0003\u00191wN]7bi\")q.\u0005a\u0001u\"9\u00110\u0005I\u0001\u0002\u0004Q\bb\u0002@\u0012!\u0003\u0005\ra`\u0001\u0016Kb\u0004xN\u001d;UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003U)\u0007\u0010]8siR\u000b'\r\\3%I\u00164\u0017-\u001e7uIY\u0002")
public final class ExtractOps {
    private final BigQuery.Client client;
    private final JobOps jobService;

    public void asCsv(String sourceTable, List<String> destinationUris, CompressionT.Compression compression, Option<String> fieldDelimiter, Option<Object> printHeader) {
        this.exportTable(sourceTable, destinationUris, "CSV", compression.name(), fieldDelimiter, printHeader);
    }

    public CompressionT.Compression asCsv$default$3() {
        return new NoCompressionT.NoCompression(CsvCompression$.MODULE$);
    }

    public Option<String> asCsv$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> asCsv$default$5() {
        return None$.MODULE$;
    }

    public void asJson(String sourceTable, List<String> destinationUris, CompressionT.Compression compression) {
        this.exportTable(sourceTable, destinationUris, "NEWLINE_DELIMITED_JSON", compression.name(), this.exportTable$default$5(), this.exportTable$default$6());
    }

    public CompressionT.Compression asJson$default$3() {
        return new NoCompressionT.NoCompression(JsonCompression$.MODULE$);
    }

    public void asAvro(String sourceTable, List<String> destinationUris, CompressionT.Compression compression) {
        this.exportTable(sourceTable, destinationUris, "AVRO", compression.name(), this.exportTable$default$5(), this.exportTable$default$6());
    }

    public CompressionT.Compression asAvro$default$3() {
        return new NoCompressionT.NoCompression(AvroCompression$.MODULE$);
    }

    private void exportTable(String sourceTable, List<String> destinationUris, String format, Option<String> compression, Option<String> fieldDelimiter, Option<Object> printHeader) {
        TableReference tableRef = BigQueryHelpers.parseTableSpec((String)sourceTable);
        JobConfigurationExtract jobConfigExtract = new JobConfigurationExtract().setSourceTable(tableRef).setDestinationUris(CollectionConverters$.MODULE$.SeqHasAsJava(destinationUris).asJava()).setDestinationFormat(format);
        compression.foreach((Function1)new Serializable(this, jobConfigExtract){
            private static final long serialVersionUID = 0L;
            private final JobConfigurationExtract jobConfigExtract$1;

            public final JobConfigurationExtract apply(String x$1) {
                return this.jobConfigExtract$1.setCompression(x$1);
            }
            {
                this.jobConfigExtract$1 = jobConfigExtract$1;
            }
        });
        fieldDelimiter.foreach((Function1)new Serializable(this, jobConfigExtract){
            private static final long serialVersionUID = 0L;
            private final JobConfigurationExtract jobConfigExtract$1;

            public final JobConfigurationExtract apply(String x$1) {
                return this.jobConfigExtract$1.setFieldDelimiter(x$1);
            }
            {
                this.jobConfigExtract$1 = jobConfigExtract$1;
            }
        });
        printHeader.foreach((Function1)new Serializable(this, jobConfigExtract){
            private static final long serialVersionUID = 0L;
            private final JobConfigurationExtract jobConfigExtract$1;

            public final JobConfigurationExtract apply(boolean x$1) {
                return this.jobConfigExtract$1.setPrintHeader(Predef$.MODULE$.boolean2Boolean(x$1));
            }
            {
                this.jobConfigExtract$1 = jobConfigExtract$1;
            }
        });
        JobConfiguration jobConfig = new JobConfiguration().setExtract(jobConfigExtract);
        String fullJobId = BigQueryUtil$.MODULE$.generateJobId(this.client.project());
        JobReference jobReference = new JobReference().setProjectId(this.client.project()).setJobId(fullJobId);
        Job job = new Job().setConfiguration(jobConfig).setJobReference(jobReference);
        ExtractOps$.MODULE$.com$spotify$scio$bigquery$client$ExtractOps$$Logger().info(new StringBuilder(21).append("Extracting table ").append(sourceTable).append(" to ").append(destinationUris.mkString(", ")).toString());
        this.client.underlying().jobs().insert(this.client.project(), job).execute();
        ExtractJob extractJob = new ExtractJob(destinationUris, (Option<JobReference>)new Some((Object)jobReference), tableRef);
        this.jobService.waitForJobs((Seq<BigQueryJob>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BigQueryJob[]{extractJob}));
    }

    private Option<String> exportTable$default$5() {
        return None$.MODULE$;
    }

    private Option<Object> exportTable$default$6() {
        return None$.MODULE$;
    }

    public ExtractOps(BigQuery.Client client, JobOps jobService) {
        this.client = client;
        this.jobService = jobService;
    }
}

