/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.spotify.scio.bigquery.StorageUtil$;
import com.spotify.scio.bigquery.Table;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.Cache$;
import com.spotify.scio.bigquery.client.Cache$Read$;
import com.spotify.scio.bigquery.client.Cache$Show$;
import com.spotify.scio.bigquery.client.TableOps$;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtilsWrapper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesWrapper;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.joda.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Random$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rErA\u0002\u00180\u0011\u0003y\u0013H\u0002\u0004<_!\u0005q\u0006\u0010\u0005\u0006\u0007\u0006!\t!\u0012\u0005\b\r\u0006\u0011\r\u0011\"\u0003H\u0011\u0019\u0001\u0016\u0001)A\u0005\u0011\"9\u0011+\u0001b\u0001\n\u0013\u0011\u0006BB.\u0002A\u0003%1\u000bC\u0004]\u0003\t\u0007I\u0011B/\t\r!\f\u0001\u0015!\u0003_\u0011\u001dI\u0017A1A\u0005\nICaA[\u0001!\u0002\u0013\u0019\u0006bB6\u0002\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0006\u0001\u000b\u0011B7\t\u000fE\f!\u0019!C\u0005%\"1!/\u0001Q\u0001\nM3QaO\u0018\u0003_MD\u0001\u0002M\b\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\u0007\u0007>!\t!!\u0005\t\u000f\u0005]q\u0002\"\u0001\u0002\u001a!9\u0011QI\b\u0005\u0002\u0005\u001d\u0003bBA1\u001f\u0011\u0005\u00111\r\u0005\b\u0003?{A\u0011AAQ\u0011\u001d\t9k\u0004C\u0001\u0003SCq!a*\u0010\t\u0003\t\u0019\u000eC\u0004\u0002`>!\t!!9\t\u0013\t\u0005q\"%A\u0005\u0002\t\r\u0001\"\u0003B\r\u001fE\u0005I\u0011\u0001B\u000e\u0011\u001d\tYd\u0004C\u0001\u0005?Aq!a\u000f\u0010\t\u0003\u00119\u0003C\u0004\u0003,=!\tA!\f\t\u000f\t-r\u0002\"\u0001\u0003>!9!1I\b\u0005\u0002\t\u0015\u0003b\u0002B\"\u001f\u0011\u0005!q\n\u0005\b\u0005\u0007zA\u0011\u0001B+\u0011\u001d\u0011Yf\u0004C\u0001\u0005;BqAa\u0017\u0010\t\u0003\u00119\u0007C\u0004\u0003l=!\tA!\u001c\t\u000f\t-t\u0002\"\u0001\u0003L\"I!q[\b\u0012\u0002\u0013\u0005!\u0011\u001c\u0005\n\u0005;|\u0011\u0013!C\u0001\u0005?D\u0011Ba9\u0010#\u0003%\tA!:\t\u0011\t%x\u0002\"\u00012\u0005WD\u0001ba\u0006\u0010\t\u0003\t4\u0011\u0004\u0005\t\u0007;yA\u0011A\u0019\u0004 !A1QE\b\u0005\u0002E\u001a9\u0003C\u0004\u0004,=!Ia!\f\u0002\u0011Q\u000b'\r\\3PaNT!\u0001M\u0019\u0002\r\rd\u0017.\u001a8u\u0015\t\u00114'\u0001\u0005cS\u001e\fX/\u001a:z\u0015\t!T'\u0001\u0003tG&|'B\u0001\u001c8\u0003\u001d\u0019\bo\u001c;jMfT\u0011\u0001O\u0001\u0004G>l\u0007C\u0001\u001e\u0002\u001b\u0005y#\u0001\u0003+bE2,w\n]:\u0014\u0005\u0005i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005I\u0014A\u0002'pO\u001e,'/F\u0001I!\tIe*D\u0001K\u0015\tYE*A\u0003tY\u001a$$NC\u0001N\u0003\ry'oZ\u0005\u0003\u001f*\u0013a\u0001T8hO\u0016\u0014\u0018a\u0002'pO\u001e,'\u000fI\u0001\f)\u0006\u0014G.\u001a)sK\u001aL\u00070F\u0001T!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003mC:<'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013aa\u0015;sS:<\u0017\u0001\u0004+bE2,\u0007K]3gSb\u0004\u0013!\u0004+j[\u00164uN]7biR,'/F\u0001_!\tyf-D\u0001a\u0015\t\t'-\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003G\u0012\fA\u0001^5nK*\u0011Q\rT\u0001\u0005U>$\u0017-\u0003\u0002hA\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\u0002\u001dQKW.\u001a$pe6\fG\u000f^3sA\u0005!2\u000b^1hS:<G)\u0019;bg\u0016$\bK]3gSb\fQc\u0015;bO&tw\rR1uCN,G\u000f\u0015:fM&D\b%A\u0010Ti\u0006<\u0017N\\4ECR\f7/\u001a;UC\ndW-\u0012=qSJ\fG/[8o\u001bN,\u0012!\u001c\t\u0003}9L!a\\ \u0003\t1{gnZ\u0001!'R\fw-\u001b8h\t\u0006$\u0018m]3u)\u0006\u0014G.Z#ya&\u0014\u0018\r^5p]6\u001b\b%A\rTi\u0006<\u0017N\\4ECR\f7/\u001a;EKN\u001c'/\u001b9uS>t\u0017AG*uC\u001eLgn\u001a#bi\u0006\u001cX\r\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:\u00043CA\b>!\r)\u00181\u0002\b\u0004m\u0006\u001dabA<\u0002\u00069\u0019\u00010a\u0001\u000f\u0007e\f\tA\u0004\u0002{\u007f:\u00111P`\u0007\u0002y*\u0011Q\u0010R\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\t\u0001\u0014'C\u0002\u0002\n=\n\u0001BQ5h#V,'/_\u0005\u0005\u0003\u001b\tyA\u0001\u0004DY&,g\u000e\u001e\u0006\u0004\u0003\u0013yC\u0003BA\n\u0003+\u0001\"AO\b\t\u000bA\n\u0002\u0019\u0001;\u0002\tI|wo\u001d\u000b\u0005\u00037\tI\u0004\u0005\u0004\u0002\u001e\u0005\u001d\u0012Q\u0006\b\u0005\u0003?\t\u0019CD\u0002|\u0003CI\u0011\u0001Q\u0005\u0004\u0003Ky\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003S\tYC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t)c\u0010\t\u0005\u0003_\t\u0019DD\u0002x\u0003cI1!!\n2\u0013\u0011\t)$a\u000e\u0003\u0011Q\u000b'\r\\3S_^T1!!\n2\u0011\u001d\tYD\u0005a\u0001\u0003{\tQ\u0001^1cY\u0016\u0004B!a\u0010\u0002B5\t\u0011'C\u0002\u0002DE\u0012Q\u0001V1cY\u0016\f\u0001\"\u0019<s_J{wo\u001d\u000b\u0005\u0003\u0013\ny\u0006\u0005\u0004\u0002\u001e\u0005\u001d\u00121\n\t\u0005\u0003\u001b\nY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\u001d9WM\\3sS\u000eTA!!\u0016\u0002X\u0005!\u0011M\u001e:p\u0015\r\tI\u0006T\u0001\u0007CB\f7\r[3\n\t\u0005u\u0013q\n\u0002\u000e\u000f\u0016tWM]5d%\u0016\u001cwN\u001d3\t\u000f\u0005m2\u00031\u0001\u0002>\u0005Y1\u000f^8sC\u001e,'k\\<t)\u0019\tY\"!\u001a\u0002h!9\u00111\b\u000bA\u0002\u0005u\u0002bBA5)\u0001\u0007\u00111N\u0001\fe\u0016\fGm\u00149uS>t7\u000f\u0005\u0003\u0002n\u0005ee\u0002BA8\u0003'sA!!\u001d\u0002\u000e:!\u00111OAD\u001d\u0011\t)(a!\u000f\t\u0005]\u0014Q\u0010\b\u0004u\u0006e\u0014bAA>o\u00051qm\\8hY\u0016LA!a \u0002\u0002\u0006)1\r\\8vI*\u0019\u00111P\u001c\n\u0007I\n)I\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0002BAE\u0003\u0017\u000bqa\u001d;pe\u0006<WMC\u00023\u0003\u000bKA!a$\u0002\u0012\u00069a/\r2fi\u0006\f$\u0002BAE\u0003\u0017KA!!&\u0002\u0018\u0006Y!+Z1e\u001fB$\u0018n\u001c8t\u0015\u0011\ty)!%\n\t\u0005m\u0015Q\u0014\u0002\u0011)\u0006\u0014G.\u001a*fC\u0012|\u0005\u000f^5p]NTA!!&\u0002\u0018\u0006y1\u000f^8sC\u001e,\u0017I\u001e:p%><8\u000f\u0006\u0004\u0002J\u0005\r\u0016Q\u0015\u0005\b\u0003w)\u0002\u0019AA\u001f\u0011\u001d\tI'\u0006a\u0001\u0003W\naa]2iK6\fG\u0003BAV\u0003\u0003\u0004B!!,\u0002>6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0003n_\u0012,GNC\u00023\u0003kSA!a.\u0002:\u0006A1/\u001a:wS\u000e,7O\u0003\u0003\u0002<\u0006\u0005\u0015aA1qS&!\u0011qXAX\u0005-!\u0016M\u00197f'\u000eDW-\\1\t\u000f\u0005\rg\u00031\u0001\u0002F\u0006IA/\u00192mKN\u0003Xm\u0019\t\u0005\u0003\u000f\fyM\u0004\u0003\u0002J\u0006-\u0007CA>@\u0013\r\timP\u0001\u0007!J,G-\u001a4\n\u0007i\u000b\tNC\u0002\u0002N~\"B!a+\u0002V\"9\u0011q[\fA\u0002\u0005e\u0017\u0001\u0003;bE2,'+\u001a4\u0011\t\u00055\u00161\\\u0005\u0005\u0003;\fyK\u0001\bUC\ndWMU3gKJ,gnY3\u0002#M$xN]1hKJ+\u0017\rZ*dQ\u0016l\u0017\r\u0006\u0005\u0002d\u0006-\u0018Q^A|!\u0011\t)/a:\u000e\u0005\u0005M\u0013\u0002BAu\u0003'\u0012aaU2iK6\f\u0007bBAb1\u0001\u0007\u0011Q\u0019\u0005\n\u0003_D\u0002\u0013!a\u0001\u0003c\fab]3mK\u000e$X\r\u001a$jK2$7\u000f\u0005\u0004\u0002\u001e\u0005M\u0018QY\u0005\u0005\u0003k\fYC\u0001\u0003MSN$\b\"CA}1A\u0005\t\u0019AA~\u00039\u0011xn\u001e*fgR\u0014\u0018n\u0019;j_:\u0004RAPA\u007f\u0003\u000bL1!a@@\u0005\u0019y\u0005\u000f^5p]\u0006Y2\u000f^8sC\u001e,'+Z1e'\u000eDW-\\1%I\u00164\u0017-\u001e7uII*\"A!\u0002+\t\u0005E(qA\u0016\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00165\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0005v]\u000eDWmY6fI*\u0019!1C \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0018\t5!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y2\u000f^8sC\u001e,'+Z1e'\u000eDW-\\1%I\u00164\u0017-\u001e7uIM*\"A!\b+\t\u0005m(q\u0001\u000b\u0005\u0005C\u0011)\u0003\u0005\u0003\u0002.\n\r\u0012\u0002BA\"\u0003_Cq!a1\u001c\u0001\u0004\t)\r\u0006\u0003\u0003\"\t%\u0002bBAl9\u0001\u0007\u0011\u0011\\\u0001\u0010i\u0006\u0014G.\u001a*fM\u0016\u0014XM\\2fgR1!q\u0006B\u001b\u0005s\u0001b!!\b\u00032\u0005e\u0017\u0002\u0002B\u001a\u0003W\u00111aU3r\u0011\u001d\u00119$\ba\u0001\u0003\u000b\f\u0011\u0002\u001d:pU\u0016\u001cG/\u00133\t\u000f\tmR\u00041\u0001\u0002F\u0006IA-\u0019;bg\u0016$\u0018\n\u001a\u000b\u0007\u0005_\u0011yD!\u0011\t\u000f\t]b\u00041\u0001\u0002|\"9!1\b\u0010A\u0002\u0005\u0015\u0017AB2sK\u0006$X\r\u0006\u0003\u0003H\t5\u0003c\u0001 \u0003J%\u0019!1J \u0003\tUs\u0017\u000e\u001e\u0005\b\u0003wy\u0002\u0019\u0001B\u0011)\u0019\u00119E!\u0015\u0003T!9\u00111\b\u0011A\u0002\u0005e\u0007bBATA\u0001\u0007\u00111\u0016\u000b\u0007\u0005\u000f\u00129F!\u0017\t\u000f\u0005\r\u0017\u00051\u0001\u0002F\"9\u0011qU\u0011A\u0002\u0005-\u0016AB3ySN$8\u000f\u0006\u0003\u0003`\t\u0015\u0004c\u0001 \u0003b%\u0019!1M \u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u001b\u0012A\u0002\u0005eG\u0003\u0002B0\u0005SBq!a1$\u0001\u0004\t)-A\u0005xe&$XMU8xgRYQNa\u001c\u0003t\t]$\u0011\u0010Ba\u0011\u001d\u0011\t\b\na\u0001\u00033\fa\u0002^1cY\u0016\u0014VMZ3sK:\u001cW\rC\u0004\u0002\u0018\u0011\u0002\rA!\u001e\u0011\r\u0005u\u00111_A\u0017\u0011\u001d\t9\u000b\na\u0001\u0003WCqAa\u001f%\u0001\u0004\u0011i(\u0001\txe&$X\rR5ta>\u001c\u0018\u000e^5p]B!!q\u0010B^\u001d\u0011\u0011\tI!.\u000f\t\t\r%q\u0016\b\u0005\u0005\u000b\u0013YK\u0004\u0003\u0003\b\n\u0015f\u0002\u0002BE\u0005?sAAa#\u0003\u001a:!!Q\u0012BK\u001d\u0011\u0011yIa%\u000f\u0007m\u0014\t*C\u0001N\u0013\r\tI\u0006T\u0005\u0005\u0005/\u000b9&\u0001\u0003cK\u0006l\u0017\u0002\u0002BN\u0005;\u000b1a\u001d3l\u0015\u0011\u00119*a\u0016\n\t\t\u0005&1U\u0001\u0003S>TAAa'\u0003\u001e&!!q\u0015BU\u0003\r97\r\u001d\u0006\u0005\u0005C\u0013\u0019+C\u00023\u0005[SAAa*\u0003*&!!\u0011\u0017BZ\u0003)\u0011\u0015nZ)vKJL\u0018j\u0014\u0006\u0004e\t5\u0016\u0002\u0002B\\\u0005s\u000bQa\u0016:ji\u0016TAA!-\u00034&!!Q\u0018B`\u0005A9&/\u001b;f\t&\u001c\bo\\:ji&|gN\u0003\u0003\u00038\ne\u0006b\u0002BbI\u0001\u0007!QY\u0001\u0012GJ,\u0017\r^3ESN\u0004xn]5uS>t\u0007\u0003\u0002B@\u0005\u000fLAA!3\u0003@\n\t2I]3bi\u0016$\u0015n\u001d9pg&$\u0018n\u001c8\u0015\u00175\u0014iMa4\u0003R\nM'Q\u001b\u0005\b\u0003\u0007,\u0003\u0019AAc\u0011\u001d\t9\"\na\u0001\u0005kB\u0011\"a*&!\u0003\u0005\r!a+\t\u0013\tmT\u0005%AA\u0002\tu\u0004\"\u0003BbKA\u0005\t\u0019\u0001Bc\u0003M9(/\u001b;f%><8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YN\u000b\u0003\u0002,\n\u001d\u0011aE<sSR,'k\\<tI\u0011,g-Y;mi\u0012\"TC\u0001BqU\u0011\u0011iHa\u0002\u0002']\u0014\u0018\u000e^3S_^\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u001d(\u0006\u0002Bc\u0005\u000f\t1c^5uQ\nKw-U;fef\u001cVM\u001d<jG\u0016,BA!<\u0003tR!!q^B\u0003!\u0011\u0011\tPa=\r\u0001\u00119!Q_\u0015C\u0002\t](!\u0001+\u0012\t\te(q \t\u0004}\tm\u0018b\u0001B\u007f\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0004\u0002%\u001911A \u0003\u0007\u0005s\u0017\u0010C\u0004\u0004\b%\u0002\ra!\u0003\u0002\u0003\u0019\u0004rAPB\u0006\u0007\u001f\u0011y/C\u0002\u0004\u000e}\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\rE11C\u0007\u0003\u0005gKAa!\u0006\u00034\n9\")[4Rk\u0016\u0014\u0018pU3sm&\u001cWm],sCB\u0004XM]\u0001\u0007I\u0016dW\r^3\u0015\t\t\u001d31\u0004\u0005\b\u0003wQ\u0003\u0019AAm\u0003U\u0001(/\u001a9be\u0016\u001cF/Y4j]\u001e$\u0015\r^1tKR$BAa\u0012\u0004\"!911E\u0016A\u0002\u0005\u0015\u0017\u0001\u00037pG\u0006$\u0018n\u001c8\u0002\u001f\r\u0014X-\u0019;f)\u0016l\u0007o\u001c:bef$B!!7\u0004*!911\u0005\u0017A\u0002\u0005\u0015\u0017\u0001E:uC\u001eLgn\u001a#bi\u0006\u001cX\r^%e)\u0011\t)ma\f\t\u000f\r\rR\u00061\u0001\u0002F\u0002")
public final class TableOps {
    public final BigQuery.Client com$spotify$scio$bigquery$client$TableOps$$client;

    public Iterator<TableRow> rows(Table table2) {
        return this.storageRows(table2, ReadOptions.TableReadOptions.getDefaultInstance());
    }

    public Iterator<GenericRecord> avroRows(Table table2) {
        return this.storageAvroRows(table2, ReadOptions.TableReadOptions.getDefaultInstance());
    }

    public Iterator<TableRow> storageRows(Table table2, ReadOptions.TableReadOptions readOptions) {
        return (Iterator)this.withBigQueryService((Function1)new Serializable(this, table2, readOptions){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final Table table$1;
            private final ReadOptions.TableReadOptions readOptions$1;

            public final Iterator<TableRow> apply(BigQueryServicesWrapper bqServices) {
                com.google.api.services.bigquery.model.Table tb = bqServices.getTable(this.table$1.ref(), (java.util.List<String>)this.readOptions$1.getSelectedFieldsList());
                return this.$outer.storageAvroRows(this.table$1, this.readOptions$1).map((Function1)new Serializable(this, tb){
                    private static final long serialVersionUID = 0L;
                    private final com.google.api.services.bigquery.model.Table tb$1;

                    public final TableRow apply(GenericRecord gr) {
                        return BigQueryAvroUtilsWrapper.convertGenericRecordToTableRow(gr, this.tb$1.getSchema());
                    }
                    {
                        this.tb$1 = tb$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$1 = table$1;
                this.readOptions$1 = readOptions$1;
            }
        });
    }

    public Iterator<GenericRecord> storageAvroRows(Table table2, ReadOptions.TableReadOptions readOptions) {
        TableReferenceProto.TableReference.Builder tableRefProto = TableReferenceProto.TableReference.newBuilder().setDatasetId(table2.ref().getDatasetId()).setTableId(table2.ref().getTableId()).setProjectId((String)Option$.MODULE$.apply((Object)table2.ref().getProjectId()).getOrElse((Function0)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;

            public final String apply() {
                return this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(tableRefProto).setReadOptions(readOptions).setParent(new StringBuilder(9).append("projects/").append(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).toString()).setRequestedStreams(1).setFormat(Storage.DataFormat.AVRO).build();
        Storage.ReadSession session = this.com$spotify$scio$bigquery$client$TableOps$$client.storage().createReadSession(request);
        Storage.ReadRowsRequest readRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(session.getStreams(0))).build();
        Schema schema2 = new Schema.Parser().parse(session.getAvroSchema().getSchema());
        GenericDatumReader reader = new GenericDatumReader(schema2);
        Iterable responses = CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)this.com$spotify$scio$bigquery$client$TableOps$$client.storage().readRowsCallable().call((Object)readRowsRequest)).asScala();
        ObjectRef decoder = ObjectRef.create(null);
        return responses.iterator().flatMap((Function1)new Serializable(this, decoder, reader){
            private static final long serialVersionUID = 0L;
            private final ObjectRef decoder$1;
            private final GenericDatumReader reader$1;

            public final Iterator<GenericRecord> apply(Storage.ReadRowsResponse resp) {
                byte[] bytes = resp.getAvroRows().getSerializedBinaryRows().toByteArray();
                this.decoder$1.elem = DecoderFactory.get().binaryDecoder(bytes, (BinaryDecoder)this.decoder$1.elem);
                ArrayBuffer res = ArrayBuffer$.MODULE$.empty();
                while (!((BinaryDecoder)this.decoder$1.elem).isEnd()) {
                    res.$plus$eq(this.reader$1.read(null, (Decoder)((BinaryDecoder)this.decoder$1.elem)));
                }
                return res.toIterator();
            }
            {
                this.decoder$1 = decoder$1;
                this.reader$1 = reader$1;
            }
        });
    }

    public TableSchema schema(String tableSpec) {
        return this.schema(BigQueryHelpers.parseTableSpec((String)tableSpec));
    }

    public TableSchema schema(TableReference tableRef) {
        return Cache$.MODULE$.getOrElse(BigQueryHelpers.toTableSpec((TableReference)tableRef), Cache$.MODULE$.SchemaCache(), new Serializable(this, tableRef){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final TableReference tableRef$1;

            public final TableSchema apply() {
                return this.$outer.table(this.tableRef$1).getSchema();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableRef$1 = tableRef$1;
            }
        }, Cache$Read$.MODULE$.readTableSchema(), Cache$Show$.MODULE$.showTableSchema());
    }

    public Schema storageReadSchema(String tableSpec, List<String> selectedFields2, Option<String> rowRestriction2) {
        return Cache$.MODULE$.getOrElse(new StringBuilder(2).append(tableSpec).append(";").append(selectedFields2.mkString(",")).append(";").append(rowRestriction2).toString(), Cache$.MODULE$.SchemaCache(), new Serializable(this, tableSpec, selectedFields2, rowRestriction2){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final String tableSpec$1;
            private final List selectedFields$1;
            private final Option rowRestriction$1;

            public final Schema apply() {
                TableReference tableRef = BigQueryHelpers.parseTableSpec((String)this.tableSpec$1);
                TableReferenceProto.TableReference.Builder tableRefProto = TableReferenceProto.TableReference.newBuilder().setProjectId((String)Option$.MODULE$.apply((Object)tableRef.getProjectId()).getOrElse((Function0)new Serializable(this){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$storageReadSchema$1 $outer;

                    public final String apply() {
                        return this.$outer.com$spotify$scio$bigquery$client$TableOps$$anonfun$$$outer().com$spotify$scio$bigquery$client$TableOps$$client.project();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).setDatasetId(tableRef.getDatasetId()).setTableId(tableRef.getTableId());
                Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(tableRefProto).setReadOptions(StorageUtil$.MODULE$.tableReadOptions((List<String>)this.selectedFields$1, (Option<String>)this.rowRestriction$1)).setParent(new StringBuilder(9).append("projects/").append(this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project()).toString()).build();
                Storage.ReadSession session = this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.storage().createReadSession(request);
                return new Schema.Parser().parse(session.getAvroSchema().getSchema());
            }

            public /* synthetic */ TableOps com$spotify$scio$bigquery$client$TableOps$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableSpec$1 = tableSpec$1;
                this.selectedFields$1 = selectedFields$1;
                this.rowRestriction$1 = rowRestriction$1;
            }
        }, Cache$Read$.MODULE$.readAvroSchema(), Cache$Show$.MODULE$.showAvroSchema());
    }

    public List<String> storageReadSchema$default$2() {
        return Nil$.MODULE$;
    }

    public Option<String> storageReadSchema$default$3() {
        return None$.MODULE$;
    }

    public com.google.api.services.bigquery.model.Table table(String tableSpec) {
        return this.table(BigQueryHelpers.parseTableSpec((String)tableSpec));
    }

    public com.google.api.services.bigquery.model.Table table(TableReference tableRef) {
        String p = (String)Option$.MODULE$.apply((Object)tableRef.getProjectId()).getOrElse((Function0)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;

            public final String apply() {
                return this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (com.google.api.services.bigquery.model.Table)this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().tables().get(p, tableRef.getDatasetId(), tableRef.getTableId()).execute();
    }

    public scala.collection.immutable.Seq<TableReference> tableReferences(String projectId, String datasetId) {
        return this.tableReferences((Option<String>)Option$.MODULE$.apply((Object)projectId), datasetId);
    }

    public scala.collection.immutable.Seq<TableReference> tableReferences(Option<String> projectId, String datasetId) {
        Builder b = Seq$.MODULE$.newBuilder();
        Bigquery.Tables.List req = this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().tables().list((String)projectId.getOrElse((Function0)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;

            public final String apply() {
                return this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), datasetId);
        TableList rep = (TableList)req.execute();
        Option$.MODULE$.apply((Object)rep.getTables()).foreach((Function1)new Serializable(this, b){
            private static final long serialVersionUID = 0L;
            public final Builder b$1;

            public final void apply(java.util.List<TableList.Tables> x$1) {
                CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala().foreach((Function1)new Serializable(this){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$tableReferences$1 $outer;

                    public final Builder<TableReference, scala.collection.immutable.Seq<TableReference>> apply(TableList.Tables x$2) {
                        return (Builder)this.$outer.b$1.$plus$eq((Object)x$2.getTableReference());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.b$1 = b$1;
            }
        });
        while (rep.getNextPageToken() != null) {
            rep = (TableList)req.setPageToken(rep.getNextPageToken()).execute();
            Option$.MODULE$.apply((Object)rep.getTables()).foreach((Function1)new Serializable(this, b){
                private static final long serialVersionUID = 0L;
                public final Builder b$1;

                public final void apply(java.util.List<TableList.Tables> x$3) {
                    CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().foreach((Function1)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$tableReferences$2 $outer;

                        public final Builder<TableReference, scala.collection.immutable.Seq<TableReference>> apply(TableList.Tables x$4) {
                            return (Builder)this.$outer.b$1.$plus$eq((Object)x$4.getTableReference());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.b$1 = b$1;
                }
            });
        }
        return (scala.collection.immutable.Seq)b.result();
    }

    public void create(com.google.api.services.bigquery.model.Table table2) {
        this.withBigQueryService((Function1)new Serializable(this, table2){
            private static final long serialVersionUID = 0L;
            private final com.google.api.services.bigquery.model.Table table$2;

            public final void apply(BigQueryServicesWrapper x$5) {
                x$5.createTable(this.table$2);
            }
            {
                this.table$2 = table$2;
            }
        });
    }

    public void create(TableReference table2, TableSchema schema2) {
        this.create(new com.google.api.services.bigquery.model.Table().setTableReference(table2).setSchema(schema2));
    }

    public void create(String tableSpec, TableSchema schema2) {
        this.create(BigQueryHelpers.parseTableSpec((String)tableSpec), schema2);
    }

    public boolean exists(TableReference tableRef) {
        boolean bl;
        try {
            this.table(tableRef);
            bl = true;
        }
        catch (Throwable throwable) {
            block7: {
                Throwable throwable2;
                block6: {
                    throwable2 = throwable;
                    if (!(throwable2 instanceof GoogleJsonResponseException)) break block6;
                    GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)throwable2;
                    String string = ((GoogleJsonError.ErrorInfo)googleJsonResponseException.getDetails().getErrors().get(0)).getReason();
                    String string2 = "notFound";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) break block7;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throw throwable3;
                }
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public boolean exists(String tableSpec) {
        return this.exists(BigQueryHelpers.parseTableSpec((String)tableSpec));
    }

    public long writeRows(TableReference tableReference, List<TableRow> rows2, TableSchema schema2, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition) {
        return BoxesRunTime.unboxToLong(this.withBigQueryService((Function1)new Serializable(this, tableReference, schema2, createDisposition, writeDisposition, rows2){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;
            private final TableReference tableReference$1;
            private final TableSchema schema$1;
            private final BigQueryIO.Write.CreateDisposition createDisposition$1;
            private final BigQueryIO.Write.WriteDisposition writeDisposition$1;
            private final List rows$1;

            public final long apply(BigQueryServicesWrapper service) {
                BigQueryIO.Write.WriteDisposition writeDisposition;
                com.google.api.services.bigquery.model.Table table2 = new com.google.api.services.bigquery.model.Table().setTableReference(this.tableReference$1).setSchema(this.schema$1);
                BigQueryIO.Write.CreateDisposition createDisposition = this.createDisposition$1;
                BigQueryIO.Write.CreateDisposition createDisposition2 = BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED;
                if (!(createDisposition != null ? !createDisposition.equals(createDisposition2) : createDisposition2 != null)) {
                    service.createTable(table2);
                }
                if (BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.equals(writeDisposition = this.writeDisposition$1)) {
                    this.$outer.delete(this.tableReference$1);
                    service.createTable(table2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.equals(writeDisposition)) {
                    Predef$.MODULE$.require(service.isTableEmpty(this.tableReference$1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (BigQueryIO.Write.WriteDisposition.WRITE_APPEND.equals(writeDisposition)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)writeDisposition);
                }
                return service.insertAll(this.tableReference$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.rows$1).asJava());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableReference$1 = tableReference$1;
                this.schema$1 = schema$1;
                this.createDisposition$1 = createDisposition$1;
                this.writeDisposition$1 = writeDisposition$1;
                this.rows$1 = rows$1;
            }
        }));
    }

    public long writeRows(String tableSpec, List<TableRow> rows2, TableSchema schema2, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition) {
        return this.writeRows(BigQueryHelpers.parseTableSpec((String)tableSpec), rows2, schema2, writeDisposition, createDisposition);
    }

    public TableSchema writeRows$default$3() {
        return null;
    }

    public BigQueryIO.Write.WriteDisposition writeRows$default$4() {
        return BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
    }

    public BigQueryIO.Write.CreateDisposition writeRows$default$5() {
        return BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED;
    }

    public <T> T withBigQueryService(Function1<BigQueryServicesWrapper, T> f) {
        Object object;
        BigQueryOptions options = (BigQueryOptions)PipelineOptionsFactory.create().as(BigQueryOptions.class);
        options.setProject(this.com$spotify$scio$bigquery$client$TableOps$$client.project());
        options.setGcpCredential(this.com$spotify$scio$bigquery$client$TableOps$$client.credentials());
        try {
            object = f.apply((Object)new BigQueryServicesWrapper(options));
        }
        catch (Throwable throwable) {
            Option$.MODULE$.apply((Object)((GcsOptions)options.as(GcsOptions.class)).getExecutorService()).foreach((Function1)new Serializable(this){
                private static final long serialVersionUID = 0L;

                public final void apply(ExecutorService x$6) {
                    x$6.shutdown();
                }
            });
            throw throwable;
        }
        Option$.MODULE$.apply((Object)((GcsOptions)options.as(GcsOptions.class)).getExecutorService()).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        return (T)object;
    }

    public void delete(TableReference table2) {
        this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().tables().delete((String)Option$.MODULE$.apply((Object)table2.getProjectId()).getOrElse((Function0)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TableOps $outer;

            public final String apply() {
                return this.$outer.com$spotify$scio$bigquery$client$TableOps$$client.project();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), table2.getDatasetId(), table2.getTableId()).execute();
    }

    public void prepareStagingDataset(String location) {
        String datasetId = this.stagingDatasetId(location);
        try {
            this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().datasets().get(this.com$spotify$scio$bigquery$client$TableOps$$client.project(), datasetId).execute();
            TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$Logger().info(new StringBuilder(32).append("Staging dataset ").append(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).append(":").append(datasetId).append(" already exists").toString());
        }
        catch (Throwable throwable) {
            Option option;
            GoogleJsonResponseException googleJsonResponseException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof GoogleJsonResponseException && ApiErrorExtractor.INSTANCE.itemNotFound((IOException)(googleJsonResponseException = (GoogleJsonResponseException)throwable2))) {
                TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$Logger().info(new StringBuilder(26).append("Creating staging dataset ").append(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).append(":").append(datasetId).toString());
                DatasetReference dsRef = new DatasetReference().setProjectId(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).setDatasetId(datasetId);
                Dataset ds = new Dataset().setDatasetReference(dsRef).setDefaultTableExpirationMs(Predef$.MODULE$.long2Long(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$StagingDatasetTableExpirationMs())).setDescription(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$StagingDatasetDescription()).setLocation(location);
                this.com$spotify$scio$bigquery$client$TableOps$$client.underlying().datasets().insert(this.com$spotify$scio$bigquery$client$TableOps$$client.project(), ds).execute();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw e;
            }
            throw throwable;
        }
    }

    public TableReference createTemporary(String location) {
        String now = Instant.now().toString(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$TimeFormatter());
        String tableId = new StringBuilder(2).append(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$TablePrefix()).append("_").append(now).append("_").append(Random$.MODULE$.nextInt(Integer.MAX_VALUE)).toString();
        return new TableReference().setProjectId(this.com$spotify$scio$bigquery$client$TableOps$$client.project()).setDatasetId(this.stagingDatasetId(location)).setTableId(tableId);
    }

    private String stagingDatasetId(String location) {
        return new StringBuilder(0).append(TableOps$.MODULE$.com$spotify$scio$bigquery$client$TableOps$$StagingDatasetPrefix()).append(location.toLowerCase().replaceAll("-", "_")).toString();
    }

    public TableOps(BigQuery.Client client) {
        this.com$spotify$scio$bigquery$client$TableOps$$client = client;
    }
}

