/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class DataType {
    protected final Name name;
    private static final Map<Name, DataType> primitiveTypeMap = new EnumMap<Name, DataType>(Name.class);
    private static final Set<DataType> primitiveTypeSet;

    protected DataType(Name name) {
        this.name = name;
    }

    static DataType decode(ByteBuf byteBuf) {
        Name name = Name.fromProtocolId(byteBuf.readUnsignedShort());
        switch (name) {
            case CUSTOM: {
                String string = CBUtil.readString((ByteBuf)byteBuf);
                return CassandraTypeParser.isUserType((String)string) || CassandraTypeParser.isTupleType((String)string) ? CassandraTypeParser.parseOne((String)string) : DataType.custom(string);
            }
            case LIST: {
                return DataType.list(DataType.decode(byteBuf));
            }
            case SET: {
                return DataType.set(DataType.decode(byteBuf));
            }
            case MAP: {
                DataType dataType = DataType.decode(byteBuf);
                DataType dataType2 = DataType.decode(byteBuf);
                return DataType.map(dataType, dataType2);
            }
            case UDT: {
                String string = CBUtil.readString((ByteBuf)byteBuf);
                String string2 = CBUtil.readString((ByteBuf)byteBuf);
                int n = byteBuf.readShort() & 0xFFFF;
                ArrayList<UserType.Field> arrayList = new ArrayList<UserType.Field>(n);
                for (int i = 0; i < n; ++i) {
                    String string3 = CBUtil.readString((ByteBuf)byteBuf);
                    DataType dataType = DataType.decode(byteBuf);
                    arrayList.add(new UserType.Field(string3, dataType));
                }
                return new UserType(string, string2, arrayList);
            }
            case TUPLE: {
                int n = byteBuf.readShort() & 0xFFFF;
                ArrayList<DataType> arrayList = new ArrayList<DataType>(n);
                for (int i = 0; i < n; ++i) {
                    arrayList.add(DataType.decode(byteBuf));
                }
                return new TupleType(arrayList);
            }
        }
        return primitiveTypeMap.get((Object)name);
    }

    abstract TypeCodec<Object> codec(ProtocolVersion var1);

    public static DataType ascii() {
        return primitiveTypeMap.get((Object)Name.ASCII);
    }

    public static DataType bigint() {
        return primitiveTypeMap.get((Object)Name.BIGINT);
    }

    public static DataType blob() {
        return primitiveTypeMap.get((Object)Name.BLOB);
    }

    public static DataType cboolean() {
        return primitiveTypeMap.get((Object)Name.BOOLEAN);
    }

    public static DataType counter() {
        return primitiveTypeMap.get((Object)Name.COUNTER);
    }

    public static DataType decimal() {
        return primitiveTypeMap.get((Object)Name.DECIMAL);
    }

    public static DataType cdouble() {
        return primitiveTypeMap.get((Object)Name.DOUBLE);
    }

    public static DataType cfloat() {
        return primitiveTypeMap.get((Object)Name.FLOAT);
    }

    public static DataType inet() {
        return primitiveTypeMap.get((Object)Name.INET);
    }

    public static DataType cint() {
        return primitiveTypeMap.get((Object)Name.INT);
    }

    public static DataType text() {
        return primitiveTypeMap.get((Object)Name.TEXT);
    }

    public static DataType timestamp() {
        return primitiveTypeMap.get((Object)Name.TIMESTAMP);
    }

    public static DataType uuid() {
        return primitiveTypeMap.get((Object)Name.UUID);
    }

    public static DataType varchar() {
        return primitiveTypeMap.get((Object)Name.VARCHAR);
    }

    public static DataType varint() {
        return primitiveTypeMap.get((Object)Name.VARINT);
    }

    public static DataType timeuuid() {
        return primitiveTypeMap.get((Object)Name.TIMEUUID);
    }

    public static DataType list(DataType dataType, boolean bl) {
        return new Collection(Name.LIST, (List)ImmutableList.of((Object)dataType), bl);
    }

    public static DataType list(DataType dataType) {
        return DataType.list(dataType, false);
    }

    public static DataType frozenList(DataType dataType) {
        return DataType.list(dataType, true);
    }

    public static DataType set(DataType dataType, boolean bl) {
        return new Collection(Name.SET, (List)ImmutableList.of((Object)dataType), bl);
    }

    public static DataType set(DataType dataType) {
        return DataType.set(dataType, false);
    }

    public static DataType frozenSet(DataType dataType) {
        return DataType.set(dataType, true);
    }

    public static DataType map(DataType dataType, DataType dataType2, boolean bl) {
        return new Collection(Name.MAP, (List)ImmutableList.of((Object)dataType, (Object)dataType2), bl);
    }

    public static DataType map(DataType dataType, DataType dataType2) {
        return DataType.map(dataType, dataType2, false);
    }

    public static DataType frozenMap(DataType dataType, DataType dataType2) {
        return DataType.map(dataType, dataType2, true);
    }

    public static DataType custom(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Custom(Name.CUSTOM, string);
    }

    public Name getName() {
        return this.name;
    }

    public abstract boolean isFrozen();

    public List<DataType> getTypeArguments() {
        return Collections.emptyList();
    }

    abstract boolean canBeDeserializedAs(TypeToken var1);

    public String getCustomTypeClassName() {
        return null;
    }

    public Object parse(String string) {
        return string == null ? null : this.codec(ProtocolVersion.NEWEST_SUPPORTED).parse(string);
    }

    public String format(Object object) {
        return object == null ? null : this.codec(ProtocolVersion.NEWEST_SUPPORTED).format(object);
    }

    public boolean isCollection() {
        return this.name.isCollection();
    }

    public Class<?> asJavaClass() {
        return this.getName().asJavaClass();
    }

    public static Set<DataType> allPrimitiveTypes() {
        return primitiveTypeSet;
    }

    public ByteBuffer serialize(Object object, ProtocolVersion protocolVersion) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = this.asJavaClass();
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new InvalidTypeException(String.format("Invalid value for CQL type %s, expecting %s but %s provided", this.toString(), clazz2, clazz));
        }
        try {
            return this.codec(protocolVersion).serialize(object);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidTypeException("Invalid type for collection element: " + classCastException.getMessage());
        }
    }

    @Deprecated
    public ByteBuffer serialize(Object object, int n) {
        return this.serialize(object, ProtocolVersion.fromInt((int)n));
    }

    @Deprecated
    public ByteBuffer serialize(Object object) {
        throw new UnsupportedOperationException("Method no longer supported; use serialize(Object,ProtocolVersion)");
    }

    public Object deserialize(ByteBuffer byteBuffer, ProtocolVersion protocolVersion) {
        return this.codec(protocolVersion).deserialize(byteBuffer);
    }

    public Object deserialize(ByteBuffer byteBuffer, int n) {
        return this.deserialize(byteBuffer, ProtocolVersion.fromInt((int)n));
    }

    @Deprecated
    public Object deserialize(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Method no longer supported; use deserialize(ByteBuffer,ProtocolVersion)");
    }

    public static ByteBuffer serializeValue(Object object, ProtocolVersion protocolVersion) {
        if (object == null) {
            return null;
        }
        try {
            DataType dataType = TypeCodec.getDataTypeFor((Object)object);
            return dataType.serialize(object, protocolVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Could not serialize value of type %s", object.getClass()), illegalArgumentException);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalArgumentException(invalidTypeException.getMessage());
        }
    }

    @Deprecated
    public static ByteBuffer serializeValue(Object object, int n) {
        return DataType.serializeValue(object, ProtocolVersion.fromInt((int)n));
    }

    @Deprecated
    public static ByteBuffer serializeValue(Object object) {
        throw new UnsupportedOperationException("Method no longer supported; use serializeValue(Object,ProtocolVersion)");
    }

    static {
        for (Name name : Name.values()) {
            if (name.isCollection() || name == Name.CUSTOM || name == Name.UDT || name == Name.TUPLE) continue;
            primitiveTypeMap.put(name, new Native(name));
        }
        primitiveTypeSet = ImmutableSet.copyOf(primitiveTypeMap.values());
    }

    private static class Custom
    extends DataType {
        private final String customClassName;

        private Custom(Name name, String string) {
            super(name);
            this.customClassName = string;
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        @Override
        boolean canBeDeserializedAs(TypeToken typeToken) {
            return typeToken.getRawType().getName().equals(this.customClassName);
        }

        @Override
        TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
            return TypeCodec.bytesCodec;
        }

        @Override
        public String getCustomTypeClassName() {
            return this.customClassName;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.customClassName});
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Custom)) {
                return false;
            }
            Custom custom = (Custom)object;
            return this.name == custom.name && Objects.equal((Object)this.customClassName, (Object)custom.customClassName);
        }

        public String toString() {
            return String.format("'%s'", this.customClassName);
        }
    }

    private static class Collection
    extends DataType {
        private final List<DataType> typeArguments;
        private boolean frozen;

        private Collection(Name name, List<DataType> list, boolean bl) {
            super(name);
            this.typeArguments = list;
            this.frozen = bl;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        boolean canBeDeserializedAs(TypeToken typeToken) {
            switch (this.name) {
                case LIST: {
                    return typeToken.getRawType().isAssignableFrom(List.class) && this.typeArguments.get(0).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[0]));
                }
                case SET: {
                    return typeToken.getRawType().isAssignableFrom(Set.class) && this.typeArguments.get(0).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[0]));
                }
                case MAP: {
                    return typeToken.getRawType().isAssignableFrom(Map.class) && this.typeArguments.get(0).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[0])) && this.typeArguments.get(1).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[1]));
                }
            }
            throw new AssertionError();
        }

        @Override
        TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
            switch (this.name) {
                case LIST: {
                    return TypeCodec.listOf((DataType)this.typeArguments.get(0), (ProtocolVersion)protocolVersion);
                }
                case SET: {
                    return TypeCodec.setOf((DataType)this.typeArguments.get(0), (ProtocolVersion)protocolVersion);
                }
                case MAP: {
                    return TypeCodec.mapOf((DataType)this.typeArguments.get(0), (DataType)this.typeArguments.get(1), (ProtocolVersion)protocolVersion);
                }
            }
            throw new AssertionError();
        }

        @Override
        public List<DataType> getTypeArguments() {
            return this.typeArguments;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.typeArguments});
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Collection)) {
                return false;
            }
            Collection collection = (Collection)object;
            return this.name == collection.name && this.typeArguments.equals(collection.typeArguments);
        }

        public String toString() {
            if (this.name == Name.MAP) {
                String string = this.frozen ? "frozen<%s<%s, %s>>" : "%s<%s, %s>";
                return String.format(string, new Object[]{this.name, this.typeArguments.get(0), this.typeArguments.get(1)});
            }
            String string = this.frozen ? "frozen<%s<%s>>" : "%s<%s>";
            return String.format(string, new Object[]{this.name, this.typeArguments.get(0)});
        }
    }

    private static class Native
    extends DataType {
        private Native(Name name) {
            super(name);
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        @Override
        boolean canBeDeserializedAs(TypeToken typeToken) {
            return typeToken.isSupertypeOf(this.getName().javaType);
        }

        @Override
        TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
            return TypeCodec.createFor((Name)this.name);
        }

        public final int hashCode() {
            return this.name == Name.TEXT ? Name.VARCHAR.hashCode() : this.name.hashCode();
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Native)) {
                return false;
            }
            Native native_ = (Native)object;
            return this.name == native_.name || this.name == Name.VARCHAR && native_.name == Name.TEXT || this.name == Name.TEXT && native_.name == Name.VARCHAR;
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static enum Name {
        ASCII(1, String.class),
        BIGINT(2, Long.class),
        BLOB(3, ByteBuffer.class),
        BOOLEAN(4, Boolean.class),
        COUNTER(5, Long.class),
        DECIMAL(6, BigDecimal.class),
        DOUBLE(7, Double.class),
        FLOAT(8, Float.class),
        INET(16, InetAddress.class),
        INT(9, Integer.class),
        TEXT(10, String.class),
        TIMESTAMP(11, Date.class),
        UUID(12, UUID.class),
        VARCHAR(13, String.class),
        VARINT(14, BigInteger.class),
        TIMEUUID(15, UUID.class),
        LIST(32, List.class),
        SET(34, Set.class),
        MAP(33, Map.class),
        UDT(48, UDTValue.class),
        TUPLE(49, TupleValue.class),
        CUSTOM(0, ByteBuffer.class);

        final int protocolId;
        final Class<?> javaType;
        private static final Name[] nameToIds;

        private Name(int n2, Class<?> clazz) {
            this.protocolId = n2;
            this.javaType = clazz;
        }

        static Name fromProtocolId(int n) {
            Name name = nameToIds[n];
            if (name == null) {
                throw new DriverInternalError("Unknown data type protocol id: " + n);
            }
            return name;
        }

        public boolean isCollection() {
            switch (this) {
                case LIST: 
                case SET: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }

        public Class<?> asJavaClass() {
            return this.javaType;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        static {
            int n = -1;
            for (Name name : Name.values()) {
                n = Math.max(n, name.protocolId);
            }
            nameToIds = new Name[n + 1];
            for (Name name : Name.values()) {
                if (nameToIds[name.protocolId] != null) {
                    throw new IllegalStateException("Duplicate Id");
                }
                Name.nameToIds[name.protocolId] = name;
            }
        }
    }
}

