/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HostConnectionPool
implements Connection.Owner {
    private static final Logger logger = LoggerFactory.getLogger(HostConnectionPool.class);
    private static final int MAX_SIMULTANEOUS_CREATION = 1;
    final Host host;
    volatile HostDistance hostDistance;
    protected final SessionManager manager;
    final List<Connection> connections;
    private final AtomicInteger open;
    final AtomicInteger totalInFlight = new AtomicInteger();
    private final AtomicInteger maxTotalInFlight = new AtomicInteger();
    @VisibleForTesting
    final Set<Connection> trash = new CopyOnWriteArraySet<Connection>();
    private volatile int waiter = 0;
    private final Lock waitLock = new ReentrantLock(true);
    private final Condition hasAvailableConnection = this.waitLock.newCondition();
    private final Runnable newConnectionTask;
    private final AtomicInteger scheduledForCreation = new AtomicInteger();
    protected final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    protected final AtomicReference<Phase> phase = new AtomicReference<Phase>(Phase.INITIALIZING);
    private final int minAllowedStreams;

    public HostConnectionPool(Host host, HostDistance hostDistance, SessionManager sessionManager) {
        assert (hostDistance != HostDistance.IGNORED);
        this.host = host;
        this.hostDistance = hostDistance;
        this.manager = sessionManager;
        this.newConnectionTask = new Runnable(){

            @Override
            public void run() {
                HostConnectionPool.this.addConnectionIfUnderMaximum();
                HostConnectionPool.this.scheduledForCreation.decrementAndGet();
            }
        };
        this.connections = new CopyOnWriteArrayList<Connection>();
        this.open = new AtomicInteger();
        this.minAllowedStreams = this.options().getMaxRequestsPerConnection(hostDistance) * 3 / 4;
    }

    ListenableFuture<Void> initAsync(Connection connection) {
        Connection connection22;
        Executor executor = this.manager.cluster.manager.configuration.getPoolingOptions().getInitializationExecutor();
        int n = this.options().getCoreConnectionsPerHost(this.hostDistance);
        final ArrayList arrayList = Lists.newArrayListWithCapacity((int)n);
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)n);
        int n2 = n;
        if (connection != null && connection.setOwner(this)) {
            --n2;
            arrayList.add(connection);
            arrayList2.add(MoreFutures.VOID_SUCCESS);
        }
        List<Connection> list = this.manager.connectionFactory().newConnections(this, n2);
        arrayList.addAll(list);
        for (Connection connection22 : list) {
            ListenableFuture<Void> listenableFuture = connection22.initAsync();
            arrayList2.add(this.handleErrors(listenableFuture, executor));
        }
        ListenableFuture listenableFuture = Futures.allAsList((Iterable)arrayList2);
        connection22 = SettableFuture.create();
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<List<Void>>((SettableFuture)connection22, n){
            final /* synthetic */ SettableFuture val$initFuture;
            final /* synthetic */ int val$coreSize;
            {
                this.val$initFuture = settableFuture;
                this.val$coreSize = n;
            }

            public void onSuccess(List<Void> list) {
                ListIterator listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    if (!((Connection)listIterator.next()).isClosed()) continue;
                    listIterator.remove();
                }
                HostConnectionPool.this.connections.addAll(arrayList);
                HostConnectionPool.this.open.set(arrayList.size());
                if (HostConnectionPool.this.isClosed()) {
                    this.val$initFuture.setException((Throwable)new ConnectionException(HostConnectionPool.this.host.getSocketAddress(), "Pool was closed during initialization"));
                    HostConnectionPool.this.forceClose(arrayList);
                } else {
                    logger.debug("Created connection pool to host {} ({} connections needed, {} successfully opened)", new Object[]{HostConnectionPool.this.host, this.val$coreSize, arrayList.size()});
                    HostConnectionPool.this.phase.compareAndSet(Phase.INITIALIZING, Phase.READY);
                    this.val$initFuture.set(null);
                }
            }

            public void onFailure(Throwable throwable) {
                HostConnectionPool.this.phase.compareAndSet(Phase.INITIALIZING, Phase.INIT_FAILED);
                HostConnectionPool.this.forceClose(arrayList);
                this.val$initFuture.setException(throwable);
            }
        }, (Executor)executor);
        return connection22;
    }

    private ListenableFuture<Void> handleErrors(ListenableFuture<Void> listenableFuture, Executor executor) {
        return Futures.catchingAsync(listenableFuture, Throwable.class, (AsyncFunction)new AsyncFunction<Throwable, Void>(){

            public ListenableFuture<Void> apply(@Nullable Throwable throwable) throws Exception {
                Throwables.propagateIfInstanceOf((Throwable)throwable, ClusterNameMismatchException.class);
                Throwables.propagateIfInstanceOf((Throwable)throwable, UnsupportedProtocolVersionException.class);
                Throwables.propagateIfInstanceOf((Throwable)throwable, Error.class);
                return MoreFutures.VOID_SUCCESS;
            }
        }, (Executor)executor);
    }

    private void forceClose(List<Connection> list) {
        for (Connection connection : list) {
            connection.closeAsync().force();
        }
    }

    private PoolingOptions options() {
        return this.manager.configuration().getPoolingOptions();
    }

    public Connection borrowConnection(long l, TimeUnit timeUnit) throws ConnectionException, TimeoutException {
        int n;
        int n2;
        Phase phase = this.phase.get();
        if (phase != Phase.READY) {
            throw new ConnectionException(this.host.getSocketAddress(), "Pool is " + (Object)((Object)phase));
        }
        if (this.connections.isEmpty()) {
            if (!this.host.convictionPolicy.canReconnectNow()) {
                throw new TimeoutException("Connection pool is empty, currently trying to reestablish connections");
            }
            int n3 = this.options().getCoreConnectionsPerHost(this.hostDistance);
            if (n3 == 0) {
                this.maybeSpawnNewConnection();
            } else {
                for (int i = 0; i < n3; ++i) {
                    this.scheduledForCreation.incrementAndGet();
                    this.manager.blockingExecutor().submit(this.newConnectionTask);
                }
            }
            Connection connection = this.waitForConnection(l, timeUnit);
            this.totalInFlight.incrementAndGet();
            connection.setKeyspace(this.manager.poolsState.keyspace);
            return connection;
        }
        int n4 = Integer.MAX_VALUE;
        Connection connection = null;
        for (Connection connection2 : this.connections) {
            n2 = connection2.inFlight.get();
            if (n2 >= n4) continue;
            n4 = n2;
            connection = connection2;
        }
        if (connection == null) {
            if (this.isClosed()) {
                throw new ConnectionException(this.host.getSocketAddress(), "Pool is shutdown");
            }
            connection = this.waitForConnection(l, timeUnit);
        } else {
            int n5;
            do {
                if ((n5 = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxRequestsPerConnection(this.hostDistance))) continue;
                connection = this.waitForConnection(l, timeUnit);
                break;
            } while (!connection.inFlight.compareAndSet(n5, n5 + 1));
        }
        int n6 = this.totalInFlight.incrementAndGet();
        while (n6 > (n = this.maxTotalInFlight.get()) && !this.maxTotalInFlight.compareAndSet(n, n6)) {
        }
        n = this.open.get() + this.scheduledForCreation.get();
        if (n < this.options().getCoreConnectionsPerHost(this.hostDistance)) {
            this.maybeSpawnNewConnection();
        } else if (n < this.options().getMaxConnectionsPerHost(this.hostDistance) && n6 > (n2 = (n - 1) * this.options().getMaxRequestsPerConnection(this.hostDistance) + this.options().getNewConnectionThreshold(this.hostDistance))) {
            this.maybeSpawnNewConnection();
        }
        connection.setKeyspace(this.manager.poolsState.keyspace);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAvailableConnection(long l, TimeUnit timeUnit) throws InterruptedException {
        this.waitLock.lock();
        ++this.waiter;
        try {
            this.hasAvailableConnection.await(l, timeUnit);
        }
        finally {
            --this.waiter;
            this.waitLock.unlock();
        }
    }

    private void signalAvailableConnection() {
        if (this.waiter == 0) {
            return;
        }
        this.waitLock.lock();
        try {
            this.hasAvailableConnection.signal();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private void signalAllAvailableConnection() {
        if (this.waiter == 0) {
            return;
        }
        this.waitLock.lock();
        try {
            this.hasAvailableConnection.signalAll();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private Connection waitForConnection(long l, TimeUnit timeUnit) throws ConnectionException, TimeoutException {
        if (l == 0L) {
            throw new TimeoutException("All connections are busy and pool timeout is 0");
        }
        long l2 = System.nanoTime();
        long l3 = l;
        do {
            int n;
            try {
                this.awaitAvailableConnection(l3, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                l = 0L;
            }
            if (this.isClosed()) {
                throw new ConnectionException(this.host.getSocketAddress(), "Pool is shutdown");
            }
            int n2 = Integer.MAX_VALUE;
            Connection connection = null;
            for (Connection connection2 : this.connections) {
                int n3 = connection2.inFlight.get();
                if (n3 >= n2) continue;
                n2 = n3;
                connection = connection2;
            }
            if (connection == null) continue;
            while ((n = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxRequestsPerConnection(this.hostDistance))) {
                if (!connection.inFlight.compareAndSet(n, n + 1)) continue;
                return connection;
            }
        } while ((l3 = l - Cluster.timeSince((long)l2, (TimeUnit)timeUnit)) > 0L);
        throw new TimeoutException("All connections are busy");
    }

    public void returnConnection(Connection connection) {
        connection.inFlight.decrementAndGet();
        this.totalInFlight.decrementAndGet();
        if (this.isClosed()) {
            this.close(connection);
            return;
        }
        if (connection.isDefunct()) {
            return;
        }
        if (connection.state.get() != Connection.State.TRASHED) {
            if (connection.maxAvailableStreams() < this.minAllowedStreams) {
                this.replaceConnection(connection);
            } else {
                this.signalAvailableConnection();
            }
        }
    }

    private void replaceConnection(Connection connection) {
        if (!connection.state.compareAndSet(Connection.State.OPEN, Connection.State.TRASHED)) {
            return;
        }
        this.open.decrementAndGet();
        this.maybeSpawnNewConnection();
        connection.maxIdleTime = Long.MIN_VALUE;
        this.doTrashConnection(connection);
    }

    private boolean trashConnection(Connection connection) {
        int n;
        if (!connection.state.compareAndSet(Connection.State.OPEN, Connection.State.TRASHED)) {
            return true;
        }
        do {
            if ((n = this.open.get()) > this.options().getCoreConnectionsPerHost(this.hostDistance)) continue;
            connection.state.set(Connection.State.OPEN);
            return false;
        } while (!this.open.compareAndSet(n, n - 1));
        logger.trace("Trashing {}", (Object)connection);
        connection.maxIdleTime = System.currentTimeMillis() + (long)(this.options().getIdleTimeoutSeconds() * 1000);
        this.doTrashConnection(connection);
        return true;
    }

    private void doTrashConnection(Connection connection) {
        this.connections.remove(connection);
        this.trash.add(connection);
    }

    private boolean addConnectionIfUnderMaximum() {
        int n;
        do {
            if ((n = this.open.get()) < this.options().getMaxConnectionsPerHost(this.hostDistance)) continue;
            return false;
        } while (!this.open.compareAndSet(n, n + 1));
        if (this.phase.get() != Phase.READY) {
            this.open.decrementAndGet();
            return false;
        }
        try {
            Connection connection = this.tryResurrectFromTrash();
            if (connection == null) {
                if (!this.host.convictionPolicy.canReconnectNow()) {
                    this.open.decrementAndGet();
                    return false;
                }
                logger.debug("Creating new connection on busy pool to {}", (Object)this.host);
                connection = this.manager.connectionFactory().open(this);
            }
            this.connections.add(connection);
            connection.state.compareAndSet(Connection.State.RESURRECTING, Connection.State.OPEN);
            if (this.isClosed() && !connection.isClosed()) {
                this.close(connection);
                this.open.decrementAndGet();
                return false;
            }
            this.signalAvailableConnection();
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.open.decrementAndGet();
            return false;
        }
        catch (ConnectionException connectionException) {
            this.open.decrementAndGet();
            logger.debug("Connection error to {} while creating additional connection", (Object)this.host);
            return false;
        }
        catch (AuthenticationException authenticationException) {
            this.open.decrementAndGet();
            logger.error("Authentication error while creating additional connection (error is: {})", (Object)authenticationException.getMessage());
            return false;
        }
        catch (UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
            this.open.decrementAndGet();
            logger.error("UnsupportedProtocolVersionException error while creating additional connection (error is: {})", (Object)unsupportedProtocolVersionException.getMessage());
            return false;
        }
        catch (ClusterNameMismatchException clusterNameMismatchException) {
            this.open.decrementAndGet();
            logger.error("ClusterNameMismatchException error while creating additional connection (error is: {})", (Object)clusterNameMismatchException.getMessage());
            return false;
        }
    }

    private Connection tryResurrectFromTrash() {
        long l = System.currentTimeMillis();
        Connection connection = null;
        do {
            for (Connection connection2 : this.trash) {
                if (connection2.maxIdleTime <= l || connection2.maxAvailableStreams() <= this.minAllowedStreams) continue;
                connection = connection2;
                l = connection2.maxIdleTime;
            }
            if (connection != null) continue;
            return null;
        } while (!connection.state.compareAndSet(Connection.State.TRASHED, Connection.State.RESURRECTING));
        logger.trace("Resurrecting {}", connection);
        this.trash.remove(connection);
        return connection;
    }

    private void maybeSpawnNewConnection() {
        int n;
        if (this.isClosed() || !this.host.convictionPolicy.canReconnectNow()) {
            return;
        }
        do {
            if ((n = this.scheduledForCreation.get()) < 1) continue;
            return;
        } while (!this.scheduledForCreation.compareAndSet(n, n + 1));
        this.manager.blockingExecutor().submit(this.newConnectionTask);
    }

    @Override
    public void onConnectionDefunct(Connection connection) {
        if (connection.state.compareAndSet(Connection.State.OPEN, Connection.State.GONE)) {
            this.open.decrementAndGet();
        }
        this.connections.remove(connection);
    }

    void cleanupIdleConnections(long l) {
        if (this.isClosed()) {
            return;
        }
        this.shrinkIfBelowCapacity();
        this.cleanupTrash(l);
    }

    private void shrinkIfBelowCapacity() {
        int n = this.maxTotalInFlight.getAndSet(this.totalInFlight.get());
        int n2 = this.options().getMaxRequestsPerConnection(this.hostDistance);
        int n3 = n / n2 + 1;
        if (n % n2 > this.options().getNewConnectionThreshold(this.hostDistance)) {
            ++n3;
        }
        n3 = Math.max(n3, this.options().getCoreConnectionsPerHost(this.hostDistance));
        int n4 = this.open.get();
        int n5 = Math.max(0, n4 - n3);
        logger.trace("Current inFlight = {}, {} connections needed, {} connections available, trashing {}", new Object[]{n, n3, n4, n5});
        if (n5 <= 0) {
            return;
        }
        for (Connection connection : this.connections) {
            if (!this.trashConnection(connection) || --n5 != 0) continue;
            return;
        }
    }

    private void cleanupTrash(long l) {
        for (Connection connection : this.trash) {
            if (connection.maxIdleTime >= l || !connection.state.compareAndSet(Connection.State.TRASHED, Connection.State.GONE)) continue;
            if (connection.inFlight.get() == 0) {
                logger.trace("Cleaning up {}", (Object)connection);
                this.trash.remove(connection);
                this.close(connection);
                continue;
            }
            connection.state.set(Connection.State.TRASHED);
        }
    }

    private void close(Connection connection) {
        connection.closeAsync();
    }

    public final boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    public final CloseFuture closeAsync() {
        CloseFuture closeFuture = this.closeFuture.get();
        if (closeFuture != null) {
            return closeFuture;
        }
        this.phase.set(Phase.CLOSING);
        this.signalAllAvailableConnection();
        closeFuture = new CloseFuture.Forwarding(this.discardAvailableConnections());
        return this.closeFuture.compareAndSet(null, closeFuture) ? closeFuture : this.closeFuture.get();
    }

    public int opened() {
        return this.open.get();
    }

    int trashed() {
        return this.trash.size();
    }

    private List<CloseFuture> discardAvailableConnections() {
        ArrayList<CloseFuture> arrayList = new ArrayList<CloseFuture>(this.connections.size() + this.trash.size());
        for (final Connection connection : this.connections) {
            CloseFuture closeFuture = connection.closeAsync();
            closeFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    if (connection.state.compareAndSet(Connection.State.OPEN, Connection.State.GONE)) {
                        HostConnectionPool.this.open.decrementAndGet();
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            arrayList.add(closeFuture);
        }
        for (final Connection connection : this.trash) {
            arrayList.add(connection.closeAsync());
        }
        return arrayList;
    }

    public void ensureCoreConnections() {
        int n;
        if (this.isClosed()) {
            return;
        }
        if (!this.host.convictionPolicy.canReconnectNow()) {
            return;
        }
        for (int i = n = this.open.get(); i < this.options().getCoreConnectionsPerHost(this.hostDistance); ++i) {
            this.scheduledForCreation.incrementAndGet();
            this.manager.blockingExecutor().submit(this.newConnectionTask);
        }
    }

    static class PoolState {
        volatile String keyspace;

        PoolState() {
        }

        void setKeyspace(String string) {
            this.keyspace = string;
        }
    }

    private static enum Phase {
        INITIALIZING,
        READY,
        INIT_FAILED,
        CLOSING;

    }
}

