/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ChainedResultSetFuture;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DefaultPreparedStatement;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.SystemProperties;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionManager
extends AbstractSession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private static final boolean CHECK_IO_DEADLOCKS = SystemProperties.getBoolean((String)"com.datastax.driver.CHECK_IO_DEADLOCKS", (boolean)true);
    final Cluster cluster;
    final ConcurrentMap<Host, HostConnectionPool> pools;
    final HostConnectionPool.PoolState poolsState;
    private final AtomicReference<ListenableFuture<Session>> initFuture = new AtomicReference();
    final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    private volatile boolean isInit;
    private volatile boolean isClosing;

    SessionManager(Cluster cluster) {
        this.cluster = cluster;
        this.pools = new ConcurrentHashMap<Host, HostConnectionPool>();
        this.poolsState = new HostConnectionPool.PoolState();
    }

    public Session init() {
        try {
            return (Session)Uninterruptibles.getUninterruptibly(this.initAsync());
        }
        catch (ExecutionException executionException) {
            throw DriverThrowables.propagateCause((ExecutionException)executionException);
        }
    }

    public ListenableFuture<Session> initAsync() {
        this.cluster.init();
        ListenableFuture<Session> listenableFuture = this.initFuture.get();
        if (listenableFuture != null) {
            return listenableFuture;
        }
        final SettableFuture settableFuture = SettableFuture.create();
        if (!this.initFuture.compareAndSet(null, (ListenableFuture<Session>)settableFuture)) {
            return this.initFuture.get();
        }
        Collection collection = this.cluster.getMetadata().allHosts();
        ListenableFuture<?> listenableFuture2 = this.createPools(collection);
        ListenableFuture listenableFuture3 = Futures.transformAsync(listenableFuture2, (AsyncFunction)new AsyncFunction<Object, Object>(){

            public ListenableFuture<Object> apply(Object object) throws Exception {
                SessionManager.this.isInit = true;
                return SessionManager.this.updateCreatedPools();
            }
        });
        Futures.addCallback((ListenableFuture)listenableFuture3, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object object) {
                settableFuture.set((Object)SessionManager.this);
            }

            public void onFailure(Throwable throwable) {
                SessionManager.this.closeAsync();
                settableFuture.setException(throwable);
            }
        });
        return settableFuture;
    }

    private ListenableFuture<?> createPools(Collection<Host> collection) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)collection.size());
        for (Host host : collection) {
            if (host.state == Host.State.DOWN) continue;
            arrayList.add(this.maybeAddPool(host, null));
        }
        return Futures.allAsList((Iterable)arrayList);
    }

    public String getLoggedKeyspace() {
        return this.poolsState.keyspace;
    }

    public ResultSetFuture executeAsync(final Statement statement) {
        if (this.isInit) {
            DefaultResultSetFuture defaultResultSetFuture = new DefaultResultSetFuture(this, this.cluster.manager.protocolVersion(), this.makeRequestMessage(statement, null));
            new RequestHandler(this, (RequestHandler.Callback)defaultResultSetFuture, statement).sendRequest();
            return defaultResultSetFuture;
        }
        final ChainedResultSetFuture chainedResultSetFuture = new ChainedResultSetFuture();
        this.initAsync().addListener(new Runnable(){

            @Override
            public void run() {
                DefaultResultSetFuture defaultResultSetFuture = new DefaultResultSetFuture(SessionManager.this, SessionManager.this.cluster.manager.protocolVersion(), SessionManager.this.makeRequestMessage(statement, null));
                SessionManager.this.execute((RequestHandler.Callback)defaultResultSetFuture, statement);
                chainedResultSetFuture.setSource((ResultSetFuture)defaultResultSetFuture);
            }
        }, (Executor)this.executor());
        return chainedResultSetFuture;
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String string) {
        Connection.Future future = new Connection.Future((Message.Request)new Requests.Prepare(string));
        this.execute(future, Statement.DEFAULT);
        return this.toPreparedStatement(string, future);
    }

    public CloseFuture closeAsync() {
        CloseFuture closeFuture = this.closeFuture.get();
        if (closeFuture != null) {
            return closeFuture;
        }
        this.isClosing = true;
        this.cluster.manager.removeSession((Session)this);
        ArrayList<CloseFuture> arrayList = new ArrayList<CloseFuture>(this.pools.size());
        for (HostConnectionPool hostConnectionPool : this.pools.values()) {
            arrayList.add(hostConnectionPool.closeAsync());
        }
        closeFuture = new CloseFuture.Forwarding(arrayList);
        return this.closeFuture.compareAndSet(null, closeFuture) ? closeFuture : this.closeFuture.get();
    }

    public boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Session.State getState() {
        return new State(this);
    }

    private ListenableFuture<PreparedStatement> toPreparedStatement(final String string, final Connection.Future future) {
        return Futures.transformAsync((ListenableFuture)future, (AsyncFunction)new AsyncFunction<Message.Response, PreparedStatement>(){

            public ListenableFuture<PreparedStatement> apply(Message.Response response) {
                switch (response.type) {
                    case RESULT: {
                        Responses.Result result = (Responses.Result)response;
                        switch (result.kind) {
                            case PREPARED: {
                                Responses.Result.Prepared prepared = (Responses.Result.Prepared)result;
                                DefaultPreparedStatement defaultPreparedStatement = DefaultPreparedStatement.fromMessage((Responses.Result.Prepared)prepared, (Metadata)SessionManager.this.cluster.getMetadata(), (ProtocolVersion)SessionManager.this.cluster.getConfiguration().getProtocolOptions().getProtocolVersionEnum(), (String)string, (String)SessionManager.this.poolsState.keyspace);
                                defaultPreparedStatement = SessionManager.this.cluster.manager.addPrepared((PreparedStatement)defaultPreparedStatement);
                                if (SessionManager.this.cluster.getConfiguration().getQueryOptions().isPrepareOnAllHosts()) {
                                    return SessionManager.this.prepare((PreparedStatement)defaultPreparedStatement, future.getAddress());
                                }
                                return Futures.immediateFuture((Object)defaultPreparedStatement);
                            }
                        }
                        return Futures.immediateFailedFuture((Throwable)new DriverInternalError(String.format("%s response received when prepared statement was expected", result.kind)));
                    }
                    case ERROR: {
                        return Futures.immediateFailedFuture((Throwable)((Responses.Error)response).asException(future.getAddress()));
                    }
                }
                return Futures.immediateFailedFuture((Throwable)new DriverInternalError(String.format("%s response received when prepared statement was expected", response.type)));
            }
        }, (Executor)this.executor());
    }

    Connection.Factory connectionFactory() {
        return this.cluster.manager.connectionFactory;
    }

    Configuration configuration() {
        return this.cluster.manager.configuration;
    }

    LoadBalancingPolicy loadBalancingPolicy() {
        return this.cluster.manager.loadBalancingPolicy();
    }

    SpeculativeExecutionPolicy speculativeRetryPolicy() {
        return this.cluster.manager.speculativeRetryPolicy();
    }

    ReconnectionPolicy reconnectionPolicy() {
        return this.cluster.manager.reconnectionPolicy();
    }

    ListeningExecutorService executor() {
        return this.cluster.manager.executor;
    }

    ListeningExecutorService blockingExecutor() {
        return this.cluster.manager.blockingExecutor;
    }

    ListenableFuture<Boolean> forceRenewPool(final Host host, Connection connection) {
        HostDistance hostDistance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (hostDistance == HostDistance.IGNORED) {
            return Futures.immediateFuture((Object)true);
        }
        if (this.isClosing) {
            return Futures.immediateFuture((Object)false);
        }
        final HostConnectionPool hostConnectionPool = new HostConnectionPool(host, hostDistance, this);
        ListenableFuture<Void> listenableFuture = hostConnectionPool.initAsync(connection);
        final SettableFuture settableFuture = SettableFuture.create();
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void void_) {
                HostConnectionPool hostConnectionPool2 = SessionManager.this.pools.put(host, hostConnectionPool);
                if (hostConnectionPool2 == null) {
                    logger.debug("Added connection pool for {}", (Object)host);
                } else {
                    logger.debug("Renewed connection pool for {}", (Object)host);
                    hostConnectionPool2.closeAsync();
                }
                if (SessionManager.this.isClosing) {
                    hostConnectionPool.closeAsync();
                    SessionManager.this.pools.remove(host);
                    settableFuture.set((Object)false);
                } else {
                    settableFuture.set((Object)true);
                }
            }

            public void onFailure(Throwable throwable) {
                logger.warn("Error creating pool to " + host, throwable);
                settableFuture.set((Object)false);
            }
        });
        return settableFuture;
    }

    private ListenableFuture<Void> replacePool(final Host host, HostDistance hostDistance, HostConnectionPool hostConnectionPool, Connection connection) {
        if (this.isClosing) {
            return MoreFutures.VOID_SUCCESS;
        }
        final HostConnectionPool hostConnectionPool2 = new HostConnectionPool(host, hostDistance, this);
        if (hostConnectionPool == null) {
            if (this.pools.putIfAbsent(host, hostConnectionPool2) != null) {
                return null;
            }
        } else {
            if (!this.pools.replace(host, hostConnectionPool, hostConnectionPool2)) {
                return null;
            }
            if (!hostConnectionPool.isClosed()) {
                logger.warn("Replacing a pool that wasn't closed. Closing it now, but this was not expected.");
                hostConnectionPool.closeAsync();
            }
        }
        ListenableFuture<Void> listenableFuture = hostConnectionPool2.initAsync(connection);
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void void_) {
                if (SessionManager.this.isClosing) {
                    hostConnectionPool2.closeAsync();
                    SessionManager.this.pools.remove(host);
                }
            }

            public void onFailure(Throwable throwable) {
                SessionManager.this.pools.remove(host);
            }
        });
        return listenableFuture;
    }

    ListenableFuture<Boolean> maybeAddPool(final Host host, Connection connection) {
        SettableFuture settableFuture;
        ListenableFuture<Void> listenableFuture;
        HostDistance hostDistance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (hostDistance == HostDistance.IGNORED) {
            return Futures.immediateFuture((Object)true);
        }
        HostConnectionPool hostConnectionPool = (HostConnectionPool)this.pools.get(host);
        if (hostConnectionPool != null && !hostConnectionPool.isClosed()) {
            return Futures.immediateFuture((Object)true);
        }
        do {
            if ((hostConnectionPool = (HostConnectionPool)this.pools.get(host)) != null && !hostConnectionPool.isClosed()) {
                return Futures.immediateFuture((Object)true);
            }
            settableFuture = SettableFuture.create();
        } while ((listenableFuture = this.replacePool(host, hostDistance, hostConnectionPool, connection)) == null);
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void void_) {
                logger.debug("Added connection pool for {}", (Object)host);
                settableFuture.set((Object)true);
            }

            public void onFailure(Throwable throwable) {
                if (throwable instanceof UnsupportedProtocolVersionException) {
                    SessionManager.this.cluster.manager.logUnsupportedVersionProtocol(host, ((UnsupportedProtocolVersionException)throwable).unsupportedVersion);
                    SessionManager.this.cluster.manager.triggerOnDown(host, false);
                } else if (throwable instanceof ClusterNameMismatchException) {
                    ClusterNameMismatchException clusterNameMismatchException = (ClusterNameMismatchException)throwable;
                    SessionManager.this.cluster.manager.logClusterNameMismatch(host, clusterNameMismatchException.expectedClusterName, clusterNameMismatchException.actualClusterName);
                    SessionManager.this.cluster.manager.triggerOnDown(host, false);
                } else {
                    logger.warn("Error creating pool to " + host, throwable);
                }
                settableFuture.set((Object)false);
            }
        });
        return settableFuture;
    }

    CloseFuture removePool(Host host) {
        HostConnectionPool hostConnectionPool = (HostConnectionPool)this.pools.remove(host);
        return hostConnectionPool == null ? CloseFuture.immediateFuture() : hostConnectionPool.closeAsync();
    }

    ListenableFuture<?> updateCreatedPools() {
        if (!this.isInit) {
            return MoreFutures.VOID_SUCCESS;
        }
        final ArrayList<Host> arrayList = new ArrayList<Host>();
        ArrayList arrayList2 = Lists.newArrayList();
        for (Host host : this.cluster.getMetadata().allHosts()) {
            HostDistance hostDistance = this.loadBalancingPolicy().distance(host);
            HostConnectionPool hostConnectionPool = (HostConnectionPool)this.pools.get(host);
            if (hostConnectionPool == null) {
                if (hostDistance == HostDistance.IGNORED || host.state != Host.State.UP) continue;
                arrayList2.add(this.maybeAddPool(host, null));
                continue;
            }
            if (hostDistance == hostConnectionPool.hostDistance) continue;
            if (hostDistance == HostDistance.IGNORED) {
                arrayList.add(host);
                continue;
            }
            hostConnectionPool.hostDistance = hostDistance;
            hostConnectionPool.ensureCoreConnections();
        }
        ListenableFuture listenableFuture = Futures.successfulAsList((Iterable)arrayList2);
        return Futures.transformAsync((ListenableFuture)listenableFuture, (AsyncFunction)new AsyncFunction<Object, List<Void>>(){

            public ListenableFuture<List<Void>> apply(Object object) throws Exception {
                ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)arrayList.size());
                for (Host host : arrayList) {
                    arrayList2.add(SessionManager.this.removePool(host));
                }
                return Futures.successfulAsList((Iterable)arrayList2);
            }
        });
    }

    void updateCreatedPools(Host host) {
        HostDistance hostDistance = this.loadBalancingPolicy().distance(host);
        HostConnectionPool hostConnectionPool = (HostConnectionPool)this.pools.get(host);
        try {
            if (hostConnectionPool == null) {
                if (hostDistance != HostDistance.IGNORED && host.state == Host.State.UP) {
                    try {
                        this.maybeAddPool(host, null).get();
                    }
                    catch (ExecutionException executionException) {}
                }
            } else if (hostDistance != hostConnectionPool.hostDistance) {
                if (hostDistance == HostDistance.IGNORED) {
                    this.removePool(host).get();
                } else {
                    hostConnectionPool.hostDistance = hostDistance;
                    hostConnectionPool.ensureCoreConnections();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.error("Unexpected error while refreshing connection pools", executionException.getCause());
        }
    }

    void onDown(Host host) throws InterruptedException, ExecutionException {
        this.removePool(host).force().get();
        this.updateCreatedPools().get();
    }

    void onRemove(Host host) throws InterruptedException, ExecutionException {
        this.onDown(host);
    }

    Message.Request makeRequestMessage(Statement statement, ByteBuffer byteBuffer) {
        if (!this.isInit) {
            this.init();
        }
        ProtocolVersion protocolVersion = this.cluster.manager.protocolVersion();
        ConsistencyLevel consistencyLevel = statement.getConsistencyLevel();
        if (consistencyLevel == null) {
            consistencyLevel = this.configuration().getQueryOptions().getConsistencyLevel();
        }
        ConsistencyLevel consistencyLevel2 = statement.getSerialConsistencyLevel();
        if (protocolVersion.compareTo((Enum)ProtocolVersion.V3) < 0 && statement instanceof BatchStatement) {
            if (consistencyLevel2 != null) {
                throw new UnsupportedFeatureException(protocolVersion, "Serial consistency on batch statements is not supported");
            }
        } else if (consistencyLevel2 == null) {
            consistencyLevel2 = this.configuration().getQueryOptions().getSerialConsistencyLevel();
        }
        long l = Long.MIN_VALUE;
        if (this.cluster.manager.protocolVersion().compareTo((Enum)ProtocolVersion.V3) >= 0 && (l = statement.getDefaultTimestamp()) == Long.MIN_VALUE) {
            l = this.cluster.getConfiguration().getPolicies().getTimestampGenerator().next();
        }
        int n = statement.getFetchSize();
        ByteBuffer byteBuffer2 = byteBuffer;
        if (protocolVersion == ProtocolVersion.V1) {
            assert (byteBuffer == null);
            if (n <= 0) {
                n = -1;
            } else if (n != Integer.MAX_VALUE) {
                throw new UnsupportedFeatureException(protocolVersion, "Paging is not supported");
            }
        } else if (n <= 0) {
            n = this.configuration().getQueryOptions().getFetchSize();
        }
        if (n == Integer.MAX_VALUE) {
            n = -1;
        }
        if (byteBuffer == null) {
            byteBuffer2 = statement.getPagingState();
        }
        if (statement instanceof StatementWrapper) {
            statement = ((StatementWrapper)statement).getWrappedStatement();
        }
        if (statement instanceof RegularStatement) {
            RegularStatement regularStatement = (RegularStatement)statement;
            if (protocolVersion == ProtocolVersion.V1 && regularStatement instanceof BuiltStatement) {
                ((BuiltStatement)regularStatement).setForceNoValues(true);
            }
            ByteBuffer[] byteBufferArray = regularStatement.getValues(protocolVersion);
            if (protocolVersion == ProtocolVersion.V1 && byteBufferArray != null) {
                throw new UnsupportedFeatureException(protocolVersion, "Binary values are not supported");
            }
            List<Object> list = byteBufferArray == null ? Collections.emptyList() : Arrays.asList(byteBufferArray);
            String string = regularStatement.getQueryString();
            Requests.QueryProtocolOptions queryProtocolOptions = new Requests.QueryProtocolOptions(Message.Request.Type.QUERY, consistencyLevel, list, false, n, byteBuffer2, consistencyLevel2, l);
            return new Requests.Query(string, queryProtocolOptions, statement.isTracing());
        }
        if (statement instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement;
            if (!this.cluster.manager.preparedQueries.containsKey(boundStatement.statement.getPreparedId().id)) {
                throw new InvalidQueryException(String.format("Tried to execute unknown prepared query : %s. You may have used a PreparedStatement that was created with another Cluster instance.", boundStatement.statement.getPreparedId().id));
            }
            boundStatement.ensureAllSet();
            boolean bl = protocolVersion != ProtocolVersion.V1 && boundStatement.statement.getPreparedId().resultSetMetadata != null;
            Requests.QueryProtocolOptions queryProtocolOptions = new Requests.QueryProtocolOptions(Message.Request.Type.EXECUTE, consistencyLevel, Arrays.asList(boundStatement.wrapper.values), bl, n, byteBuffer2, consistencyLevel2, l);
            return new Requests.Execute(boundStatement.statement.getPreparedId().id, queryProtocolOptions, statement.isTracing());
        }
        assert (statement instanceof BatchStatement) : statement;
        assert (byteBuffer == null);
        if (protocolVersion == ProtocolVersion.V1) {
            throw new UnsupportedFeatureException(protocolVersion, "Protocol level batching is not supported");
        }
        BatchStatement batchStatement = (BatchStatement)statement;
        batchStatement.ensureAllSet();
        BatchStatement.IdAndValues idAndValues = batchStatement.getIdAndValues(protocolVersion);
        Requests.BatchProtocolOptions batchProtocolOptions = new Requests.BatchProtocolOptions(consistencyLevel, consistencyLevel2, l);
        return new Requests.Batch(batchStatement.batchType, idAndValues.ids, idAndValues.values, batchProtocolOptions, statement.isTracing());
    }

    void execute(final RequestHandler.Callback callback, final Statement statement) {
        if (this.isInit) {
            new RequestHandler(this, callback, statement).sendRequest();
        } else {
            this.initAsync().addListener(new Runnable(){

                @Override
                public void run() {
                    new RequestHandler(SessionManager.this, callback, statement).sendRequest();
                }
            }, (Executor)this.executor());
        }
    }

    private ListenableFuture<PreparedStatement> prepare(PreparedStatement preparedStatement, InetSocketAddress inetSocketAddress) {
        final String string = preparedStatement.getQueryString();
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)this.pools.size());
        for (final Map.Entry entry : this.pools.entrySet()) {
            if (((Host)entry.getKey()).getSocketAddress().equals(inetSocketAddress)) continue;
            try {
                final Connection connection = ((HostConnectionPool)entry.getValue()).borrowConnection(0L, TimeUnit.MILLISECONDS);
                Connection.Future future = connection.write((Message.Request)new Requests.Prepare(string));
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Message.Response>(){

                    public void onSuccess(Message.Response response) {
                        connection.release();
                    }

                    public void onFailure(Throwable throwable) {
                        logger.debug(String.format("Unexpected error while preparing query (%s) on %s", string, entry.getKey()), throwable);
                        connection.release();
                    }
                });
                arrayList.add(future);
            }
            catch (Exception exception) {}
        }
        return Futures.transform((ListenableFuture)Futures.successfulAsList((Iterable)arrayList), (Function)Functions.constant((Object)preparedStatement));
    }

    ResultSetFuture executeQuery(Message.Request request, Statement statement) {
        DefaultResultSetFuture defaultResultSetFuture = new DefaultResultSetFuture(this, this.configuration().getProtocolOptions().getProtocolVersionEnum(), request);
        this.execute((RequestHandler.Callback)defaultResultSetFuture, statement);
        return defaultResultSetFuture;
    }

    void cleanupIdleConnections(long l) {
        for (HostConnectionPool hostConnectionPool : this.pools.values()) {
            hostConnectionPool.cleanupIdleConnections(l);
        }
    }

    protected void checkNotInEventLoop() {
        Connection.Factory factory = this.cluster.manager.connectionFactory;
        if (!CHECK_IO_DEADLOCKS || factory == null) {
            return;
        }
        for (EventExecutor eventExecutor : factory.eventLoopGroup) {
            if (!eventExecutor.inEventLoop()) continue;
            throw new IllegalStateException("Detected a synchronous Session call (execute() or prepare()) on an I/O thread, this can cause deadlocks or unpredictable behavior. Make sure your Future callbacks only use async calls, or schedule them on a different executor.");
        }
    }

    private static class State
    implements Session.State {
        private final SessionManager session;
        private final List<Host> connectedHosts;
        private final int[] openConnections;
        private final int[] trashedConnections;
        private final int[] inFlightQueries;

        private State(SessionManager sessionManager) {
            this.session = sessionManager;
            this.connectedHosts = ImmutableList.copyOf(sessionManager.pools.keySet());
            this.openConnections = new int[this.connectedHosts.size()];
            this.trashedConnections = new int[this.connectedHosts.size()];
            this.inFlightQueries = new int[this.connectedHosts.size()];
            int n = 0;
            for (Host host : this.connectedHosts) {
                HostConnectionPool hostConnectionPool = (HostConnectionPool)sessionManager.pools.get(host);
                if (hostConnectionPool == null) {
                    this.openConnections[n] = 0;
                    this.trashedConnections[n] = 0;
                    this.inFlightQueries[n] = 0;
                    continue;
                }
                this.openConnections[n] = hostConnectionPool.opened();
                this.inFlightQueries[n] = hostConnectionPool.totalInFlight.get();
                this.trashedConnections[n] = hostConnectionPool.trashed();
                ++n;
            }
        }

        private int getIdx(Host host) {
            for (int i = 0; i < this.connectedHosts.size(); ++i) {
                if (host != this.connectedHosts.get(i)) continue;
                return i;
            }
            return -1;
        }

        public Session getSession() {
            return this.session;
        }

        public Collection<Host> getConnectedHosts() {
            return this.connectedHosts;
        }

        public int getOpenConnections(Host host) {
            int n = this.getIdx(host);
            return n < 0 ? 0 : this.openConnections[n];
        }

        public int getTrashedConnections(Host host) {
            int n = this.getIdx(host);
            return n < 0 ? 0 : this.trashedConnections[n];
        }

        public int getInFlightQueries(Host host) {
            int n = this.getIdx(host);
            return n < 0 ? 0 : this.inFlightQueries[n];
        }
    }
}

