/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;

class CompatUtil {
    private static RandomPartitioner randomPartitioner = new RandomPartitioner();
    private static Murmur3Partitioner murmur3Partitioner = new Murmur3Partitioner();

    CompatUtil() {
    }

    public static ProtocolVersion getProtocolVersion(Cluster cluster) {
        return cluster.getConfiguration().getProtocolOptions().getProtocolVersionEnum();
    }

    public static <T> ByteBuffer serialize(DataType dataType, T t, ProtocolVersion protocolVersion) {
        return dataType.serialize(t, protocolVersion);
    }

    public static BigInteger maxToken(String string) {
        switch (string) {
            case "org.apache.cassandra.dht.RandomPartitioner": {
                return RandomPartitioner.MAXIMUM.subtract(BigInteger.ONE);
            }
            case "org.apache.cassandra.dht.Murmur3Partitioner": {
                return BigInteger.valueOf(Long.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("Unsupported partitioner " + string);
    }

    public static BigInteger minToken(String string) {
        switch (string) {
            case "org.apache.cassandra.dht.RandomPartitioner": {
                return RandomPartitioner.ZERO;
            }
            case "org.apache.cassandra.dht.Murmur3Partitioner": {
                return BigInteger.valueOf((Long)Murmur3Partitioner.MINIMUM.token);
            }
        }
        throw new IllegalArgumentException("Unsupported partitioner " + string);
    }

    public static BigInteger getToken(String string, ByteBuffer byteBuffer) {
        switch (string) {
            case "org.apache.cassandra.dht.RandomPartitioner": {
                return (BigInteger)CompatUtil.randomPartitioner.getToken((ByteBuffer)byteBuffer).getToken().token;
            }
            case "org.apache.cassandra.dht.Murmur3Partitioner": {
                return BigInteger.valueOf((Long)CompatUtil.murmur3Partitioner.getToken((ByteBuffer)byteBuffer).token).add(BigInteger.valueOf((Long)Murmur3Partitioner.MINIMUM.token));
            }
        }
        throw new IllegalArgumentException("Unsupported partitioner " + string);
    }
}

