/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RangeTombstoneList;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;

public class DeletionInfo {
    private static final Serializer serializer = new Serializer();
    private DeletionTime topLevel;
    private RangeTombstoneList ranges;

    public DeletionInfo(long l, int n) {
        this(new DeletionTime(l, n == Integer.MIN_VALUE ? Integer.MAX_VALUE : n));
    }

    public DeletionInfo(DeletionTime deletionTime) {
        this(deletionTime, null);
    }

    public DeletionInfo(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, Comparator<ByteBuffer> comparator, long l, int n) {
        this(DeletionTime.LIVE, new RangeTombstoneList(comparator, 1));
        this.ranges.add(byteBuffer, byteBuffer2, l, n);
    }

    public DeletionInfo(RangeTombstone rangeTombstone, Comparator<ByteBuffer> comparator) {
        this((ByteBuffer)rangeTombstone.min, (ByteBuffer)rangeTombstone.max, comparator, ((DeletionTime)rangeTombstone.data).markedForDeleteAt, ((DeletionTime)rangeTombstone.data).localDeletionTime);
    }

    private DeletionInfo(DeletionTime deletionTime, RangeTombstoneList rangeTombstoneList) {
        this.topLevel = deletionTime;
        this.ranges = rangeTombstoneList;
    }

    public static DeletionInfo live() {
        return new DeletionInfo(DeletionTime.LIVE);
    }

    public static Serializer serializer() {
        return serializer;
    }

    public DeletionInfo copy() {
        return new DeletionInfo(this.topLevel, this.ranges == null ? null : this.ranges.copy());
    }

    public boolean isLive() {
        return this.topLevel.markedForDeleteAt == Long.MIN_VALUE && this.topLevel.localDeletionTime == Integer.MAX_VALUE && (this.ranges == null || this.ranges.isEmpty());
    }

    public boolean isDeleted(Column column) {
        return this.isDeleted(column.name(), column.timestamp());
    }

    public boolean isDeleted(ByteBuffer byteBuffer, long l) {
        if (this.isLive()) {
            return false;
        }
        if (l <= this.topLevel.markedForDeleteAt) {
            return true;
        }
        return this.ranges != null && this.ranges.isDeleted(byteBuffer, l);
    }

    InOrderTester inOrderTester() {
        return this.inOrderTester(false);
    }

    public InOrderTester inOrderTester(boolean bl) {
        return new InOrderTester(bl);
    }

    public void purge(int n) {
        DeletionTime deletionTime = this.topLevel = this.topLevel.localDeletionTime < n ? DeletionTime.LIVE : this.topLevel;
        if (this.ranges != null) {
            this.ranges.purge(n);
            if (this.ranges.isEmpty()) {
                this.ranges = null;
            }
        }
    }

    public DeletionInfo diff(DeletionInfo deletionInfo) {
        RangeTombstoneList rangeTombstoneList = deletionInfo.ranges == null || deletionInfo.ranges.isEmpty() ? null : (this.ranges == null ? deletionInfo.ranges : this.ranges.diff(deletionInfo.ranges));
        return this.topLevel.markedForDeleteAt != deletionInfo.topLevel.markedForDeleteAt || rangeTombstoneList != null ? new DeletionInfo(deletionInfo.topLevel, rangeTombstoneList) : DeletionInfo.live();
    }

    public boolean hasPurgeableTombstones(int n) {
        if (this.topLevel.localDeletionTime < n) {
            return true;
        }
        return this.ranges != null && this.ranges.hasPurgeableTombstones(n);
    }

    public void add(DeletionTime deletionTime) {
        if (this.topLevel.markedForDeleteAt < deletionTime.markedForDeleteAt) {
            this.topLevel = deletionTime;
        }
    }

    public void add(RangeTombstone rangeTombstone, Comparator<ByteBuffer> comparator) {
        if (this.ranges == null) {
            this.ranges = new RangeTombstoneList(comparator, 1);
        }
        this.ranges.add(rangeTombstone);
    }

    public DeletionInfo add(DeletionInfo deletionInfo) {
        this.add(deletionInfo.topLevel);
        if (this.ranges == null) {
            this.ranges = deletionInfo.ranges == null ? null : deletionInfo.ranges.copy();
        } else if (deletionInfo.ranges != null) {
            this.ranges.addAll(deletionInfo.ranges);
        }
        return this;
    }

    public long minTimestamp() {
        return this.ranges == null ? this.topLevel.markedForDeleteAt : Math.min(this.topLevel.markedForDeleteAt, this.ranges.minMarkedAt());
    }

    public long maxTimestamp() {
        return this.ranges == null ? this.topLevel.markedForDeleteAt : Math.max(this.topLevel.markedForDeleteAt, this.ranges.maxMarkedAt());
    }

    public DeletionTime getTopLevelDeletion() {
        return this.topLevel;
    }

    public Iterator<RangeTombstone> rangeIterator() {
        return this.ranges == null ? Collections.emptyIterator() : this.ranges.iterator();
    }

    public DeletionTime rangeCovering(ByteBuffer byteBuffer) {
        return this.ranges == null ? null : this.ranges.search(byteBuffer);
    }

    public int dataSize() {
        int n = TypeSizes.NATIVE.sizeof(this.topLevel.markedForDeleteAt);
        return n + (this.ranges == null ? 0 : this.ranges.dataSize());
    }

    public boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    public int rangeCount() {
        return this.hasRanges() ? this.ranges.size() : 0;
    }

    public boolean mayModify(DeletionInfo deletionInfo) {
        return this.topLevel.markedForDeleteAt > deletionInfo.topLevel.markedForDeleteAt || this.hasRanges();
    }

    public String toString() {
        if (this.ranges == null || this.ranges.isEmpty()) {
            return String.format("{%s}", this.topLevel);
        }
        return String.format("{%s, ranges=%s}", this.topLevel, this.rangesAsString());
    }

    private String rangesAsString() {
        assert (!this.ranges.isEmpty());
        StringBuilder stringBuilder = new StringBuilder();
        AbstractType abstractType = (AbstractType)this.ranges.comparator();
        assert (abstractType != null);
        Iterator<RangeTombstone> iterator = this.rangeIterator();
        while (iterator.hasNext()) {
            RangeTombstone rangeTombstone = iterator.next();
            stringBuilder.append("[");
            stringBuilder.append(abstractType.getString((ByteBuffer)rangeTombstone.min)).append("-");
            stringBuilder.append(abstractType.getString((ByteBuffer)rangeTombstone.max)).append(", ");
            stringBuilder.append(rangeTombstone.data);
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public void updateAllTimestamp(long l) {
        if (this.topLevel.markedForDeleteAt != Long.MIN_VALUE) {
            this.topLevel = new DeletionTime(l, this.topLevel.localDeletionTime);
        }
        if (this.ranges != null) {
            this.ranges.updateAllTimestamp(l);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DeletionInfo)) {
            return false;
        }
        DeletionInfo deletionInfo = (DeletionInfo)object;
        return this.topLevel.equals((Object)deletionInfo.topLevel) && Objects.equal((Object)this.ranges, (Object)deletionInfo.ranges);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topLevel, this.ranges});
    }

    public class InOrderTester {
        private RangeTombstoneList.InOrderTester tester;
        private final boolean reversed;

        private InOrderTester(boolean bl) {
            this.reversed = bl;
        }

        public boolean isDeleted(Column column) {
            return this.isDeleted(column.name(), column.timestamp());
        }

        public boolean isDeleted(ByteBuffer byteBuffer, long l) {
            if (l <= ((DeletionInfo)DeletionInfo.this).topLevel.markedForDeleteAt) {
                return true;
            }
            if (this.reversed) {
                return DeletionInfo.this.isDeleted(byteBuffer, l);
            }
            if (this.tester == null && DeletionInfo.this.ranges != null) {
                this.tester = DeletionInfo.this.ranges.inOrderTester();
            }
            return this.tester != null && this.tester.isDeleted(byteBuffer, l);
        }
    }

    public static class Serializer
    implements IVersionedSerializer<DeletionInfo> {
        public void serialize(DeletionInfo deletionInfo, DataOutput dataOutput, int n) throws IOException {
            DeletionTime.serializer.serialize((Object)deletionInfo.topLevel, dataOutput);
            RangeTombstoneList.serializer.serialize(deletionInfo.ranges, dataOutput, n);
        }

        public DeletionInfo deserialize(DataInput dataInput, int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DeletionInfo deserialize(DataInput dataInput, int n, Comparator<ByteBuffer> comparator) throws IOException {
            DeletionTime deletionTime = (DeletionTime)DeletionTime.serializer.deserialize(dataInput);
            RangeTombstoneList rangeTombstoneList = RangeTombstoneList.serializer.deserialize(dataInput, n, comparator);
            return new DeletionInfo(deletionTime, rangeTombstoneList);
        }

        public long serializedSize(DeletionInfo deletionInfo, TypeSizes typeSizes, int n) {
            long l = DeletionTime.serializer.serializedSize((Object)deletionInfo.topLevel, typeSizes);
            return l + RangeTombstoneList.serializer.serializedSize(deletionInfo.ranges, typeSizes, n);
        }

        public long serializedSize(DeletionInfo deletionInfo, int n) {
            return this.serializedSize(deletionInfo, TypeSizes.NATIVE, n);
        }
    }
}

