/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class SSTableSimpleUnsortedWriter
extends AbstractSSTableSimpleWriter {
    private static final Buffer SENTINEL = new Buffer();
    private Buffer buffer = new Buffer();
    private final long bufferSize;
    private long currentSize;
    private final BlockingQueue<Buffer> writeQueue = new SynchronousQueue<Buffer>();
    private final DiskWriter diskWriter = new DiskWriter();

    public SSTableSimpleUnsortedWriter(File file, IPartitioner iPartitioner, String string, String string2, AbstractType<?> abstractType, AbstractType<?> abstractType2, int n, CompressionParameters compressionParameters) {
        this(file, new CFMetaData(string, string2, abstractType2 == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, abstractType, abstractType2).compressionParameters(compressionParameters), iPartitioner, n);
    }

    public SSTableSimpleUnsortedWriter(File file, IPartitioner iPartitioner, String string, String string2, AbstractType<?> abstractType, AbstractType<?> abstractType2, int n) {
        this(file, iPartitioner, string, string2, abstractType, abstractType2, n, new CompressionParameters(null));
    }

    public SSTableSimpleUnsortedWriter(File file, CFMetaData cFMetaData, IPartitioner iPartitioner, long l) {
        super(file, cFMetaData, iPartitioner);
        this.bufferSize = l * 1024L * 1024L;
        this.diskWriter.start();
    }

    protected void writeRow(DecoratedKey decoratedKey, ColumnFamily columnFamily) throws IOException {
    }

    protected void addColumn(Column column) throws IOException {
        super.addColumn(column);
        this.countColumn(column);
    }

    protected void countColumn(Column column) throws IOException {
        this.currentSize += (long)column.serializedSize(TypeSizes.NATIVE);
        if (this.currentSize > this.bufferSize) {
            this.replaceColumnFamily();
        }
    }

    protected ColumnFamily getColumnFamily() throws IOException {
        ColumnFamily columnFamily = (ColumnFamily)this.buffer.get(this.currentKey);
        if (columnFamily == null) {
            columnFamily = this.createColumnFamily();
            this.buffer.put(this.currentKey, columnFamily);
            this.currentSize += (long)(14 + this.currentKey.key.remaining());
        }
        return columnFamily;
    }

    protected ColumnFamily createColumnFamily() throws IOException {
        return TreeMapBackedSortedColumns.factory.create(this.metadata);
    }

    public void close() throws IOException {
        this.sync();
        this.put(SENTINEL);
        try {
            this.diskWriter.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    protected void replaceColumnFamily() throws IOException {
        this.sync();
    }

    protected void sync() throws IOException {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.columnFamily = null;
        this.put(this.buffer);
        this.buffer = new Buffer();
        this.currentSize = 0L;
        this.columnFamily = this.getColumnFamily();
        this.buffer.setFirstInsertedKey(this.currentKey);
    }

    /*
     * Exception decompiling
     */
    private void put(Buffer var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForWriterException() throws IOException {
        if (this.diskWriter.exception != null) {
            if (this.diskWriter.exception instanceof IOException) {
                throw (IOException)this.diskWriter.exception;
            }
            throw Throwables.propagate((Throwable)this.diskWriter.exception);
        }
    }

    private class DiskWriter
    extends Thread {
        volatile Throwable exception = null;

        private DiskWriter() {
        }

        @Override
        public void run() {
            SSTableWriter sSTableWriter = null;
            try {
                while (true) {
                    Buffer buffer;
                    if ((buffer = (Buffer)SSTableSimpleUnsortedWriter.this.writeQueue.take()) == SENTINEL) {
                        return;
                    }
                    sSTableWriter = SSTableSimpleUnsortedWriter.this.getWriter();
                    for (Map.Entry entry : buffer.entrySet()) {
                        if (((ColumnFamily)entry.getValue()).getColumnCount() > 0) {
                            sSTableWriter.append((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue());
                            continue;
                        }
                        if (!((DecoratedKey)entry.getKey()).equals((Object)buffer.getFirstInsertedKey())) {
                            throw new AssertionError((Object)"Empty partition");
                        }
                    }
                    sSTableWriter.close(true);
                }
            }
            catch (Throwable throwable) {
                if (sSTableWriter != null) {
                    sSTableWriter.abort();
                }
                this.exception = throwable;
                return;
            }
        }
    }

    private static class Buffer
    extends TreeMap<DecoratedKey, ColumnFamily> {
        private DecoratedKey firstInsertedKey;

        private Buffer() {
        }

        public void setFirstInsertedKey(DecoratedKey decoratedKey) {
            this.firstInsertedKey = decoratedKey;
        }

        public DecoratedKey getFirstInsertedKey() {
            return this.firstInsertedKey;
        }
    }
}

