/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.elasticsearch;

import com.spotify.scio.elasticsearch.package;
import java.net.InetSocketAddress;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class IndexAdmin$ {
    public static IndexAdmin$ MODULE$;
    private final Logger Logger;
    private volatile boolean bitmap$init$0;

    static {
        new IndexAdmin$();
    }

    private <A> Try<A> adminClient(package.ElasticsearchOptions esOptions, Function1<AdminClient, A> f) {
        Settings settings = Settings.builder().put("cluster.name", esOptions.clusterName()).build();
        Seq transportAddresses = (Seq)esOptions.servers().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TransportAddress apply(InetSocketAddress addr) {
                return new TransportAddress(addr);
            }
        }, Seq$.MODULE$.canBuildFrom());
        TransportClient client = new PreBuiltTransportClient(settings, new Class[0]).addTransportAddresses((TransportAddress[])transportAddresses.toArray(ClassTag$.MODULE$.apply(TransportAddress.class)));
        Try result = Try$.MODULE$.apply((Function0)new Serializable(f, client){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;
            private final TransportClient client$1;

            public final A apply() {
                return (A)this.f$1.apply((Object)this.client$1.admin());
            }
            {
                this.f$1 = f$1;
                this.client$1 = client$1;
            }
        });
        client.close();
        return result;
    }

    public Try<CreateIndexResponse> ensureIndex(String cluster, Iterable<InetSocketAddress> servers, String index, String mappingSource) {
        package.ElasticsearchOptions esOptions = new package.ElasticsearchOptions(cluster, (Seq<InetSocketAddress>)servers.toSeq());
        return this.ensureIndex(esOptions, index, mappingSource);
    }

    public Try<CreateIndexResponse> ensureIndex(package.ElasticsearchOptions esOptions, String index, String mappingSource) {
        return this.adminClient(esOptions, (Function1)new Serializable(index, mappingSource){
            public static final long serialVersionUID = 0L;
            private final String index$1;
            private final String mappingSource$1;

            public final CreateIndexResponse apply(AdminClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$ensureIndex(this.index$1, this.mappingSource$1, client);
            }
            {
                this.index$1 = index$1;
                this.mappingSource$1 = mappingSource$1;
            }
        });
    }

    public CreateIndexResponse com$spotify$scio$elasticsearch$IndexAdmin$$ensureIndex(String index, String mappingSource, AdminClient client) {
        return (CreateIndexResponse)client.indices().prepareCreate(index).setSource(mappingSource, XContentType.JSON).get();
    }

    public AcknowledgedResponse createOrUpdateAlias(IndicesAdminClient client, Iterable<Tuple2<String, Object>> indices, String alias, boolean removePrevious, TimeValue timeout) {
        IndicesAliasesRequest request;
        block0: {
            Predef$.MODULE$.require(Option$.MODULE$.option2Iterable(indices.find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> x$1) {
                    return x$1._2$mcZ$sp();
                }
            })).size() == 1, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Only one index per alias can be assigned to be the write index at a time";
                }
            });
            request = (IndicesAliasesRequest)indices.foldLeft((Object)new IndicesAliasesRequest(), (Function2)new Serializable(alias){
                public static final long serialVersionUID = 0L;
                private final String alias$1;

                public final IndicesAliasesRequest apply(IndicesAliasesRequest x0$1, Tuple2<String, Object> x1$1) {
                    Tuple2 tuple2;
                    IndicesAliasesRequest request;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2((Object)x0$1, x1$1);
                            if (tuple22 == null) break block2;
                            request = (IndicesAliasesRequest)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    String idx = (String)tuple2._1();
                    boolean isWriteIndex = tuple2._2$mcZ$sp();
                    IndicesAliasesRequest indicesAliasesRequest = request.addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(idx).writeIndex(Predef$.MODULE$.boolean2Boolean(isWriteIndex)).alias(this.alias$1));
                    return indicesAliasesRequest;
                }
                {
                    this.alias$1 = alias$1;
                }
            });
            if (!removePrevious) break block0;
            GetAliasesResponse getAliasesResponse = (GetAliasesResponse)client.getAliases(new GetAliasesRequest(new String[]{alias})).actionGet(timeout);
            Iterator indexAliacesToRemove = (Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(getAliasesResponse.getAliases().keysIt()).asScala();
            this.Logger.info(new StringBuilder(21).append("Removing alias ").append(alias).append(" from ").append(indexAliacesToRemove.mkString(", ")).toString());
            indexAliacesToRemove.foreach((Function1)new Serializable(request, alias){
                public static final long serialVersionUID = 0L;
                private final IndicesAliasesRequest request$1;
                private final String alias$1;

                public final IndicesAliasesRequest apply(String indexName) {
                    return this.request$1.addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(indexName).alias(this.alias$1));
                }
                {
                    this.request$1 = request$1;
                    this.alias$1 = alias$1;
                }
            });
        }
        return (AcknowledgedResponse)client.aliases((IndicesAliasesRequest)request.timeout(timeout)).get();
    }

    public Try<AcknowledgedResponse> createOrUpdateAlias(package.ElasticsearchOptions esOptions, String alias, String index, boolean removePrevious, TimeValue timeout) {
        return this.createOrUpdateAlias(esOptions, (Iterable<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)index, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$), alias, removePrevious, timeout);
    }

    public Try<AcknowledgedResponse> createOrUpdateAlias(package.ElasticsearchOptions esOptions, Iterable<Tuple2<String, Object>> indices, String alias, boolean removePrevious, TimeValue timeout) {
        return this.adminClient(esOptions, (Function1)new Serializable(indices, alias, removePrevious, timeout){
            public static final long serialVersionUID = 0L;
            private final Iterable indices$1;
            private final String alias$2;
            private final boolean removePrevious$1;
            private final TimeValue timeout$1;

            public final AcknowledgedResponse apply(AdminClient client) {
                return IndexAdmin$.MODULE$.createOrUpdateAlias(client.indices(), (Iterable<Tuple2<String, Object>>)this.indices$1, this.alias$2, this.removePrevious$1, this.timeout$1);
            }
            {
                this.indices$1 = indices$1;
                this.alias$2 = alias$2;
                this.removePrevious$1 = removePrevious$1;
                this.timeout$1 = timeout$1;
            }
        });
    }

    private IndexAdmin$() {
        MODULE$ = this;
        this.Logger = LoggerFactory.getLogger(this.getClass());
        this.bitmap$init$0 = true;
    }
}

