/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.tensorflow;

import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Ints;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class TFRecordCodec$ {
    public static final TFRecordCodec$ MODULE$ = new TFRecordCodec$();
    private static final int headerLength = 12;
    private static final int footerLength;
    private static final HashFunction crc32c;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        footerLength = 4;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        crc32c = Hashing.crc32c();
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private int headerLength() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-tensorflow/src/main/scala/com/spotify/scio/tensorflow/TFRecordCodec.scala: 32");
        }
        return headerLength;
    }

    private int footerLength() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-tensorflow/src/main/scala/com/spotify/scio/tensorflow/TFRecordCodec.scala: 34");
        }
        return footerLength;
    }

    private HashFunction crc32c() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-tensorflow/src/main/scala/com/spotify/scio/tensorflow/TFRecordCodec.scala: 35");
        }
        return crc32c;
    }

    private int mask(int crc) {
        return (crc >>> 15 | crc << 17) + -1568478504;
    }

    public byte[] read(InputStream input) {
        byte[] byArray;
        byte[] headerBytes = this.readFully(input, this.headerLength());
        if (headerBytes != null) {
            ByteBuffer headerBuf = ByteBuffer.wrap(headerBytes).order(ByteOrder.LITTLE_ENDIAN);
            long length = headerBuf.getLong();
            int maskedCrc32OfLength = headerBuf.getInt();
            Predef$.MODULE$.require(this.hashLong(length) == maskedCrc32OfLength, (Function0)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Invalid masked CRC32 of length";
                }
            });
            byte[] data = this.readFully(input, (int)length);
            byte[] footerBytes = this.readFully(input, this.footerLength());
            ByteBuffer footerBuf = ByteBuffer.wrap(footerBytes).order(ByteOrder.LITTLE_ENDIAN);
            int maskedCrc32OfData = footerBuf.getInt();
            Predef$.MODULE$.require(this.hashBytes(data) == maskedCrc32OfData, (Function0)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Invalid masked CRC32 of data";
                }
            });
            byArray = data;
        } else {
            byArray = null;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readFully(InputStream input, int length) {
        void var3_3;
        byte[] data = (byte[])Array$.MODULE$.ofDim(length, (ClassTag)ClassTag$.MODULE$.Byte());
        int n = 0;
        int off = 0;
        do {
            if ((n = input.read(data, off, data.length - off)) <= 0) continue;
            off += n;
        } while (n > 0 && off < data.length);
        return (byte[])(n <= 0 ? null : var3_3);
    }

    public InputStream wrapInputStream(InputStream stream, Compression compression) {
        PushbackInputStream pushback;
        DeflateParameters deflateParam = new DeflateParameters();
        deflateParam.setWithZlibHeader(true);
        Compression compression2 = compression;
        Object object = Compression.AUTO.equals(compression2) ? (this.isInflaterInputStream(pushback = new PushbackInputStream(stream, 2)) ? new DeflateCompressorInputStream((InputStream)pushback, deflateParam) : (this.isGzipInputStream(pushback) ? new GzipCompressorInputStream((InputStream)pushback) : pushback)) : (Compression.UNCOMPRESSED.equals(compression2) ? stream : Channels.newInputStream(compression.readDecompressed(Channels.newChannel(stream))));
        return object;
    }

    private int hashLong(long x) {
        return this.mask(this.crc32c().hashLong(x).asInt());
    }

    private int hashBytes(byte[] x) {
        return this.mask(this.crc32c().hashBytes(x).asInt());
    }

    private boolean isGzipInputStream(PushbackInputStream pushback) {
        int b1 = pushback.read();
        int b2 = pushback.read();
        if (b2 != -1) {
            pushback.unread(b2);
        }
        if (b1 != -1) {
            pushback.unread(b1);
        }
        byte zero = 0;
        int header = Ints.fromBytes((byte)zero, (byte)zero, (byte)((byte)b2), (byte)((byte)b1));
        return b1 != -1 && b2 != -1 && header == 35615;
    }

    private boolean isInflaterInputStream(PushbackInputStream pushback) {
        int b1 = pushback.read();
        int b2 = pushback.read();
        if (b2 != -1) {
            pushback.unread(b2);
        }
        if (b1 != -1) {
            pushback.unread(b1);
        }
        return b1 != -1 && b2 != -1 && b1 == 120 && (b1 * 256 + b2) % 31 == 0;
    }

    private TFRecordCodec$() {
    }
}

