/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.testing.util;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class DefaultBucket$ {
    public static DefaultBucket$ MODULE$;
    private final FluentBackoff BACKOFF_FACTORY;
    private final String DEFAULT_REGION;
    private final Logger LOG;

    static {
        new DefaultBucket$();
    }

    public String tryCreateDefaultBucket(PipelineOptions options, CloudResourceManager crmClient) {
        GcsOptions gcpOptions = (GcsOptions)options.as(GcsOptions.class);
        String projectId = gcpOptions.getProject();
        Predef$.MODULE$.require(!Strings.isNullOrEmpty((String)projectId), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "--project is a required option.";
            }
        });
        LongRef projectNumber = LongRef.create((long)0L);
        try {
            projectNumber.elem = this.getProjectNumber(projectId, crmClient);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to verify project with ID " + projectId, e);
        }
        String region = this.DEFAULT_REGION();
        if (!Strings.isNullOrEmpty((String)gcpOptions.getZone())) {
            region = this.getRegionFromZone(gcpOptions.getZone());
        }
        String bucketName = "dataflow-staging-" + region + "-" + projectNumber.elem;
        this.LOG().info("No staging location provided, attempting to use default bucket: {}", new Object[]{bucketName});
        Bucket bucket = new Bucket().setName(bucketName).setLocation(region);
        try {
            gcpOptions.getGcsUtil().createBucket(projectId, bucket);
        }
        catch (FileAlreadyExistsException e) {
            this.LOG().debug("Bucket '{}'' already exists, verifying access.", new Object[]{bucketName});
        }
        catch (IOException e) {
            throw new RuntimeException("Unable create default bucket.", e);
        }
        try {
            long owner = gcpOptions.getGcsUtil().bucketOwner(GcsPath.fromComponents((String)bucketName, (String)""));
            Predef$.MODULE$.require(owner == projectNumber.elem, (Function0)new Serializable(projectNumber, owner){
                public static final long serialVersionUID = 0L;
                private final LongRef projectNumber$1;
                private final long owner$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bucket owner does not match the project from --project: ", " vs. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.owner$1), BoxesRunTime.boxToLong((long)this.projectNumber$1.elem)}));
                }
                {
                    this.projectNumber$1 = projectNumber$1;
                    this.owner$1 = owner$1;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine the owner of the default bucket at gs://" + bucketName, e);
        }
        return "gs://" + bucketName;
    }

    private FluentBackoff BACKOFF_FACTORY() {
        return this.BACKOFF_FACTORY;
    }

    private String DEFAULT_REGION() {
        return this.DEFAULT_REGION;
    }

    private Logger LOG() {
        return this.LOG;
    }

    private long getProjectNumber(String projectId, CloudResourceManager crmClient) {
        return this.getProjectNumber(projectId, crmClient, this.BACKOFF_FACTORY().backoff(), Sleeper.DEFAULT);
    }

    private long getProjectNumber(String projectId, CloudResourceManager crmClient, org.apache.beam.sdk.util.BackOff backoff, Sleeper sleeper) {
        long l;
        CloudResourceManager.Projects.Get getProject = crmClient.projects().get(projectId);
        try {
            Project project = (Project)ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)getProject), (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)backoff), (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class, (Sleeper)sleeper);
            l = Predef$.MODULE$.Long2long(project.getProjectNumber());
        }
        catch (Exception e) {
            throw new IOException("Unable to get project number", e);
        }
        return l;
    }

    private String getRegionFromZone(String zone) {
        String[] zoneParts = zone.split("-");
        Predef$.MODULE$.require(zoneParts.length >= 2, (Function0)new Serializable(zone){
            public static final long serialVersionUID = 0L;
            private final String zone$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid zone provided: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zone$1}));
            }
            {
                this.zone$1 = zone$1;
            }
        });
        return zoneParts[0] + "-" + zoneParts[1];
    }

    private DefaultBucket$() {
        MODULE$ = this;
        this.BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.millis((long)200L));
        this.DEFAULT_REGION = "us-central1";
        this.LOG = LoggerFactory.getLogger(GcpOptions.GcpTempLocationFactory.class);
    }
}

